/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import java.util.ArrayList;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySet;
import net.ssehub.easy.instantiation.core.model.vilTypes.IActualTypeProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReturnGenerics;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.UnmodifiableSequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.UnmodifiableSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Attribute;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.DecisionVariable;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.EnumValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IVariableFilter;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlElement;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.ValueVisitor;
import net.ssehub.easy.reasoning.core.frontend.ReasonerAdapter;
import net.ssehub.easy.reasoning.core.impl.ReasonerHelper;
import net.ssehub.easy.reasoning.core.reasoner.Message;
import net.ssehub.easy.reasoning.core.reasoner.ValueCreationResult;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.ContainerVariable;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IConfigurationElement;
import net.ssehub.easy.varModel.confModel.IConfigurationVisitor;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.confModel.IFreezeSelector;
import net.ssehub.easy.varModel.confModel.paths.IResolutionPathElement;
import net.ssehub.easy.varModel.confModel.paths.StartPathElement;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public abstract class AbstractIvmlVariable
extends IvmlElement
implements IActualTypeProvider {
    private static final ValueVisitor VALUE_VISITOR = new ValueVisitor();
    protected IDecisionVariable origVariable;
    protected IDecisionVariable variable;
    protected IVariableFilter filter;
    private DecisionVariable[] nested;
    private Configuration config;

    protected AbstractIvmlVariable(Configuration cfg, IDecisionVariable variable, IVariableFilter filter) {
        AbstractVariable referenced;
        this.origVariable = variable;
        this.variable = variable;
        this.config = cfg;
        this.filter = filter;
        Value val = variable.getValue();
        if (val instanceof ReferenceValue && (referenced = ((ReferenceValue)val).getValue()) != null) {
            net.ssehub.easy.varModel.confModel.Configuration config = variable.getConfiguration();
            this.variable = config.getDecision(referenced);
            if (this.variable == null) {
                this.variable = this.origVariable;
            }
        }
    }

    @Invisible
    public Configuration getConfiguration() {
        return this.config;
    }

    @Invisible
    public boolean isVariable(IDecisionVariable var) {
        return this.origVariable == var || this.variable == var;
    }

    public IvmlElement getParent() {
        IvmlElement result = this.config;
        IConfigurationElement elt = this.variable.getParent();
        if (elt instanceof IDecisionVariable) {
            result = this.config.findVariable((IDecisionVariable)elt);
        }
        return result;
    }

    @Override
    protected void initializeNested() {
        if (this.nested == null) {
            if (this.variable.getNestedElementsCount() > 0) {
                ArrayList<DecisionVariable> tmp = new ArrayList<DecisionVariable>();
                this.nested = new DecisionVariable[this.variable.getNestedElementsCount()];
                int n = 0;
                while (n < this.variable.getNestedElementsCount()) {
                    IDecisionVariable var = this.variable.getNestedElement(n);
                    if (this.filter.isEnabled(var)) {
                        tmp.add(new DecisionVariable(this.config, var, this.filter));
                    }
                    ++n;
                }
                this.nested = tmp.toArray(new DecisionVariable[tmp.size()]);
            } else {
                Value val = this.variable.getValue();
                if (val instanceof ContainerValue) {
                    ContainerValue cont = (ContainerValue)val;
                    this.nested = new DecisionVariable[cont.getElementSize()];
                    int n = 0;
                    while (n < this.nested.length) {
                        this.nested[n] = new DecisionVariable(this.config, new DecVar(this.variable, cont.getElement(n), null), this.filter);
                        ++n;
                    }
                }
            }
        }
    }

    @Invisible
    public IDecisionVariable getVariable() {
        return this.origVariable;
    }

    @Invisible
    public IDatatype getActualType() {
        IDatatype dType = null;
        Value val = this.origVariable.getValue();
        dType = val != null && NullValue.INSTANCE != val ? val.getType() : this.origVariable.getDeclaration().getType();
        return dType;
    }

    @Override
    public String getName() {
        return this.origVariable.getDeclaration().getName();
    }

    @Override
    public String getQualifiedName() {
        return this.origVariable.getDeclaration().getQualifiedName();
    }

    public String getVarName() {
        return this.variable.getDeclaration().getName();
    }

    public String getQualifiedVarName() {
        return this.variable.getDeclaration().getName();
    }

    @Override
    public TypeDescriptor<?> getType() {
        Value value = this.getDecisionVariable().getValue();
        IDatatype type = value != null ? value.getType() : this.getIvmlType();
        return AbstractIvmlVariable.getTypeDescriptor(type);
    }

    @Override
    public String getTypeName() {
        return this.getIvmlType().getName();
    }

    @Invisible
    public IDatatype getIvmlType() {
        return this.variable.getDeclaration().getType();
    }

    @Override
    public String getQualifiedType() {
        return this.origVariable.getDeclaration().getType().getQualifiedName();
    }

    @OperationMeta(name={"isConfigured", "isDefined"})
    public boolean isConfigured() {
        return AssignmentState.UNDEFINED != this.origVariable.getState() && this.origVariable.getValue() != null;
    }

    @OperationMeta(name={"hasConfiguredValue", "hasDefinedValue"})
    boolean hasConfiguredValue() {
        return this.isConfigured() && !this.isNull();
    }

    public boolean isFrozen() {
        return AssignmentState.FROZEN == this.origVariable.getState();
    }

    public void clearValue() {
        try {
            this.origVariable.setValue(null, (IAssignmentState)AssignmentState.UNDEFINED);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public void setValue(Object value) {
        if (!this.isFrozen()) {
            IDecisionVariable toChange = this.variable;
            boolean refVar = Reference.TYPE.isAssignableFrom(this.origVariable.getDeclaration().getType());
            if (value instanceof AbstractIvmlVariable && refVar) {
                IDecisionVariable newVar = ((AbstractIvmlVariable)value).variable;
                toChange = null;
                this.changeValue(this.origVariable, newVar.getDeclaration());
                this.nested = null;
                this.variable = newVar;
            } else if (value == null && refVar) {
                toChange = null;
                this.changeValue(this.origVariable, null);
                this.nested = null;
                this.variable = this.origVariable;
            } else if (value instanceof IvmlElement) {
                value = ((IvmlElement)value).getValue();
            }
            if (toChange != null) {
                this.changeValue(toChange, value);
            }
        } else {
            EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").error("setting " + String.valueOf(value) + " as new value is not possible as variable " + net.ssehub.easy.varModel.confModel.Configuration.getInstanceName((IDecisionVariable)this.variable) + " is frozen");
        }
    }

    private void changeValue(IDecisionVariable toChange, Object value) {
        IDatatype varType;
        if (value == null) {
            value = NullValue.INSTANCE;
        }
        if (TypeQueries.sameTypes((IDatatype)IntegerType.TYPE, (IDatatype)(varType = toChange.getDeclaration().getType())) && value instanceof Double) {
            value = ((Double)value).intValue();
        }
        try {
            Value oldValue = toChange.getValue();
            if (oldValue != null) {
                oldValue = oldValue.clone();
            }
            Value val = value instanceof Value ? (Value)value : ValueFactory.createValue((IDatatype)varType, (Object[])new Object[]{value});
            IAssignmentState varState = toChange.getState();
            if (AssignmentState.UNDEFINED == varState) {
                varState = AssignmentState.USER_ASSIGNED;
            } else if (AssignmentState.ASSIGNED == varState) {
                varState = AssignmentState.USER_ASSIGNED;
            }
            toChange.setValue(val, varState);
            this.config.notifyValueChanged(this, oldValue);
        }
        catch (ConfigurationException e) {
            EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").error("while changing " + this.getName() + " with value " + String.valueOf(value) + ": " + e.getMessage());
        }
        catch (ValueDoesNotMatchTypeException e) {
            EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").error("while changing " + this.getName() + " with value " + String.valueOf(value) + ": " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getOriginalValue() {
        Object result = null;
        Value val = this.config.getChangeHistory().getOriginalValue(this);
        if (val != null) {
            ValueVisitor valueVisitor = VALUE_VISITOR;
            synchronized (valueVisitor) {
                VALUE_VISITOR.clear();
                val.accept((IValueVisitor)VALUE_VISITOR);
                result = VALUE_VISITOR.getValue();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Invisible
    public static Object toObject(Value value) {
        Object result = null;
        if (value != null) {
            ValueVisitor valueVisitor = VALUE_VISITOR;
            synchronized (valueVisitor) {
                VALUE_VISITOR.clear();
                value.accept((IValueVisitor)VALUE_VISITOR);
                result = VALUE_VISITOR.getValue();
            }
        }
        return result;
    }

    @Override
    public Object getValue() {
        return AbstractIvmlVariable.toObject(this.variable.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStringValue() {
        String result = null;
        if (this.variable.getValue() != null) {
            Object o;
            ValueVisitor valueVisitor = VALUE_VISITOR;
            synchronized (valueVisitor) {
                VALUE_VISITOR.clear();
                this.variable.getValue().accept((IValueVisitor)VALUE_VISITOR);
                result = VALUE_VISITOR.getStringValue();
            }
            if (result == null && (o = this.variable.getValue().getValue()) != null) {
                result = o.toString();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getIntegerValue() {
        Integer result = null;
        if (this.variable.getValue() != null) {
            ValueVisitor valueVisitor = VALUE_VISITOR;
            synchronized (valueVisitor) {
                VALUE_VISITOR.clear();
                this.variable.getValue().accept((IValueVisitor)VALUE_VISITOR);
                result = VALUE_VISITOR.getIntegerValue();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double getRealValue() {
        Double result = null;
        if (this.variable.getValue() != null) {
            ValueVisitor valueVisitor = VALUE_VISITOR;
            synchronized (valueVisitor) {
                VALUE_VISITOR.clear();
                this.variable.getValue().accept((IValueVisitor)VALUE_VISITOR);
                result = VALUE_VISITOR.getDoubleValue();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean getBooleanValue() {
        Boolean result = null;
        if (this.variable.getValue() != null) {
            ValueVisitor valueVisitor = VALUE_VISITOR;
            synchronized (valueVisitor) {
                VALUE_VISITOR.clear();
                this.variable.getValue().accept((IValueVisitor)VALUE_VISITOR);
                result = VALUE_VISITOR.getBooleanValue();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumValue getEnumValue() {
        EnumValue result = null;
        if (this.variable.getValue() != null) {
            ValueVisitor valueVisitor = VALUE_VISITOR;
            synchronized (valueVisitor) {
                VALUE_VISITOR.clear();
                this.variable.getValue().accept((IValueVisitor)VALUE_VISITOR);
                result = VALUE_VISITOR.getEnumValue();
            }
        }
        return result;
    }

    @ReturnGenerics(value={DecisionVariable.class})
    public Sequence<DecisionVariable> variables() {
        this.initializeNested();
        return new UnmodifiableSequence<DecisionVariable>(new ArraySequence<DecisionVariable>(this.nested, DecisionVariable.class));
    }

    @Invisible
    @ReturnGenerics(value={DecisionVariable.class})
    public Set<DecisionVariable> variablesSet() {
        this.initializeNested();
        return new UnmodifiableSet<DecisionVariable>(new ArraySet<DecisionVariable>(this.nested, DecisionVariable.class));
    }

    public Configuration selectAll() {
        this.initializeNested();
        return new Configuration(this.variable.getConfiguration(), this.nested, this.filter);
    }

    @ReturnGenerics(value={Attribute.class})
    public abstract Set<Attribute> attributes();

    @ReturnGenerics(value={Attribute.class})
    public abstract Set<Attribute> annotations();

    public int hashCode() {
        return this.variable.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof AbstractIvmlVariable && this.variable.equals(((AbstractIvmlVariable)object).variable);
    }

    @Override
    public IvmlElement getElement(String name) {
        this.initializeNested();
        this.initializeAttributes();
        IvmlElement result = this.search(name, this.nested);
        if (result == null) {
            int a = 0;
            while (result == null && a < this.getAttributeCount()) {
                result = this.checkElement(name, this.getAttribute(a));
                ++a;
            }
        }
        return result;
    }

    public DecisionVariable getByName(String name) {
        IvmlElement elt = this.getElement(name);
        DecisionVariable result = elt instanceof DecisionVariable ? (DecisionVariable)elt : null;
        return result;
    }

    @Invisible
    public IDecisionVariable getDecisionVariable() {
        return this.variable;
    }

    public IvmlDeclaration getDeclaration() {
        return new IvmlDeclaration(this.variable.getDeclaration());
    }

    @Override
    @Invisible
    public String getInstanceName() {
        return net.ssehub.easy.varModel.confModel.Configuration.getInstanceName((IDecisionVariable)this.getVariable());
    }

    private EASyLoggerFactory.EASyLogger getLogger() {
        return EASyLoggerFactory.INSTANCE.getLogger(AbstractIvmlVariable.class, "net.ssehub.easy.instantiation.core");
    }

    public void createValue(boolean override) {
        this.createValue(this.getType(), override);
    }

    public void createValue(TypeDescriptor<?> type, boolean override) {
        if (this.variable != null && (override || !override && !this.isConfigured()) && type instanceof IvmlTypeDescriptor) {
            IDatatype t = ((IvmlTypeDescriptor)type).getIvmlType();
            if (this.variable.getDeclaration().getType().isAssignableFrom(t)) {
                this.createValue(this.variable, t);
            } else {
                this.getLogger().warn("given type is not compatible to variable type");
            }
        }
    }

    private void createValue(IDecisionVariable var, IDatatype type) {
        ValueCreationResult vRes = ReasonerAdapter.getInstanceSafe().createValue(var.getConfiguration().getConfiguration(), var.getDeclaration(), type, null, ProgressObserver.NO_OBSERVER);
        int m = 0;
        while (m < vRes.getMessageCount()) {
            Message msg = vRes.getMessage(m);
            this.getLogger().warn(msg.getDescription());
            ++m;
        }
        if (vRes.getVariable() != null) {
            AbstractIvmlVariable.transferState(vRes.getVariable(), var);
            try {
                var.setValue(vRes.getVariable().getValue(), (IAssignmentState)AssignmentState.ASSIGNED);
            }
            catch (ConfigurationException e) {
                this.getLogger().warn(e.getMessage());
            }
        }
    }

    private static void transferState(IDecisionVariable source, IDecisionVariable target) {
        if (source.getState() != target.getState()) {
            if (AssignmentState.FROZEN == target.getState()) {
                if (source.getConfiguration().getConfiguration().isApproximatelyFrozen()) {
                    target.unfreeze(source.getState());
                }
            } else {
                try {
                    target.setValue(source.getValue(), source.getState());
                }
                catch (ConfigurationException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(ReasonerHelper.class, "net.ssehub.easy.instantiation.core").warn("transferState: " + e.getMessage());
                }
            }
        }
        int a = 0;
        while (a < source.getAttributesCount()) {
            IDecisionVariable sAttr = source.getAttribute(a);
            IDecisionVariable tAttr = target.getAttribute(a);
            AbstractIvmlVariable.transferState(sAttr, tAttr);
            ++a;
        }
        int n = 0;
        while (n < source.getNestedElementsCount()) {
            IDecisionVariable sNested = source.getNestedElement(n);
            IDecisionVariable tNested = target.getNestedElement(sNested.getDeclaration().getName());
            if (tNested == null) {
                tNested = target.getNestedElement(n);
            }
            if (tNested != null) {
                AbstractIvmlVariable.transferState(sNested, tNested);
            }
            ++n;
        }
    }

    public DecisionVariable addValue() {
        DecisionVariable result = null;
        if (this.variable != null) {
            IDatatype vType = DerivedDatatype.resolveToBasis((IDatatype)this.variable.getDeclaration().getType());
            if (Container.TYPE.isAssignableFrom(vType) && vType.getGenericTypeCount() > 0) {
                result = this.addValue(vType.getGenericType(0));
            } else {
                this.getLogger().warn("given type is not a container");
            }
        }
        return result;
    }

    public DecisionVariable addValue(TypeDescriptor<?> type) {
        DecisionVariable result = null;
        if (this.variable != null && type instanceof IvmlTypeDescriptor) {
            IDatatype vType = DerivedDatatype.resolveToBasis((IDatatype)this.variable.getDeclaration().getType());
            if (Container.TYPE.isAssignableFrom(vType) && vType.getGenericTypeCount() > 0) {
                IDatatype iType = ((IvmlTypeDescriptor)type).getIvmlType();
                if (vType.getGenericType(0).isAssignableFrom(iType)) {
                    result = this.addValue(iType);
                } else {
                    this.getLogger().warn("given type is not compatible to container element type");
                }
            } else {
                this.getLogger().warn("given type is not a container");
            }
        }
        return result;
    }

    private DecisionVariable addValue(IDatatype type) {
        DecisionVariable result = null;
        if (this.variable instanceof ContainerVariable) {
            ContainerVariable cVariable = (ContainerVariable)this.variable;
            IDecisionVariable var = cVariable.addNestedElement(type);
            this.createValue(var, type);
            if (this.filter.isEnabled(var)) {
                result = new DecisionVariable(this.config, var, this.filter);
                int nestedLength = this.nested == null ? 0 : this.nested.length;
                DecisionVariable[] tmp = new DecisionVariable[nestedLength + 1];
                if (this.nested != null) {
                    System.arraycopy(this.nested, 0, tmp, 0, nestedLength);
                }
                tmp[nestedLength] = result;
                this.nested = tmp;
            }
        }
        return result;
    }

    public String toString() {
        AbstractVariable decl = this.variable.getDeclaration();
        Object result = decl == null || this.variable.getValue() == null ? "<null>" : decl.getType().toString() + " " + decl.getName() + " = " + this.variable.getValue().toString();
        return result;
    }

    @Override
    @Invisible
    public IDatatype determineActualTypeName() {
        IDatatype type;
        IDatatype declType = this.getDecisionVariable().getDeclaration().getType();
        IDatatype actType = this.getActualType();
        if (TypeQueries.isCompound((IDatatype)declType) && !TypeQueries.isReference((IDatatype)actType)) {
            type = actType;
        } else if (TypeQueries.isCompound((IDatatype)declType) && TypeQueries.isReference((IDatatype)actType)) {
            type = declType;
            if (this.variable != null && this.variable.getValue() != null && type.isAssignableFrom(this.variable.getValue().getType())) {
                type = this.variable.getValue().getType();
            }
        } else {
            type = declType;
        }
        return type;
    }

    private static class DecVar
    implements IDecisionVariable {
        private IDecisionVariable parent;
        private Value value;
        private DecisionVariableDeclaration decl;
        private IDecisionVariable[] nested;

        private DecVar(IDecisionVariable parent, Value value, DecisionVariableDeclaration decl) {
            this.parent = parent;
            this.value = value;
            this.decl = decl == null ? new DecisionVariableDeclaration("", value.getType(), parent.getDeclaration().getParent()) : decl;
        }

        private void initializeNested() {
            block2: {
                block3: {
                    if (this.nested != null) break block2;
                    if (!(this.value instanceof CompoundValue)) break block3;
                    CompoundValue comp = (CompoundValue)this.value;
                    Compound type = (Compound)comp.getType();
                    this.nested = new IDecisionVariable[type.getElementCount()];
                    int i = 0;
                    while (i < this.nested.length) {
                        DecisionVariableDeclaration d = type.getElement(i);
                        this.nested[i] = new DecVar(this, comp.getNestedValue(d.getName()), d);
                        ++i;
                    }
                    break block2;
                }
                if (!(this.value instanceof ContainerValue)) break block2;
                ContainerValue cont = (ContainerValue)this.value;
                this.nested = new IDecisionVariable[cont.getElementSize()];
                int i = 0;
                while (i < this.nested.length) {
                    this.nested[i] = new DecVar(this, cont.getElement(i), null);
                    ++i;
                }
            }
        }

        public IConfigurationElement getParent() {
            return this.parent;
        }

        public net.ssehub.easy.varModel.confModel.Configuration getConfiguration() {
            return this.parent.getConfiguration();
        }

        public boolean isNested() {
            return true;
        }

        public IAssignmentState getState() {
            return this.parent.getState();
        }

        public void setValue(Value value, IAssignmentState state, IConfigurationElement nested) throws ConfigurationException {
        }

        public void freeze(IFreezeSelector selector) {
        }

        public void unfreeze(IAssignmentState state) {
        }

        public void freeze(String nestedElement) {
        }

        public AbstractVariable getDeclaration() {
            return this.decl;
        }

        public void accept(IConfigurationVisitor visitor) {
            visitor.visitDecisionVariable((IDecisionVariable)this);
        }

        public Value getValue() {
            return this.value;
        }

        public void setValue(Value value, IAssignmentState state) throws ConfigurationException {
        }

        public void setValue(Value value, IAssignmentState state, boolean asAssignment) throws ConfigurationException {
        }

        public void setHistoryValue(Value value, IAssignmentState state) throws ConfigurationException {
        }

        public int getNestedElementsCount() {
            this.initializeNested();
            return this.nested == null ? 0 : this.nested.length;
        }

        public IDecisionVariable getNestedElement(int index) {
            this.initializeNested();
            if (this.nested == null) {
                throw new IndexOutOfBoundsException();
            }
            return this.nested[index];
        }

        public IDecisionVariable getNestedElement(String name) {
            return net.ssehub.easy.varModel.confModel.Configuration.getNestedElement((IDecisionVariable)this, (String)name);
        }

        public int getAttributesCount() {
            return this.parent.getAttributesCount();
        }

        public IDecisionVariable getAttribute(int index) {
            return this.parent.getAttribute(index);
        }

        public int getNestedDepth() {
            return 0;
        }

        public boolean isVisible() {
            return false;
        }

        public boolean hasValue() {
            return this.value != null;
        }

        public boolean hasNullValue() {
            return this.value == null || NullValue.INSTANCE == this.value;
        }

        public boolean removeDerivedValues() {
            return false;
        }

        public String getQualifiedName() {
            return this.getDeclaration().getQualifiedName();
        }

        public IResolutionPathElement getResolutionPath() {
            return new StartPathElement(this.getDeclaration());
        }

        public boolean isLocal() {
            return false;
        }

        public boolean wasCreated() {
            return true;
        }

        public void notifyCreated() {
        }

        public boolean notifyWasAssigned(Value value) {
            return false;
        }

        public boolean wasAssigned() {
            return true;
        }

        public boolean enableWasAssignedForIsDefined() {
            return false;
        }
    }
}

