/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.AbstractIvmlVariable;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Attribute;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.DecisionVariable;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IVariableFilter;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlElement;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.IConfiguration;
import net.ssehub.easy.varModel.confModel.IConfigurationElement;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.Value;

class ConfigurationContextResolver {
    private Configuration configuration;
    private Set<AbstractIvmlVariable> changed;
    private List<DecisionVariable> variables = new ArrayList<DecisionVariable>();
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private HashFilter filter = new HashFilter();
    private ResolutionList resolve = new ResolutionList();

    public ConfigurationContextResolver(Configuration configuration, Set<AbstractIvmlVariable> changed) {
        this.configuration = configuration;
        this.changed = changed;
    }

    public void resolve() {
        for (AbstractIvmlVariable var : this.changed) {
            this.augment(var.getVariable(), false);
        }
        Map<AbstractVariable, List<IDecisionVariable>> referenced = this.collectReferences();
        int r = 0;
        while (r < this.resolve.size()) {
            IDecisionVariable var = this.resolve.get(r);
            List<IDecisionVariable> dependent = referenced.get(var.getDeclaration());
            if (dependent != null) {
                for (IDecisionVariable dVar : dependent) {
                    this.augment(dVar, false);
                }
            }
            ++r;
        }
    }

    private void map(IDecisionVariable var, boolean viaParent) {
        if (!this.resolve.contains(var)) {
            if (!viaParent || viaParent && !Container.TYPE.isAssignableFrom(var.getDeclaration().getType())) {
                int n = 0;
                while (n < var.getNestedElementsCount()) {
                    IDecisionVariable nested = var.getNestedElement(n);
                    this.mapVar(nested, false, viaParent);
                    ++n;
                }
            }
            this.mapVar(var, true, viaParent);
        }
    }

    private void mapVar(IDecisionVariable var, boolean resolve, boolean viaParent) {
        boolean follow = false;
        if (!this.filter.filterMap.contains(var)) {
            ReferenceValue val;
            Value value;
            if (AssignmentState.FROZEN == var.getState()) {
                this.createVilInstance(var, this.configuration);
                if (resolve) {
                    this.resolve.add(var);
                }
                follow = true;
            } else {
                this.createVilInstance(var, this.configuration);
                follow = true;
            }
            if (follow && Reference.TYPE.isAssignableFrom(var.getDeclaration().getType()) && (value = var.getValue()) instanceof ReferenceValue && (val = (ReferenceValue)value) != null && val.getValue() != null) {
                IDecisionVariable refVar = this.configuration.getConfiguration().getDecision(val.getValue());
                this.augment(refVar, viaParent);
            }
            int a = 0;
            while (a < var.getAttributesCount()) {
                this.mapVar(var.getAttribute(a), resolve, viaParent);
                ++a;
            }
        }
    }

    private AbstractIvmlVariable createVilInstance(IDecisionVariable decVar, Configuration configuration) {
        IvmlElement elt = configuration.get(decVar.getDeclaration().getQualifiedName());
        AbstractIvmlVariable result = elt instanceof AbstractIvmlVariable ? (AbstractIvmlVariable)elt : new DecisionVariable(configuration, decVar, this.filter);
        this.filter.filterMap.add(decVar);
        if (decVar.getParent() instanceof IConfiguration) {
            if (result instanceof DecisionVariable) {
                this.variables.add((DecisionVariable)result);
            } else if (result instanceof Attribute) {
                this.attributes.add((Attribute)result);
            }
        }
        return result;
    }

    private void augment(IDecisionVariable dVar, boolean viaParent) {
        if (dVar != null && !this.resolve.contains(dVar)) {
            this.map(dVar, viaParent);
            IConfigurationElement par = dVar.getParent();
            while (par instanceof IDecisionVariable) {
                IDecisionVariable pVar = (IDecisionVariable)par;
                this.map(pVar, true);
                par = par.getParent();
            }
        }
    }

    private Map<AbstractVariable, List<IDecisionVariable>> collectReferences() {
        HashMap<AbstractVariable, List<IDecisionVariable>> result = new HashMap<AbstractVariable, List<IDecisionVariable>>();
        for (IDecisionVariable var : this.configuration.getConfiguration()) {
            int n = 0;
            while (n < var.getNestedElementsCount()) {
                this.collectReferences(var.getNestedElement(n), result);
                ++n;
            }
            this.collectReferences(var, result);
        }
        return result;
    }

    private void collectReferences(IDecisionVariable var, Map<AbstractVariable, List<IDecisionVariable>> references) {
        ContainerValue val;
        Value value;
        IDatatype type = var.getDeclaration().getType();
        if (Reference.TYPE.isAssignableFrom(type)) {
            this.collectReference(var, var.getValue(), references);
        } else if (Container.TYPE.isAssignableFrom(type) && (value = var.getValue()) instanceof ContainerValue && (val = (ContainerValue)value) != null) {
            int e = 0;
            while (e < val.getElementSize()) {
                this.collectReference(var, val.getElement(e), references);
                ++e;
            }
        }
    }

    private void collectReference(IDecisionVariable var, Value val, Map<AbstractVariable, List<IDecisionVariable>> references) {
        AbstractVariable refVar;
        if (val instanceof ReferenceValue && (refVar = ((ReferenceValue)val).getValue()) != null) {
            List<IDecisionVariable> values = references.get(refVar);
            if (values == null) {
                values = new ArrayList<IDecisionVariable>();
                references.put(refVar, values);
            }
            values.add(var);
        }
    }

    public DecisionVariable[] variables() {
        return this.variables.toArray(new DecisionVariable[this.variables.size()]);
    }

    public Attribute[] attributes() {
        return this.attributes.toArray(new Attribute[this.attributes.size()]);
    }

    public IVariableFilter filter() {
        return this.filter;
    }

    private class HashFilter
    implements IVariableFilter {
        private Set<IDecisionVariable> filterMap = new HashSet<IDecisionVariable>();

        private HashFilter() {
        }

        @Override
        public boolean isEnabled(IDecisionVariable variable) {
            return this.filterMap.contains(variable);
        }
    }

    private static class ResolutionList {
        private List<IDecisionVariable> list = new LinkedList<IDecisionVariable>();
        private Set<IDecisionVariable> set = new HashSet<IDecisionVariable>();

        private ResolutionList() {
        }

        public void add(IDecisionVariable var) {
            if (!this.set.contains(var)) {
                this.list.add(var);
                this.set.add(var);
            }
        }

        public boolean contains(IDecisionVariable var) {
            return this.set.contains(var);
        }

        public int size() {
            return this.list.size();
        }

        public IDecisionVariable get(int index) {
            return this.list.get(index);
        }
    }
}

