/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.IDirectTypeRegistryAccess;
import net.ssehub.easy.instantiation.core.model.vilTypes.ITypeResolver;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.FakeTypeDescriptor;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;

public class IvmlBaseTypeResolver
implements ITypeResolver {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(IvmlBaseTypeResolver.class, "net.ssehub.easy.instantiation.core");
    private IDirectTypeRegistryAccess access;
    private TypeRegistry typeRegistry;

    public IvmlBaseTypeResolver(TypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    @Override
    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    @Override
    public TypeDescriptor<?> resolveType(String name, boolean addIfMissing) {
        FakeTypeDescriptor result = null;
        if (addIfMissing) {
            try {
                result = new FakeTypeDescriptor(this.typeRegistry, name);
                this.addType(name, result);
            }
            catch (VilException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        return result;
    }

    @Override
    public TypeDescriptor<?> resolveType(IDatatype type) {
        if (!this.isKnown(type.getQualifiedName())) {
            this.resolveType(type.getQualifiedName(), true);
        }
        return this.resolveType(type.getName(), true);
    }

    @Override
    public TypeDescriptor<? extends IVilType> resolveInstantiator(String name) {
        return null;
    }

    @Override
    public void setRegistryAccess(IDirectTypeRegistryAccess access) {
        this.access = access;
    }

    public boolean isKnown(String name) {
        return this.access.contains(name);
    }

    protected void addType(String name, TypeDescriptor<?> type) {
        if (!this.isKnown(name)) {
            this.access.add(name, type);
        }
    }

    protected IDirectTypeRegistryAccess getRegistryAccess() {
        return this.access;
    }
}

