/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import java.util.ArrayList;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationType;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.EnumValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlOperationDescriptor;

public class IvmlOrderedEnumMinMaxOperationDescriptor
extends IvmlOperationDescriptor {
    private OperationKind operation;

    IvmlOrderedEnumMinMaxOperationDescriptor() {
        super(null, null, false);
    }

    IvmlOrderedEnumMinMaxOperationDescriptor(TypeDescriptor<?> declaringType, OperationKind operation) {
        super(declaringType, operation.getOperationName(), false);
        this.operation = operation == null ? OperationKind.MIN : operation;
        ArrayList parameters = new ArrayList();
        parameters.add(declaringType);
        parameters.add(declaringType);
        this.setParameters(parameters, false, false);
        this.setReturnType(declaringType);
        this.setCharacteristics(OperationType.FUNCTION, OperationDescriptor.AliasType.NONE, false, operation.getOperationName());
    }

    @Override
    public IMetaOperation.CompatibilityResult isCompatible(Class<?> retType, Object ... params) {
        return IMetaOperation.CompatibilityResult.COMPATIBLE;
    }

    @Override
    public Object invoke(Object ... args) throws VilException {
        EnumValue result = null;
        if (args != null && args.length == 2) {
            EnumValue a0 = IvmlOrderedEnumMinMaxOperationDescriptor.convertArgument(args[0], EnumValue.class);
            EnumValue a1 = IvmlOrderedEnumMinMaxOperationDescriptor.convertArgument(args[1], EnumValue.class);
            if (a0 != null && a1 != null) {
                switch (this.operation) {
                    case MIN: {
                        result = this.min(a0, a1);
                        break;
                    }
                    case MAX: {
                        result = this.max(a0, a1);
                        break;
                    }
                    default: {
                        result = null;
                    }
                }
            }
        }
        return result;
    }

    private EnumValue min(EnumValue v1, EnumValue v2) {
        EnumValue result = v1.getOrdinal() <= v2.getOrdinal() ? v1 : v2;
        return result;
    }

    private EnumValue max(EnumValue v1, EnumValue v2) {
        EnumValue result = v1.getOrdinal() >= v2.getOrdinal() ? v1 : v2;
        return result;
    }

    public static enum OperationKind {
        MIN("min"),
        MAX("max");

        private String opName;

        private OperationKind(String opName) {
            this.opName = opName;
        }

        public String getOperationName() {
            return this.opName;
        }
    }
}

