/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.DecisionVariable;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlOperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Utils;

public class IvmlSetConversionOperationDescriptor
extends IvmlOperationDescriptor {
    public static final String NAME = "convertToSet";
    private static final TypeDescriptor<?> RETURN;

    static {
        TypeDescriptor<Object> returnType;
        try {
            TypeDescriptor<?>[] types = TypeDescriptor.createArray(1);
            types[0] = IvmlTypes.decisionVariableType();
            returnType = TypeRegistry.getSetType(types);
        }
        catch (VilException e) {
            returnType = TypeRegistry.anyType();
        }
        RETURN = returnType;
    }

    IvmlSetConversionOperationDescriptor() {
        this(null, null);
    }

    IvmlSetConversionOperationDescriptor(TypeDescriptor<?> declaringType) {
        this(declaringType, null);
    }

    IvmlSetConversionOperationDescriptor(TypeDescriptor<?> declaringType, TypeDescriptor<?> generic) {
        super(declaringType, NAME, false);
        if (generic != null) {
            TypeDescriptor<?>[] types = TypeDescriptor.createArray(1);
            types[0] = generic;
            try {
                this.setReturnType(TypeRegistry.getSetType(types));
            }
            catch (VilException e) {
                this.setReturnType(TypeRegistry.anyType());
            }
        } else {
            this.setReturnType(RETURN);
        }
        this.setParameters(IvmlSetConversionOperationDescriptor.createParameterList(declaringType), false, false);
        this.setCharacteristics(OperationType.NORMAL, OperationDescriptor.AliasType.NONE, true, NAME);
    }

    @Override
    public IMetaOperation.CompatibilityResult isCompatible(Class<?> retType, Object ... params) {
        return Utils.isCompatible(params, DecisionVariable.class);
    }

    @Override
    public Object invoke(Object ... args) throws VilException {
        Set<DecisionVariable> result = args[0] instanceof Set ? args[0] : ((DecisionVariable)args[0]).variablesSet();
        return result;
    }
}

