/*
 * Decompiled with CFR 0.152.
 */
package au.com.jcloud.lxd.service.impl;

import au.com.jcloud.lxd.model.Certificate;
import au.com.jcloud.lxd.model.Container;
import au.com.jcloud.lxd.model.Image;
import au.com.jcloud.lxd.model.ImageAlias;
import au.com.jcloud.lxd.model.Network;
import au.com.jcloud.lxd.model.Profile;
import au.com.jcloud.lxd.model.ServerInfo;
import au.com.jcloud.lxd.service.ILinuxCliService;
import au.com.jcloud.lxd.service.ILxdService;
import au.com.jcloud.lxd.service.impl.LxdServiceImpl;
import java.io.IOException;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;

@Named
public class LxdServiceCliImpl
extends LxdServiceImpl
implements ILxdService {
    private ILinuxCliService linuxCliService;

    public ServerInfo loadServerInfo() throws IOException, InterruptedException {
        return super.loadServerInfo();
    }

    public void deleteImage(String imageOrId) throws IOException, InterruptedException {
        this.linuxCliService.executeLinuxCmd("lxc image delete " + imageOrId);
    }

    public void startContainer(String name) throws IOException, InterruptedException {
        this.linuxCliService.executeLinuxCmd("lxc start " + name);
    }

    public void stopContainer(String name) throws IOException, InterruptedException {
        this.linuxCliService.executeLinuxCmd("lxc stop " + name);
    }

    public void deleteContainer(String name) throws IOException, InterruptedException {
        this.linuxCliService.executeLinuxCmd("lxc delete " + name);
    }

    public void createContainer(String newContainerName, String imageAlias) throws IOException, InterruptedException {
        this.linuxCliService.executeLinuxCmd("lxc launch " + imageAlias + " " + newContainerName);
    }

    public void execOnContainer(String name, String[] commandAndArgs, String env, Boolean waitForSocket) throws IOException, InterruptedException {
        this.linuxCliService.executeLinuxCmd("lxc exec " + name + " " + StringUtils.join((Object[])commandAndArgs, (String)" "));
    }

    public void createSnapshot(String containerName, String snapshotName) throws IOException, InterruptedException {
        super.createSnapshot(containerName, snapshotName);
    }

    public void deleteSnapshot(String containerName, String snapshotName) throws IOException, InterruptedException {
        super.deleteSnapshot(containerName, snapshotName);
    }

    public ImageAlias loadImageAlias(String name) throws IOException, InterruptedException {
        return super.loadImageAlias(name);
    }

    public String loadFile(String containerName, String filepath) throws IOException, InterruptedException {
        this.linuxCliService.executeLinuxCmd("lxc file pull " + containerName + filepath + " .");
        return "";
    }

    public Container loadContainer(String name) throws IOException, InterruptedException {
        return super.loadContainer(name);
    }

    public Image loadImage(String nameOrId) throws IOException, InterruptedException {
        return super.loadImage(nameOrId);
    }

    public Network loadNetwork(String name) throws IOException, InterruptedException {
        return super.loadNetwork(name);
    }

    public void deleteNetwork(String name) throws IOException, InterruptedException {
        super.deleteNetwork(name);
    }

    public Profile loadProfile(String name) throws IOException, InterruptedException {
        return super.loadProfile(name);
    }

    public void deleteProfile(String name) throws IOException, InterruptedException {
        super.deleteProfile(name);
    }

    public Certificate loadCertificate(String name) throws IOException, InterruptedException {
        return super.loadCertificate(name);
    }

    public void setLinuxCliService(ILinuxCliService linuxCliService) {
        this.linuxCliService = linuxCliService;
    }
}

