/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.docker.instantiators;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.defaultInstantiators.AbstractFileInstantiator;
import net.ssehub.easy.instantiation.core.model.execution.IInstantiatorTracer;
import org.apache.commons.lang.SystemUtils;

public abstract class AbstractDockerInstantiator
extends AbstractFileInstantiator {
    protected static final boolean FAIL_ON_ERROR = Boolean.valueOf(System.getProperty("easy.docker.failOnError", "true"));
    protected static final String SKIP_ID = System.getProperty("easy.docker.skip");
    private static final String DOCKER_HOST = System.getProperty("easy.docker.host", SystemUtils.IS_OS_WINDOWS ? "unix:///var/run/docker.sock" : "unix:///var/run/docker.sock");

    protected static DockerClient createClient() {
        DefaultDockerClientConfig standardConfig = DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost(DOCKER_HOST).build();
        ApacheDockerHttpClient httpClient = new ApacheDockerHttpClient.Builder().dockerHost(standardConfig.getDockerHost()).sslConfig((SSLConfig)standardConfig.getSSLConfig()).build();
        return DockerClientImpl.getInstance((DockerClientConfig)standardConfig, (DockerHttpClient)httpClient);
    }

    static void handleThrowable(Throwable th, IInstantiatorTracer tracer, String task) throws VilException {
        if (th != null && FAIL_ON_ERROR) {
            tracer.traceMessage(task + "failed: " + th.getMessage());
            throw new VilException(th.getMessage(), 50502);
        }
    }

    static boolean skip() {
        return SKIP_ID != null && SKIP_ID.length() > 0;
    }
}

