/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.docker.instantiators;

import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.api.model.AuthResponse;
import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.docker.instantiators.AbstractDockerInstantiator;

@Instantiator(value="dockerLogin")
public class DockerLogin
extends AbstractDockerInstantiator {
    private static Map<String, AuthConfig> authConfig = new HashMap<String, AuthConfig>();

    static AuthConfigurations getAuthConfigs() {
        AuthConfigurations result;
        if (authConfig.size() > 0) {
            result = new AuthConfigurations();
            for (AuthConfig c : authConfig.values()) {
                result.addConfig(c);
            }
        } else {
            result = null;
        }
        return result;
    }

    static AuthConfig getAuthConfig(String registryAddress) {
        return authConfig.get(registryAddress);
    }

    static void addConfig(AuthConfig config) {
        authConfig.put(config.getRegistryAddress(), config);
    }

    static boolean clear(String registryAddress) {
        return authConfig.remove(registryAddress) != null;
    }

    static void clear() {
        authConfig.clear();
    }

    public static boolean dockerLogin(String registry, String user, String password) throws VilException {
        if (DockerLogin.skip()) {
            return true;
        }
        try {
            AuthConfig tmp = new AuthConfig().withRegistryAddress(registry).withUsername(user).withPassword(password);
            AuthResponse response = DockerLogin.createClient().authCmd().withAuthConfig(tmp).exec();
            boolean ok = response.getStatus().equalsIgnoreCase("Login Succeeded");
            if (ok) {
                DockerLogin.addConfig(tmp);
            }
            return ok;
        }
        catch (Exception e) {
            if (FAIL_ON_ERROR) {
                throw new VilException((Throwable)e, 50502);
            }
            return false;
        }
    }
}

