/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.docker.instantiators;

import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthResponse;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.docker.instantiators.AbstractDockerInstantiator;

@Instantiator(value="dockerLoginByToken")
public class DockerLoginByToken
extends AbstractDockerInstantiator {
    private static AuthConfig authConfig;

    static AuthConfig getAuthConfig() {
        return authConfig;
    }

    static void clear() {
        authConfig = null;
    }

    public static boolean dockerLoginByToken(String registry, String user, String token) throws VilException {
        if (DockerLoginByToken.skip()) {
            return true;
        }
        try {
            AuthConfig tmp = new AuthConfig().withRegistryAddress(registry).withUsername(user).withIdentityToken(token);
            AuthResponse response = DockerLoginByToken.createClient().authCmd().withAuthConfig(tmp).exec();
            boolean ok = response.getStatus().equalsIgnoreCase("Login Succeeded");
            if (ok) {
                authConfig = tmp;
            }
            return ok;
        }
        catch (Exception e) {
            if (FAIL_ON_ERROR) {
                throw new VilException((Throwable)e, 50502);
            }
            return false;
        }
    }
}

