/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.docker.instantiators;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.PushResponseItem;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.execution.IInstantiatorTracer;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.docker.instantiators.AbstractDockerInstantiator;
import net.ssehub.easy.instantiation.docker.instantiators.DockerLogin;

@Instantiator(value="dockerPushImage")
public class DockerPushImage
extends AbstractDockerInstantiator {
    public static boolean dockerPushImage(String imageName, String registry, String repository, String tag) throws VilException {
        if (DockerPushImage.skip()) {
            return true;
        }
        IInstantiatorTracer tracer = TracerFactory.getInstance().createInstantiatorTracerImpl();
        try {
            long start = System.currentTimeMillis();
            if (!imageName.equals(registry + "/" + repository)) {
                tracer.traceMessage("Tagging image " + imageName + " as " + registry + "/" + repository + " with " + tag);
                DockerPushImage.createClient().tagImageCmd(imageName, registry + "/" + repository, tag).exec();
            }
            tracer.traceMessage("Pushing docker image " + imageName + " as " + registry + "/" + repository + ":" + tag + ". Please wait...");
            PushImageCmd cmd = DockerPushImage.createClient().pushImageCmd(registry + "/" + repository + ":" + tag);
            AuthConfig cfg = DockerLogin.getAuthConfig(registry);
            if (cfg != null) {
                cmd.withAuthConfig(cfg);
            }
            String taskDescription = "Docker push";
            TracerFactory.ensureTasks((String)"Docker push");
            final AtomicInteger count = new AtomicInteger(0);
            final AtomicReference cbThrowable = new AtomicReference();
            (cmd.exec((ResultCallback)new ResultCallback.Adapter<PushResponseItem>(){

                public void onNext(PushResponseItem item) {
                    super.onNext((Object)item);
                    EASyLoggerFactory.INSTANCE.getLogger(((Object)((Object)this)).getClass(), "docker").info("Docker response Docker push: " + item.getId() + " " + item.getStatus());
                    int cnt = count.incrementAndGet();
                    TracerFactory.progressSubTask((int)cnt, (int)(cnt + 1), (String)"Docker push");
                }

                public void onError(Throwable th) {
                    cbThrowable.set(th);
                }
            })).awaitCompletion();
            TracerFactory.closeTasks((String)"Docker push");
            DockerPushImage.handleThrowable((Throwable)cbThrowable.get(), tracer, DockerPushImage.getTask(imageName));
            tracer.traceMessage(DockerPushImage.getTask(imageName) + " completed in " + (System.currentTimeMillis() - start) + " ms.");
            return true;
        }
        catch (Exception e) {
            DockerPushImage.handleThrowable(e, tracer, DockerPushImage.getTask(imageName));
            return false;
        }
    }

    private static String getTask(String name) {
        return "Pushing docker image " + name;
    }
}

