/*
 * Decompiled with CFR 0.152.
 */
package au.com.jcloud.lxd.service;

import au.com.jcloud.lxd.bean.ImageConfig;
import au.com.jcloud.lxd.bean.LxdServerCredential;
import au.com.jcloud.lxd.enums.LxdCall;
import au.com.jcloud.lxd.enums.RemoteServer;
import au.com.jcloud.lxd.service.ILinuxCliService;
import java.io.IOException;
import java.util.Map;

public interface ILxdApiService {
    public static final String CURL_URL_BASE_REMOTE = "curl -s -k ${KEYPATHCERT} ${KEYPATHKEY} https://${HOSTANDPORT}";
    public static final String CURL_URL_BASE_LOCAL = "curl -s --unix-socket /var/snap/lxd/common/lxd/unix.socket a";
    public static final String URL_GET_SERVERINFO = "/1.0";
    public static final String URL_GET_CONTAINER = "/1.0/containers";
    public static final String URL_GET_IMAGE = "/1.0/images";
    public static final String URL_GET_IMAGEALIAS = "/1.0/images/aliases";
    public static final String URL_GET_CERTIFICATE = "/1.0/certificates";
    public static final String URL_GET_NETWORK = "/1.0/networks";
    public static final String URL_GET_OPERATION = "/1.0/operations";
    public static final String URL_GET_PROFILE = "/1.0/profiles";
    public static final String URL_GET_STATE = "/1.0/containers/${ID}/state";
    public static final String URL_GET_LOGS = "/1.0/containers/${ID}/logs";
    public static final String URL_GET_SNAPSHOTS = "/1.0/containers/${ID}/snapshots";
    public static final String URL_GET_FILE = "/1.0/containers/${ID}/files?path=${PATH}";
    public static final String URL_PUT_CONTAINER_STATE = "/1.0/containers/${ID}/state -X PUT -d '{\"action\": \"${ACTION}\", ${TIMEOUT} \"force\": ${FORCE}, \"stateful\": ${STATEFUL} }'";
    public static final String URL_POST_CONTAINER_CREATE_REMOTE = "/1.0/containers -X POST -d '{\"name\": \"${ID}\", ${EPHEMERAL} ${ARCHITECTURE} ${CONFIG} ${PROFILES} \"source\": {\"type\": \"image\", \"protocol\": \"${PROTOCOL}\", \"server\": \"${SERVERURL}\", \"alias\": \"${ALIAS}\"}}'";
    public static final String URL_POST_CONTAINER_CREATE_LOCAL = "/1.0/containers -X POST -d '{\"name\": \"${ID}\", ${EPHEMERAL} ${ARCHITECTURE} ${CONFIG} ${PROFILES} \"source\": {\"type\": \"image\", \"fingerprint\": \"${ALIAS}\"}}'";
    public static final String URL_POST_CONTAINER_COPY = "/1.0/containers -X POST -d '{\"name\": \"${ID}\", ${EPHEMERAL} ${ARCHITECTURE} ${CONFIG} ${PROFILES} \"source\": {\"type\": \"copy\", \"container_only\": \"${CONTAINERONLY}\", \"source\": \"${CONTAINER}\"}}'";
    public static final String URL_POST_CONTAINER_DELETE = "/1.0/containers/${ID} -X DELETE";
    public static final String URL_POST_CONTAINER_RENAME = "/1.0/containers/${ID} -X POST -d '{ \"name\": \"${NEWNAME}\" }'";
    public static final String URL_POST_CONTAINER_FILES = "/1.0/containers/${ID}/files?path=${PATH} -X POST";
    public static final String URL_POST_CONTAINER_EXEC = "/1.0/containers/${ID}/exec -X POST -d '{ \"command\": [\"${CMD}\"], \"environment\": {${ENV}}, \"wait-for-websocket\": ${WAIT}, \"interactive\": false }'";
    public static final String URL_POST_SNAPSHOT_CREATE = "/1.0/containers/${ID}/snapshots -X POST -d '{\"name\": \"${SNAPNAME}\"}'";
    public static final String URL_POST_SNAPSHOT_DELETE = "/1.0/containers/${ID}/snapshots/${SNAPNAME} -X DELETE";
    public static final String URL_POST_SNAPSHOT_RENAME = "/1.0/containers/${ID}/snapshots/${SNAPNAME} -X POST -d '{ \"name\": \"${NEWNAME}\" }'";
    public static final String URL_POST_IMAGE_DELETE = "/1.0/images/${ID} -X DELETE";
    public static final String URL_POST_IMAGEALIAS_CREATE = "/1.0/images/aliases -X POST -d '{ \"description\": \"${DESCRIPTION}\", \"target\": \"${FINGERPRINT}\", \"name\": \"${NEWNAME}\" }'";
    public static final String URL_POST_IMAGEALIAS_DELETE = "/1.0/images/aliases/${ID} -X DELETE";
    public static final String URL_POST_IMAGEALIAS_RENAME = "/1.0/images/aliases/${ID} -X POST -d '{ \"name\": \"${NEWNAME}\", \"description\": \"${DESCRIPTION}\" }'";
    public static final String URL_POST_PROFILE_DELETE = "/1.0/profiles/${ID} -X DELETE";
    public static final String URL_POST_NETWORK_DELETE = "/1.0/networks/${ID} -X DELETE";

    public void setLinuxCliService(ILinuxCliService var1);

    public <T> T executeCurlGetCmd(LxdServerCredential var1, LxdCall var2, String var3) throws IOException, InterruptedException;

    public <T> T executeCurlGetCmd(LxdServerCredential var1, LxdCall var2, String var3, String var4, String ... var5) throws IOException, InterruptedException;

    public <T> Map<String, T> executeCurlGetListCmd(LxdServerCredential var1, LxdCall var2) throws IOException, InterruptedException;

    public <T> Map<String, T> executeCurlGetListCmd(LxdServerCredential var1, LxdCall var2, String var3) throws IOException, InterruptedException;

    public void executeCurlPostOrPutCmd(LxdServerCredential var1, LxdCall var2, String var3, String ... var4) throws IOException, InterruptedException;

    public void executeCurlPostOrPutCmdForExec(LxdServerCredential var1, LxdCall var2, String var3, String[] var4, String var5, Boolean var6) throws IOException, InterruptedException;

    public void executeCurlPostOrPutCmdForSnapshot(LxdServerCredential var1, LxdCall var2, String var3, String var4, String ... var5) throws IOException, InterruptedException;

    public void executeCurlPostCmdToCreateNewContainerFromImage(LxdServerCredential var1, LxdCall var2, RemoteServer var3, String var4, String var5) throws IOException, InterruptedException;

    public void executeCurlPostCmdToCreateNewContainerFromImage(LxdServerCredential var1, LxdCall var2, RemoteServer var3, String var4, String var5, ImageConfig var6) throws IOException, InterruptedException;

    public void executeCurlPostCmdToCopyContainer(LxdServerCredential var1, String var2, String var3, Boolean var4) throws IOException, InterruptedException;

    public String getParameterisedUrl(String var1, String var2);

    public String getBaseUrl(LxdServerCredential var1);
}

