/*
 * Decompiled with CFR 0.152.
 */
package au.com.jcloud.lxd.service.impl;

import au.com.jcloud.lxd.bean.ImageConfig;
import au.com.jcloud.lxd.bean.LxdServerCredential;
import au.com.jcloud.lxd.enums.LxdCall;
import au.com.jcloud.lxd.enums.RemoteServer;
import au.com.jcloud.lxd.model.StatusCode;
import au.com.jcloud.lxd.model.response.AbstractResponse;
import au.com.jcloud.lxd.model.response.ListOperationResponse;
import au.com.jcloud.lxd.model.response.ListResponse;
import au.com.jcloud.lxd.service.ILinuxCliService;
import au.com.jcloud.lxd.service.ILxdApiService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@Named
public class LxdApiServiceImpl
implements ILxdApiService {
    public static final Logger LOG = Logger.getLogger(LxdApiServiceImpl.class);
    private ILinuxCliService linuxCliService;

    @Override
    public <T> T executeCurlGetCmd(LxdServerCredential credential, LxdCall lxdCall, String id) throws IOException, InterruptedException {
        return this.executeCurlGetCmd(credential, lxdCall, id, null, new String[0]);
    }

    @Override
    public <T> T executeCurlGetCmd(LxdServerCredential credential, LxdCall lxdCall, String id, String containerName, String ... additionalParams) throws IOException, InterruptedException {
        String url = this.getBaseUrl(credential) + lxdCall.getCommand();
        if (containerName != null) {
            url = this.getParameterisedUrl(url, containerName);
        }
        if (lxdCall.equals((Object)LxdCall.GET_FILE) && additionalParams.length > 0) {
            url = url.replace("${PATH}", additionalParams[0]);
            return (T)this.linuxCliService.executeLinuxCmd(url);
        }
        if (lxdCall.equals((Object)LxdCall.GET_STATE)) {
            url = this.getParameterisedUrl(url, id);
        } else if (StringUtils.isNotBlank((CharSequence)id)) {
            url = url + "/" + id;
        }
        LOG.debug((Object)("url=" + url));
        AbstractResponse response = this.linuxCliService.executeLinuxCmdWithResultJsonObject(url, lxdCall.getClassType());
        if (response != null) {
            LOG.debug((Object)("statusCode=" + response.getStatusCode()));
            if (StatusCode.SUCCESS.equals((Object)StatusCode.parse(response.getStatusCode()))) {
                return (T)response.getMetadata();
            }
        }
        return null;
    }

    @Override
    public <T> Map<String, T> executeCurlGetListCmd(LxdServerCredential credential, LxdCall lxdCall) throws IOException, InterruptedException {
        return this.executeCurlGetListCmd(credential, lxdCall, null);
    }

    @Override
    public <T> Map<String, T> executeCurlGetListCmd(LxdServerCredential credential, LxdCall lxdCall, String containerName) throws IOException, InterruptedException {
        Class responseClassType = ListResponse.class;
        if (lxdCall.equals((Object)LxdCall.GET_OPERATION)) {
            responseClassType = ListOperationResponse.class;
        }
        String url = this.getBaseUrl(credential) + lxdCall.getCommand();
        url = this.getParameterisedUrl(url, containerName);
        LOG.debug((Object)("url=" + url));
        AbstractResponse response = this.linuxCliService.executeLinuxCmdWithResultJsonObject(url, responseClassType);
        HashMap<String, T> results = new HashMap<String, T>();
        if (response != null) {
            LOG.debug((Object)("statusCode=" + response.getStatusCode()));
            if (StatusCode.SUCCESS.equals((Object)StatusCode.parse(response.getStatusCode()))) {
                List stringNames = new ArrayList();
                if (lxdCall.equals((Object)LxdCall.GET_OPERATION)) {
                    Map responses = (Map)response.getMetadata();
                    for (List values : responses.values()) {
                        stringNames.addAll(values);
                    }
                } else {
                    stringNames = (List)response.getMetadata();
                    if (stringNames == null) {
                        stringNames = new ArrayList();
                    }
                }
                for (String stringName : stringNames) {
                    int index;
                    String id = stringName.substring((index = stringName.lastIndexOf("/")) + 1);
                    T instance = this.executeCurlGetCmd(credential, lxdCall, id, containerName, new String[0]);
                    if (instance == null) continue;
                    results.put(id, instance);
                }
            } else {
                LOG.warn((Object)("Invalid Response! response=" + response + " url=" + url));
            }
        }
        return results;
    }

    @Override
    public void executeCurlPostOrPutCmd(LxdServerCredential credential, LxdCall lxdCall, String containerName, String ... additionalParams) throws IOException, InterruptedException {
        if (!(lxdCall != null && (lxdCall.equals((Object)LxdCall.PUT_CONTAINER_STATE) || lxdCall.equals((Object)LxdCall.POST_CONTAINER_CREATE_LOCAL) || lxdCall.equals((Object)LxdCall.POST_CONTAINER_CREATE_REMOTE) || lxdCall.equals((Object)LxdCall.POST_CONTAINER_DELETE) || lxdCall.equals((Object)LxdCall.POST_IMAGEALIAS_CREATE) || lxdCall.equals((Object)LxdCall.POST_IMAGEALIAS_DELETE) || lxdCall.equals((Object)LxdCall.POST_IMAGE_DELETE) || lxdCall.equals((Object)LxdCall.POST_CONTAINER_RENAME)))) {
            throw new IOException("This call is not implemented! " + (Object)((Object)lxdCall));
        }
        String url = this.getBaseUrl(credential) + lxdCall.getCommand();
        url = this.getParameterisedUrl(url, containerName);
        if (lxdCall.equals((Object)LxdCall.POST_CONTAINER_RENAME) && additionalParams.length > 0) {
            url = url.replace("${NEWNAME}", additionalParams[0]);
        } else if (lxdCall.equals((Object)LxdCall.POST_IMAGEALIAS_CREATE) && additionalParams.length > 0) {
            url = url.replace("${NEWNAME}", containerName);
            url = url.replace("${FINGERPRINT}", additionalParams[0]);
            if (additionalParams.length > 1) {
                url = url.replace("${DESCRIPTION}", additionalParams[1]);
            }
            url = url.replace("${DESCRIPTION}", "");
        } else if (lxdCall.equals((Object)LxdCall.PUT_CONTAINER_STATE) && additionalParams.length > 0) {
            url = url.replace("${ACTION}", additionalParams[0]);
            boolean force = false;
            boolean stateful = false;
            String timeout = "";
            if (additionalParams.length > 1) {
                force = Boolean.parseBoolean(additionalParams[1]);
            }
            url = url.replace("${FORCE}", String.valueOf(force));
            if (additionalParams.length > 2) {
                stateful = Boolean.parseBoolean(additionalParams[2]);
            }
            url = url.replace("${STATEFUL}", String.valueOf(stateful));
            if (StringUtils.isNotBlank((CharSequence)timeout)) {
                url = url.replace("${TIMEOUT}", "\"timeout\": " + timeout + ", ");
            }
            url = url.replace("${TIMEOUT}", "");
        }
        LOG.debug((Object)("url=" + url));
        AbstractResponse response = this.linuxCliService.executeLinuxCmdWithResultJsonObject(url, lxdCall.getClassType());
        LOG.info((Object)("repsonse=" + response));
        if (response != null) {
            LOG.debug((Object)("statusCode=" + response.getStatusCode()));
            if (StatusCode.OPERATION_CREATED.equals((Object)StatusCode.parse(response.getStatusCode()))) {
                return;
            }
        }
    }

    @Override
    public void executeCurlPostOrPutCmdForExec(LxdServerCredential credential, LxdCall lxdCall, String containerName, String[] commandAndArgs, String env, Boolean waitForSocket) throws IOException, InterruptedException {
        if (lxdCall == null || !lxdCall.equals((Object)LxdCall.POST_CONTAINER_EXEC)) {
            throw new IOException("This call is not implemented! " + (Object)((Object)lxdCall));
        }
        String url = this.getBaseUrl(credential) + lxdCall.getCommand();
        url = this.getParameterisedUrl(url, containerName);
        url = url.replace("${CMD}", StringUtils.join((Object[])commandAndArgs, (String)","));
        url = url.replace("${ENV}", env != null ? env : "");
        url = url.replace("${WAIT}", waitForSocket != null ? waitForSocket.toString() : Boolean.FALSE.toString());
        LOG.debug((Object)("url=" + url));
        AbstractResponse response = this.linuxCliService.executeLinuxCmdWithResultJsonObject(url, lxdCall.getClassType());
        LOG.info((Object)("repsonse=" + response));
        if (response != null) {
            LOG.debug((Object)("statusCode=" + response.getStatusCode()));
            if (StatusCode.OPERATION_CREATED.equals((Object)StatusCode.parse(response.getStatusCode()))) {
                return;
            }
        }
    }

    @Override
    public void executeCurlPostOrPutCmdForSnapshot(LxdServerCredential credential, LxdCall lxdCall, String containerName, String snapshotName, String ... additionalParams) throws IOException, InterruptedException {
        if (lxdCall == null || !lxdCall.equals((Object)LxdCall.POST_SNAPSHOT_CREATE) && !lxdCall.equals((Object)LxdCall.POST_SNAPSHOT_DELETE) && !lxdCall.equals((Object)LxdCall.POST_SNAPSHOT_RENAME)) {
            throw new IOException("This call is not implemented! " + (Object)((Object)lxdCall));
        }
        String url = this.getBaseUrl(credential) + lxdCall.getCommand();
        url = this.getParameterisedUrl(url, containerName);
        url = url.replace("${SNAPNAME}", snapshotName);
        if (lxdCall.equals((Object)LxdCall.POST_SNAPSHOT_RENAME) && additionalParams.length > 0) {
            url = url.replace("${NEWNAME}", additionalParams[0]);
        }
        LOG.debug((Object)("url=" + url));
        AbstractResponse response = this.linuxCliService.executeLinuxCmdWithResultJsonObject(url, lxdCall.getClassType());
        LOG.info((Object)("repsonse=" + response));
        if (response != null) {
            LOG.debug((Object)("statusCode=" + response.getStatusCode()));
            if (StatusCode.OPERATION_CREATED.equals((Object)StatusCode.parse(response.getStatusCode()))) {
                return;
            }
        }
    }

    @Override
    public void executeCurlPostCmdToCreateNewContainerFromImage(LxdServerCredential credential, LxdCall lxdCall, RemoteServer remoteServer, String containerName, String imageAlias) throws IOException, InterruptedException {
        this.executeCurlPostCmdToCreateNewContainerFromImage(credential, lxdCall, remoteServer, containerName, imageAlias, null);
    }

    @Override
    public void executeCurlPostCmdToCreateNewContainerFromImage(LxdServerCredential credential, LxdCall lxdCall, RemoteServer remoteServer, String containerName, String imageAlias, ImageConfig imageConfig) throws IOException, InterruptedException {
        if (remoteServer == null) {
            throw new IOException("Cannot create a container without a remoteServer.");
        }
        String url = this.getBaseUrl(credential) + lxdCall.getCommand();
        url = this.getParameterisedUrl(url, containerName);
        url = url.replace("${ALIAS}", imageAlias);
        url = url.replace("${PROTOCOL}", remoteServer.getProtocol());
        url = url.replace("${SERVERURL}", remoteServer.getUrl());
        if (imageConfig != null) {
            String config;
            Collection<String> profiles;
            String architecture;
            Boolean ephemeral = imageConfig.getEphemeral();
            if (ephemeral != null) {
                url = url.replace("${EPHEMERAL}", "\"ephemeral\": " + String.valueOf(ephemeral) + ", ");
            }
            if (StringUtils.isNotBlank((CharSequence)(architecture = imageConfig.getArchitecture()))) {
                url = url.replace("${ARCHITECTURE}", "\"architecture\": \"" + architecture + "\", ");
            }
            if ((profiles = imageConfig.getProfiles()) != null && !profiles.isEmpty()) {
                StringBuilder profileValue = new StringBuilder();
                for (String profile : profiles) {
                    if (profileValue.length() > 0) {
                        profileValue.append(",");
                    }
                    profileValue.append("\"").append(profile).append("\"");
                }
                url = url.replace("${PROFILES}", "\"profile\": [" + profileValue.toString() + "], ");
            }
            if (StringUtils.isNotBlank((CharSequence)(config = imageConfig.getConfig()))) {
                url = url.replace("${CONFIG}", "\"config\": \"" + config + "\", ");
            }
        }
        url = url.replace("${CONFIG}", "");
        url = url.replace("${PROFILES}", "");
        url = url.replace("${EPHEMERAL}", "");
        url = url.replace("${ARCHITECTURE}", "");
        LOG.debug((Object)("url=" + url));
        AbstractResponse response = this.linuxCliService.executeLinuxCmdWithResultJsonObject(url, lxdCall.getClassType());
        LOG.info((Object)("repsonse=" + response));
        if (response != null) {
            LOG.debug((Object)("statusCode=" + response.getStatusCode()));
            if (StatusCode.OPERATION_CREATED.equals((Object)StatusCode.parse(response.getStatusCode()))) {
                return;
            }
        }
    }

    @Override
    public void executeCurlPostCmdToCopyContainer(LxdServerCredential credential, String existingContainerName, String newContainerName, Boolean containerOnly) throws IOException, InterruptedException {
        LxdCall lxdCall = LxdCall.POST_CONTAINER_COPY;
        String url = this.getBaseUrl(credential) + lxdCall.getCommand();
        url = this.getParameterisedUrl(url, newContainerName);
        url = url.replace("${CONTAINERONLY}", containerOnly == null ? Boolean.TRUE.toString() : containerOnly.toString().toLowerCase());
        url = url.replace("${CONTAINER}", existingContainerName);
        LOG.debug((Object)("url=" + url));
        AbstractResponse response = this.linuxCliService.executeLinuxCmdWithResultJsonObject(url, lxdCall.getClassType());
        LOG.info((Object)("repsonse=" + response));
        if (response != null) {
            LOG.debug((Object)("statusCode=" + response.getStatusCode()));
            if (StatusCode.OPERATION_CREATED.equals((Object)StatusCode.parse(response.getStatusCode()))) {
                return;
            }
        }
    }

    @Override
    public String getParameterisedUrl(String url, String id) {
        url = url.replace("${ID}", id != null ? id : "");
        return url;
    }

    @Override
    public String getBaseUrl(LxdServerCredential credential) {
        String url = "curl -s --unix-socket /var/snap/lxd/common/lxd/unix.socket a";
        if (credential != null && StringUtils.isNotBlank((CharSequence)credential.getRemoteHostAndPort())) {
            String remoteHostAndPort = credential.getRemoteHostAndPort();
            if (!remoteHostAndPort.contains(":")) {
                remoteHostAndPort = remoteHostAndPort + ":8443";
            }
            url = "curl -s -k ${KEYPATHCERT} ${KEYPATHKEY} https://${HOSTANDPORT}".replace("${HOSTANDPORT}", remoteHostAndPort);
            url = StringUtils.isNotBlank((CharSequence)credential.getRemoteCert()) ? url.replace("${KEYPATHCERT}", "--cert " + credential.getRemoteCert()) : url.replace("${KEYPATHCERT}", "");
            url = StringUtils.isNotBlank((CharSequence)credential.getRemoteKey()) ? url.replace("${KEYPATHKEY}", "--key " + credential.getRemoteKey()) : url.replace("${KEYPATHKEY}", "");
        }
        return url;
    }

    @Override
    @Inject
    public void setLinuxCliService(ILinuxCliService linuxCliService) {
        this.linuxCliService = linuxCliService;
    }
}

