/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.python.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeElement;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeBlock;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeDecorator;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeDocComment;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeImportScope;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeParamSpec;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeRaise;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeTypeSpec;

public class PythonCodeFunction
extends PythonCodeBlock {
    private String name;
    private PythonCodeTypeSpec retType;
    private PythonCodeDocComment comment;
    private List<PythonCodeDecorator> decorators = new ArrayList<PythonCodeDecorator>();
    private List<PythonCodeParamSpec> params = new ArrayList<PythonCodeParamSpec>();

    public PythonCodeFunction(IPythonCodeElement parent, String name) {
        super(parent);
        this.name = name;
        this.comment = new PythonCodeDocComment(this);
    }

    public PythonCodeFunction(IPythonCodeElement parent, String name, String comment) {
        super(parent);
        this.name = name;
        this.comment = new PythonCodeDocComment(comment, this);
    }

    public PythonCodeFunction addParameter(String name) {
        this.params.add(new PythonCodeParamSpec(this, name));
        return this;
    }

    public PythonCodeFunction addParameter(String name, String type) {
        this.params.add(new PythonCodeParamSpec(this, name, type));
        return this;
    }

    public PythonCodeFunction addParameter(String name, PythonCodeTypeSpec type) {
        this.params.add(new PythonCodeParamSpec(this, name, type));
        return this;
    }

    public PythonCodeFunction addParameter(String name, String type, String comment) {
        this.comment.addParameterComment(name, type, comment);
        this.params.add(new PythonCodeParamSpec(this, name, type));
        return this;
    }

    public PythonCodeFunction addParameter(String name, PythonCodeTypeSpec type, String comment) {
        this.comment.addParameterComment(name, type.getOutputType(), comment);
        this.params.add(new PythonCodeParamSpec(this, name, type));
        return this;
    }

    public PythonCodeFunction addReturn(String expr, String comment) {
        this.comment.addReturnComment(comment);
        super.addReturn(expr);
        return this;
    }

    public PythonCodeFunction addRetType(String type) {
        return this.addRetType(type, null);
    }

    @OperationMeta(name={"addRetType", "addReturnType"})
    public PythonCodeFunction addRetType(String type, String comment) {
        this.retType = new PythonCodeTypeSpec(type, this);
        if (comment != null && comment.length() > 0) {
            this.comment.addReturnComment(comment);
        }
        this.comment.addReturnType(type);
        return this;
    }

    public PythonCodeDecorator addDecorator(String name) {
        return this.addDecorator(name, PythonCodeImportScope.NONE);
    }

    public PythonCodeDecorator addDecorator(String name, PythonCodeImportScope scope) {
        PythonCodeDecorator dec = new PythonCodeDecorator(name, this, scope);
        this.decorators.add(dec);
        return dec;
    }

    public PythonCodeRaise addRaiseNotImplementedError() {
        return this.addElt(new PythonCodeRaise(this, "NotImplementedError"));
    }

    public PythonCodeFunction setClass() {
        this.addDecorator("classmethod");
        if (!this.params.isEmpty() && "self".equals(this.params.get(0).getName())) {
            this.params.get(0).setName("cls");
        }
        return this;
    }

    public PythonCodeFunction setStatic() {
        if (!this.params.isEmpty() && "self".equals(this.params.get(0).getName())) {
            this.params.remove(0);
        }
        return this;
    }

    public PythonCodeDocComment getComment() {
        return this.comment;
    }

    @Override
    @Invisible
    public void store(CodeWriter out) {
        for (PythonCodeDecorator d : this.decorators) {
            d.store(out);
        }
        out.printwi("def " + this.name + "(");
        IPythonCodeElement.storeList(this.params, ", ", out);
        out.print(")");
        if (this.retType != null) {
            out.print(" -> " + this.retType.getOutputType());
        }
        out.println(":");
        out.increaseIndent();
        if (this.comment != null) {
            this.comment.store(out);
        }
        super.store(out);
        out.decreaseIndent();
        out.println();
    }
}

