/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.python.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeElement;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeExpr;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeFnCall;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeImportScope;

public class PythonCodeLambdaExpr
extends PythonCodeExpr {
    private List<String> variables = new ArrayList<String>();
    private String expr;
    private PythonCodeFnCall callExpr;

    protected PythonCodeLambdaExpr(IPythonCodeElement parent) {
        super(parent);
    }

    public PythonCodeLambdaExpr addVariable(String variable) {
        if (!this.variables.contains(variable)) {
            this.variables.add(variable);
        }
        return this;
    }

    public PythonCodeLambdaExpr addExpr(String expr) {
        this.expr = expr;
        return this;
    }

    public PythonCodeFnCall addCall(String methodName) {
        return this.addCall(methodName, PythonCodeImportScope.NONE);
    }

    public PythonCodeFnCall addCall(String methodName, PythonCodeImportScope scope) {
        this.callExpr = new PythonCodeFnCall(this, methodName, scope);
        return this.callExpr;
    }

    @Override
    public void store(CodeWriter out) {
        out.print("lambda ");
        out.print(IPythonCodeElement.toList(this.variables, ","));
        out.print(" : ");
        if (this.callExpr != null) {
            this.callExpr.store(out);
        } else {
            out.print(this.expr);
        }
    }
}

