/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.python.codeArtifacts;

import net.ssehub.easy.instantiation.core.model.templateModel.CodeToStringWriter;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeArtifact;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeElement;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeTypeSpec;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeClass;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeImportScope;

public class PythonCodeTypeSpec
implements IPythonCodeElement,
IPythonCodeTypeSpec {
    private String type;
    private IPythonCodeElement enclosing;

    protected PythonCodeTypeSpec(String type, IPythonCodeElement enclosing) {
        this(type, enclosing, PythonCodeImportScope.MODULE);
    }

    protected PythonCodeTypeSpec(String type, IPythonCodeElement enclosing, PythonCodeImportScope scope) {
        this.enclosing = enclosing;
        this.type = type;
        if (scope != PythonCodeImportScope.NONE) {
            this.getArtifact().validateType(this);
        }
    }

    protected PythonCodeTypeSpec(PythonCodeTypeSpec type, IPythonCodeElement enclosing, PythonCodeImportScope scope) {
        this.enclosing = enclosing;
        this.type = type.type;
        if (scope != PythonCodeImportScope.NONE) {
            this.getArtifact().validateType(this);
        }
    }

    public static PythonCodeTypeSpec create(String type, IPythonCodeElement enclosing) {
        return PythonCodeTypeSpec.create(type, enclosing, PythonCodeImportScope.MODULE);
    }

    public static PythonCodeTypeSpec create(String type, IPythonCodeElement enclosing, PythonCodeImportScope scope) {
        return new PythonCodeTypeSpec(type, enclosing, scope);
    }

    public String getType() {
        return this.type;
    }

    @Override
    @Invisible
    public IPythonCodeArtifact getArtifact() {
        return this.enclosing.getArtifact();
    }

    @Override
    @Invisible(inherit=true)
    public String getTracerStringValue(IStringValueProvider.StringComparator comparator) {
        return this.getClass().getSimpleName() + " " + this.type;
    }

    @Override
    public String getOutputTypeName() {
        return this.type;
    }

    public String getOutputType() {
        CodeToStringWriter out = new CodeToStringWriter();
        this.store((CodeWriter)out);
        return out.getString();
    }

    @Override
    public void setOutputTypeName(String typeName) {
        this.type = typeName;
    }

    @Override
    public IPythonCodeElement getParent() {
        return this.enclosing;
    }

    @Override
    @Invisible
    public void setParent(IPythonCodeElement parent) {
        PythonCodeClass.setParent(parent, p -> {
            this.enclosing = p;
            IPythonCodeElement iPythonCodeElement = this.enclosing;
        });
    }

    @Override
    public void store(CodeWriter out) {
        out.print(this.type);
    }
}

