/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.python.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeElement;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeBlock;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeElement;

public class PythonCodeWith
extends PythonCodeBlock {
    private List<PythonCodeWithItem> withItems = new ArrayList<PythonCodeWithItem>();

    public PythonCodeWith(IPythonCodeElement parent, String expr) {
        super(parent);
        this.withItems.add(new PythonCodeWithItem(this, expr));
    }

    public PythonCodeWith(IPythonCodeElement parent, String expr, String varName) {
        super(parent);
        this.withItems.add(new PythonCodeWithItem(this, expr, varName));
    }

    public PythonCodeWith addWithItem(String expr) {
        this.withItems.add(new PythonCodeWithItem(this, expr));
        return this;
    }

    public PythonCodeWith addWithItem(String expr, String varName) {
        this.withItems.add(new PythonCodeWithItem(this, expr, varName));
        return this;
    }

    @Override
    public void store(CodeWriter out) {
        out.printwi("with ");
        IPythonCodeElement.storeList(this.withItems, ",", out);
        out.println(":");
        out.increaseIndent();
        super.store(out);
        out.decreaseIndent();
    }

    private class PythonCodeWithItem
    extends PythonCodeElement {
        private String expr;
        private String varName;

        protected PythonCodeWithItem(IPythonCodeElement parent, String expr) {
            super(parent);
            this.expr = expr;
        }

        protected PythonCodeWithItem(IPythonCodeElement parent, String expr, String varName) {
            super(parent);
            this.expr = expr;
            this.varName = varName;
        }

        @Override
        public void store(CodeWriter out) {
            out.print(this.expr);
            if (this.varName != null) {
                out.print(" as " + this.varName);
            }
        }
    }
}

