/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.mgmt;

import java.io.File;
import java.util.Observer;
import java.util.UUID;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionFormatException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.producer.core.mgmt.MemberIterator;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.mgmt.SPLsManager;
import net.ssehub.easy.producer.core.persistence.EASyPersistencer;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.core.persistence.PersistenceUtils;
import net.ssehub.easy.producer.core.persistence.standard.EASyConfigFileImporter;
import net.ssehub.easy.producer.core.varMod.container.ProjectContainer;
import net.ssehub.easy.producer.core.varMod.container.ScriptContainer;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Project;

public class GenericProductLineProject
extends PLPInfo {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(GenericProductLineProject.class, "net.ssehub.easy.producer.core");

    public GenericProductLineProject(String projectname, File projectLocation) {
        super(UUID.randomUUID().toString(), projectname, "0", projectLocation);
        Project project = new Project(projectname);
        Version version = null;
        try {
            version = new Version("0");
        }
        catch (VersionFormatException e1) {
            LOGGER.exception((Exception)((Object)e1));
        }
        project.setVersion(version);
        ProjectContainer varModel = new ProjectContainer(project, PersistenceUtils.getConfiguration(projectLocation));
        this.setProject(varModel);
        this.createMainRule();
        SPLsManager.INSTANCE.addPLP(this);
    }

    public GenericProductLineProject(String projectID, String projectName, ProjectContainer project, File projectLocation, ScriptContainer mainBuildScript) {
        super(projectID, projectName, Version.toString((Version)project.getVersion()), projectLocation);
        this.setProject(project);
        this.setBuildScript(mainBuildScript);
        SPLsManager.INSTANCE.addPLP(this);
    }

    protected GenericProductLineProject(String uuid, String name, String version, File location) {
        super(uuid, name, version, location);
    }

    protected GenericProductLineProject(String uuid, String name, String version, File configLocation, File projectLocation) {
        super(uuid, name, version, configLocation);
    }

    @Override
    public void pullConfigFromPredecessors() {
        EASyConfigFileImporter importer = new EASyConfigFileImporter(this);
        MemberIterator predecessors = this.getMemberController().predecessors();
        while (predecessors.hasNext()) {
            PLPInfo predecessorPLP = predecessors.next();
            importer.copyConfigFiles(predecessorPLP, "." + predecessorPLP.getProjectName());
        }
        this.refresh();
        this.getConfiguration().refresh();
        this.configurationPulled();
    }

    @Override
    public void save() {
        EASyPersistencer persistencer = new EASyPersistencer(this.getProjectLocation());
        try {
            persistencer.save(this);
        }
        catch (PersistenceException e) {
            e.printStackTrace();
        }
    }

    public void registerObserver(Observer observer) {
        this.getMemberController().addObserver(observer);
    }

    public void unRegisterObserver(Observer observer) {
        this.getMemberController().deleteObserver(observer);
    }

    public boolean isTransformable() {
        return this.isTransformableVIL();
    }

    public void createNewModel(Version version) throws PersistenceException {
        PersistenceUtils.createIVMLProject(this.getProjectName(), version, this.getConfigLocation().getAbsolutePath());
        try {
            VarModel.INSTANCE.updateModelInformation(this.getConfigLocation(), ProgressObserver.NO_OBSERVER);
        }
        catch (ModelManagementException exc) {
            LOGGER.exception((Exception)((Object)exc));
        }
    }
}

