/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.producer.core.persistence.ConfigurationContentHandler;
import net.ssehub.easy.producer.core.persistence.internal.IndentationPrintWriter;
import net.ssehub.easy.producer.core.persistence.internal.util.FileUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Configuration {
    public static final Configuration DEFAULT = new Configuration();
    public static final String TOP_LEVEL_CONFIG_NAME = ".EASyProducer";
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(Configuration.class, "net.ssehub.easy.producer.core");
    private Map<PathKind, List<String>> paths;
    private File projectFolder;
    private File file;
    private long timestamp;
    private boolean fromFile;

    private Configuration() {
        this.createStructures();
        this.setToEASyDefaults();
    }

    Configuration(Configuration src) {
        if (src == null) {
            src = DEFAULT;
        }
        this.projectFolder = src.projectFolder;
        this.file = src.file;
        this.timestamp = src.timestamp;
        this.createStructures();
        PathKind[] pathKindArray = PathKind.values();
        int n = pathKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            PathKind kind = pathKindArray[n2];
            this.paths.put(kind, new ArrayList(src.paths.get((Object)kind)));
            ++n2;
        }
    }

    Configuration(File projectFolder) {
        this.createStructures();
        this.projectFolder = projectFolder;
        this.file = new File(this.projectFolder, TOP_LEVEL_CONFIG_NAME);
        if (this.file.exists()) {
            this.load();
        } else {
            this.initDefaults();
        }
    }

    void checkForModification() {
        if (!this.isRecent()) {
            this.load();
        }
    }

    public boolean isFromFile() {
        return this.fromFile;
    }

    public void setToEASyDefaults() {
        this.setPathDirect(PathKind.IVML, "EASy");
        this.setPathDirect(PathKind.VIL, "EASy");
        this.setPathDirect(PathKind.VTL, "EASy");
        this.fromFile = false;
    }

    public boolean isRecent() {
        boolean recent = this.file.exists() && this.timestamp > 0L ? this.file.lastModified() > this.timestamp : true;
        return recent;
    }

    public boolean isMaterialized() {
        return this.file != null && this.file.exists();
    }

    private void readOldFormat(String firstLine, LineNumberReader lnr) throws IOException {
        if (firstLine != null) {
            this.setPathDirect(PathKind.IVML, firstLine);
            String line = lnr.readLine();
            if (line != null) {
                this.setPathDirect(PathKind.VIL, line);
                this.setPathDirect(PathKind.VTL, line);
            } else {
                this.setPathDirect(PathKind.VIL, firstLine);
                this.setPathDirect(PathKind.VTL, firstLine);
            }
        }
    }

    private void readXmlFormat(Reader reader) throws IOException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            XMLReader xmlReader = parser.getXMLReader();
            InputSource inputSource = new InputSource(reader);
            xmlReader.setContentHandler(new ConfigurationContentHandler(this));
            xmlReader.parse(inputSource);
            if (this.getPath(PathKind.VTL, 0) == null) {
                this.setPathDirect(PathKind.VTL, this.combinePath(PathKind.VIL));
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
    }

    private void load() {
        if (this.file != null) {
            block12: {
                this.clear();
                FileReader reader = null;
                try {
                    LineNumberReader lnr;
                    String line;
                    reader = new FileReader(this.file);
                    if (reader.markSupported()) {
                        reader.mark(0);
                    }
                    if ((line = (lnr = new LineNumberReader(reader)).readLine()) != null && line.trim().startsWith("<?xml")) {
                        if (reader.markSupported()) {
                            reader.reset();
                        } else {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            reader = new FileReader(this.file);
                        }
                        this.readXmlFormat(reader);
                    } else {
                        this.readOldFormat(line, lnr);
                    }
                    reader.close();
                    this.timestamp = this.file.lastModified();
                    this.fromFile = true;
                }
                catch (IOException e) {
                    LOGGER.warn("configuration I/O problem: " + e.getMessage());
                    if (reader == null) break block12;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            this.initDefaults();
        }
    }

    private void createStructures() {
        this.paths = new HashMap<PathKind, List<String>>();
        PathKind[] pathKindArray = PathKind.values();
        int n = pathKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            PathKind kind = pathKindArray[n2];
            this.paths.put(kind, new ArrayList());
            ++n2;
        }
    }

    private void initDefaults() {
        PathKind[] pathKindArray = PathKind.values();
        int n = pathKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            PathKind kind = pathKindArray[n2];
            this.setPathDefault(kind);
            ++n2;
        }
    }

    private void clear() {
        PathKind[] pathKindArray = PathKind.values();
        int n = pathKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            PathKind kind = pathKindArray[n2];
            this.paths.get((Object)kind).clear();
            ++n2;
        }
    }

    private void setPathDefault(PathKind kind) {
        if (this.paths.get((Object)kind).isEmpty()) {
            this.paths.get((Object)kind).addAll((Collection<String>)Configuration.DEFAULT.paths.get((Object)kind));
        }
    }

    public static String checkPath(String path) {
        if (!((String)path).endsWith(FileUtils.SEPARATOR_STRING)) {
            path = (String)path + FileUtils.SEPARATOR_STRING;
        }
        return path;
    }

    public void setPathDirect(PathKind kind, String path) {
        if (!((String)path).endsWith(FileUtils.SEPARATOR_STRING)) {
            path = (String)path + FileUtils.SEPARATOR_STRING;
        }
        List<String> pth = this.paths.get((Object)kind);
        pth.clear();
        String[] stringArray = ((String)path).replace(":", ";").split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            pth.add(s);
            ++n2;
        }
    }

    public void setPath(PathKind kind, String path) throws IOException {
        this.setPath(kind, new File(path));
    }

    public void setPath(PathKind kind, File path) throws IOException {
        String sPath = path.getCanonicalPath();
        if (this.projectFolder != null) {
            Object pPath = this.projectFolder.getPath();
            if (!((String)pPath).endsWith(File.separator)) {
                pPath = (String)pPath + File.separator;
            }
            if (sPath.startsWith((String)pPath)) {
                sPath = sPath.substring(((String)pPath).length());
            }
        }
        this.setPathDirect(kind, FileUtils.toIndependent(path.getPath()));
    }

    public int getPathCount(PathKind kind) {
        return this.paths.get((Object)kind).size();
    }

    public String getPath(PathKind kind, int index) {
        return this.paths.get((Object)kind).isEmpty() ? null : this.paths.get((Object)kind).get(index);
    }

    public boolean isPathEasyDefault(PathKind kind) {
        return "EASy".equals(this.getPath(kind, 0));
    }

    public File getPathFile(PathKind kind, int index) {
        return new File(this.projectFolder, this.getPath(kind, index));
    }

    public void store() {
        if (this.file != null) {
            IndentationPrintWriter writer = null;
            try {
                writer = new IndentationPrintWriter(new FileWriter(this.file));
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.println("<configuration>");
                writer.increaseIndentation();
                PathKind[] pathKindArray = PathKind.values();
                int n = pathKindArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PathKind kind = pathKindArray[n2];
                    this.storePath(writer, kind);
                    ++n2;
                }
                writer.decreaseIndentation();
                writer.println("</configuration>");
                writer.close();
            }
            catch (IOException e) {
                LOGGER.warn("configuration I/O problem: " + e.getMessage());
            }
            this.timestamp = this.file.lastModified();
        }
    }

    public String combinePath(PathKind kind) {
        Object result;
        List<String> pth = this.paths.get((Object)kind);
        if (pth.isEmpty()) {
            result = null;
        } else {
            result = "";
            int p = 0;
            while (p < pth.size()) {
                if (p > 0) {
                    result = (String)result + File.pathSeparator;
                }
                result = (String)result + pth.get(p);
                ++p;
            }
        }
        return result;
    }

    private void storePath(IndentationPrintWriter writer, PathKind kind) {
        String path = this.combinePath(kind);
        if (path != null && path.length() > 0) {
            writer.printIndentation();
            writer.print("<path kind=\"");
            writer.print(kind.name());
            writer.print("\" value=\"");
            writer.print(path);
            writer.println("\" />");
        }
    }

    public File getProjectFolder() {
        return this.projectFolder;
    }

    public static enum PathKind {
        IVML,
        VIL,
        VTL;

    }
}

