/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelLocations;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionFormatException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.dslCore.DefaultLib;
import net.ssehub.easy.dslCore.TopLevelModelAccessor;
import net.ssehub.easy.dslCore.validation.ValidationUtils;
import net.ssehub.easy.instantiation.core.DefaultLibUtils;
import net.ssehub.easy.instantiation.core.model.buildlangModel.AbstractRule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildlangWriter;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ExpressionStatement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ForStatement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IRuleElement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.buildlangModel.InstantiateExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Utils;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.VariableExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.persistence.Configuration;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.core.persistence.datatypes.Entity;
import net.ssehub.easy.producer.core.persistence.datatypes.Model;
import net.ssehub.easy.producer.core.persistence.datatypes.ModelType;
import net.ssehub.easy.producer.core.persistence.datatypes.PathEnvironment;
import net.ssehub.easy.producer.core.persistence.internal.DataStorage;
import net.ssehub.easy.producer.core.persistence.internal.StorageType;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.ExpressionVersionRestriction;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.persistency.IVMLWriter;

public class PersistenceUtils {
    public static final String INSTANTIATOR_CONTROLLER_MULTIPLE = "No file will be instantiated by multiple engines";
    private static final String DEBUG_FILES_EXTENSION = "_debug";
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(PersistenceUtils.class, "net.ssehub.easy.producer.core");
    private static final Map<String, Configuration> CONFIGURATIONS = new HashMap<String, Configuration>();
    private static boolean defaultModelsLoaded = false;
    private static boolean enableProjectFolders = true;

    public static final Configuration getConfiguration(File projectFolder) {
        Configuration result;
        if (projectFolder == null) {
            result = new Configuration(Configuration.DEFAULT);
        } else {
            try {
                projectFolder = projectFolder.getCanonicalFile();
            }
            catch (IOException e) {
                LOGGER.info("invalid project path - using default configuration: " + String.valueOf(projectFolder));
            }
            String key = projectFolder.getPath();
            result = CONFIGURATIONS.get(key);
            if (result == null) {
                result = new Configuration(projectFolder);
                CONFIGURATIONS.put(key, result);
            } else {
                result.checkForModification();
            }
        }
        return result;
    }

    public static final void closeProject(File projectFolder) {
        if (projectFolder != null) {
            try {
                Configuration cfg = CONFIGURATIONS.remove(projectFolder.getCanonicalFile().getPath());
                if (cfg != null) {
                    PersistenceUtils.processLocation(cfg, false, false, ProgressObserver.NO_OBSERVER);
                }
            }
            catch (IOException e) {
                LOGGER.info("invalid project path - ignoring close request: " + String.valueOf(projectFolder));
            }
            catch (ModelManagementException e) {
                LOGGER.info("closing " + String.valueOf(projectFolder) + ": " + e.getMessage());
            }
        }
    }

    public static void updateLocations(Configuration config, Configuration.PathKind kind, ModelLocations<?> locations, ProgressObserver observer) throws ModelManagementException {
        int p = 0;
        while (p < config.getPathCount(kind)) {
            locations.updateLocation(config.getPathFile(kind, p), observer);
            ++p;
        }
    }

    public static void processLocations(Configuration config, Configuration.PathKind kind, ModelLocations<?> locations, boolean add, boolean dfltLib, ProgressObserver observer) throws ModelManagementException {
        ModelLocations.Location primary = null;
        int p = 0;
        while (p < config.getPathCount(kind)) {
            File pathFile = config.getPathFile(kind, p);
            if (add) {
                ModelLocations.Location loc = locations.addLocation(pathFile, observer);
                if (primary == null) {
                    primary = loc;
                } else {
                    primary.addDependentLocation(loc);
                }
                if (dfltLib) {
                    loc.toDefaultLibLocation();
                }
            } else {
                locations.removeLocation(pathFile, observer);
            }
            if (!dfltLib) {
                if (add) {
                    ValidationUtils.addPath((File)pathFile);
                } else {
                    ValidationUtils.removePath((File)pathFile);
                }
            }
            ++p;
        }
    }

    public static final void processLocation(Configuration config, boolean add, boolean dfltLib, ProgressObserver observer) throws ModelManagementException {
        if (enableProjectFolders && add && !dfltLib) {
            ModelManagement.addProjectFolder((File)config.getProjectFolder());
        }
        ModelManagementException returnExc = null;
        try {
            PersistenceUtils.processLocations(config, Configuration.PathKind.IVML, VarModel.INSTANCE.locations(), add, dfltLib, observer);
        }
        catch (ModelManagementException exc) {
            returnExc = exc;
        }
        try {
            PersistenceUtils.processLocations(config, Configuration.PathKind.VIL, BuildModel.INSTANCE.locations(), add, dfltLib, observer);
        }
        catch (ModelManagementException exc) {
            returnExc = exc;
        }
        try {
            PersistenceUtils.processLocations(config, Configuration.PathKind.VTL, TemplateModel.INSTANCE.locations(), add, dfltLib, observer);
        }
        catch (ModelManagementException exc) {
            returnExc = exc;
        }
        for (TopLevelModelAccessor.IModelAccessor accessor : TopLevelModelAccessor.registered()) {
            Configuration.PathKind kind = Configuration.PathKind.valueOf(accessor.getPathKindHint());
            if (kind == null) {
                kind = Configuration.PathKind.IVML;
            }
            int p = 0;
            while (p < config.getPathCount(kind)) {
                try {
                    File f = config.getPathFile(kind, p).getAbsoluteFile();
                    if (add) {
                        accessor.addLocation(f, observer);
                    } else {
                        accessor.removeLocation(f, observer);
                    }
                }
                catch (ModelManagementException exc) {
                    returnExc = exc;
                }
                ++p;
            }
        }
        if (enableProjectFolders && !add && !dfltLib) {
            ModelManagement.removeProjectFolder((File)config.getProjectFolder());
        }
        if (returnExc != null) {
            throw returnExc;
        }
    }

    public static boolean setEnableProjectFolders(boolean enable) {
        boolean before = enableProjectFolders;
        enableProjectFolders = enable;
        return before;
    }

    public static void setDependentLocations(File parent, File dependent, Configuration config) {
        PersistenceUtils.processDependent(VarModel.INSTANCE.locations(), parent, dependent, config, Configuration.PathKind.IVML);
        PersistenceUtils.processDependent(BuildModel.INSTANCE.locations(), parent, dependent, config, Configuration.PathKind.VIL);
        PersistenceUtils.processDependent(TemplateModel.INSTANCE.locations(), parent, dependent, config, Configuration.PathKind.VIL);
    }

    private static void processDependent(ModelLocations<?> locations, File parent, File dependent, Configuration config, Configuration.PathKind kind) {
        int p = 0;
        while (p < config.getPathCount(kind)) {
            File par = new File(parent, config.getPath(kind, p));
            File dep = new File(dependent, config.getPath(kind, p));
            ModelLocations.Location parentLoc = locations.getLocationFor(par.toURI());
            ModelLocations.Location dependentLoc = locations.getLocationFor(dep.toURI());
            if (parentLoc != null && dependentLoc != null) {
                parentLoc.addDependentLocation(dependentLoc);
            }
            ++p;
        }
    }

    public static final File getLocationFile(File projectFolder, Configuration.PathKind kind) {
        return PersistenceUtils.getConfiguration(projectFolder).getPathFile(kind, 0);
    }

    public static final String storageFileLocation(String storagePath) {
        return storagePath + System.getProperty("File.Separator") + ".EASyConfig";
    }

    public static final String ivmlFileLocation(Project project, String storagePath) {
        String projectName = project.getQualifiedName();
        String projectVersion = null;
        Version version = project.getVersion();
        if (version != null) {
            projectVersion = version.getVersion();
        }
        return PersistenceUtils.ivmlFileLocation(projectName, projectVersion, storagePath);
    }

    public static final String vilFileLocation(Script buildScript, String storagePath) {
        String projectName = buildScript.getName();
        String projectVersion = null;
        Version version = buildScript.getVersion();
        if (version != null) {
            projectVersion = version.getVersion();
        }
        return PersistenceUtils.vilFileLocation(projectName, projectVersion, storagePath);
    }

    public static final String ivmlFileLocation(String projectName, String projectVersion, String storagePath) {
        return PersistenceUtils.modelFileLocation(projectName, projectVersion, storagePath, ".ivml");
    }

    public static final String vilFileLocation(String projectName, String projectVersion, String storagePath) {
        return PersistenceUtils.modelFileLocation(projectName, projectVersion, storagePath, ".vil");
    }

    public static final String modelFileLocation(String projectName, String projectVersion, String folder, Configuration.PathKind modelType) {
        String result = "";
        switch (modelType) {
            case IVML: {
                result = PersistenceUtils.ivmlFileLocation(projectName, projectVersion, folder);
                break;
            }
            case VIL: {
                result = PersistenceUtils.vilFileLocation(projectName, projectVersion, folder);
                break;
            }
            case VTL: {
                result = new File(folder, projectName + "vtl").getAbsolutePath();
                break;
            }
        }
        return result;
    }

    public static final String modelFileLocation(String projectName, String projectVersion, String storagePath, String extension) {
        File file = new File(storagePath);
        StringBuffer fileName = new StringBuffer(projectName.replaceAll("::", "_"));
        if (projectVersion != null) {
            fileName.append("_");
            fileName.append(projectVersion.replaceAll("\\.", "-"));
        }
        fileName.append(extension);
        file = new File(file, fileName.toString());
        String location = file.getAbsolutePath();
        LOGGER.debug("Model file to load: " + location);
        return location;
    }

    public static final Model loadModel(PathEnvironment pathEnv, String location, ModelType type) throws PersistenceException {
        DataStorage storage = new DataStorage(StorageType.XML, location, pathEnv);
        Model model = new Model(type);
        storage.loadModels(model);
        return model;
    }

    public static final PLPInfo loadRootPLPInfo(PathEnvironment pathEnv, String modelLocation, File projectLocation) {
        PLPInfo result = null;
        try {
            Model model = PersistenceUtils.loadModel(pathEnv, modelLocation, ModelType.ROOT);
            if (model != null && model.getEntityCount() > 0) {
                Entity entity = model.getEntity(0);
                String uuid = entity.getAttributeValue("id");
                String projectName = entity.getAttributeValue("name");
                String version = entity.getAttributeValue("version");
                if (projectLocation == null) {
                    String tmp = entity.getAttributeFileString("location");
                    projectLocation = pathEnv.makeAbsolute(tmp);
                }
                result = projectLocation.isFile() ? new PLPInfo(uuid, projectName, version, new File(modelLocation), projectLocation) : new PLPInfo(uuid, projectName, version, projectLocation);
            }
        }
        catch (PersistenceException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void writeIVMLProject(Project project, String storagePath) throws PersistenceException {
        PersistenceUtils.writeIVMLProject(project, storagePath, false);
    }

    public static void writeIVMLProject(Project project, String storagePath, boolean debug) throws PersistenceException {
        File file = new File(PersistenceUtils.ivmlFileLocation(project, storagePath));
        if (debug) {
            File folder = file.getParentFile();
            Object fileName = file.getName();
            int lastDot = ((String)fileName).lastIndexOf(46);
            String preName = ((String)fileName).substring(0, lastDot);
            String sufName = ((String)fileName).substring(lastDot, ((String)fileName).length());
            fileName = preName + DEBUG_FILES_EXTENSION + sufName;
            file = new File(folder, (String)fileName);
        }
        URI location = file.toURI();
        List oldProjects = VarModel.INSTANCE.availableModels().getVisibleModelInfo(location);
        ArrayList<Project> allProjects = new ArrayList<Project>();
        boolean projectAdded = false;
        if (oldProjects != null && !oldProjects.isEmpty()) {
            int i = 0;
            while (i < oldProjects.size()) {
                ModelInfo info = (ModelInfo)oldProjects.get(i);
                if (info.getName().equals(project.getName()) && Version.equals((Version)info.getVersion(), (Version)project.getVersion())) {
                    allProjects.add(project);
                    projectAdded = true;
                } else if (info.isResolved() && info.getLocation().equals(location) && !info.getName().equals(project.getName())) {
                    allProjects.add((Project)info.getResolved());
                }
                ++i;
            }
        }
        if (!projectAdded) {
            allProjects.add(project);
        }
        if (file.exists()) {
            file.delete();
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            IVMLWriter writer = new IVMLWriter((Writer)fileWriter);
            writer.setFormatInitializer(true);
            ((Project)allProjects.get(0)).accept((IModelVisitor)writer);
            int i = 1;
            while (i < allProjects.size()) {
                fileWriter.append("\r\n");
                ((Project)allProjects.get(i)).accept((IModelVisitor)writer);
                ++i;
            }
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    public static void writeVILScript(Script buildScript, String storagePath) throws PersistenceException {
        File file = new File(PersistenceUtils.vilFileLocation(buildScript, storagePath));
        if (file.exists()) {
            file.delete();
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            BuildlangWriter writer = new BuildlangWriter((Writer)fileWriter);
            buildScript.accept((IVisitor)writer);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        catch (VilException e) {
            throw new PersistenceException(e);
        }
    }

    public static void createIVMLProject(String projectName, Version version, String storagePath) throws PersistenceException {
        Project project = new Project(projectName);
        if (version != null) {
            project.setVersion(version);
        }
        PersistenceUtils.writeIVMLProject(project, storagePath);
    }

    public static final Version defaultVersion() {
        return new Version(new int[]{0});
    }

    public static <M extends IModel> M loadModel(ModelManagement<M> modelManagement, File modelFile) throws ModelManagementException {
        modelManagement.locations().updateLocation(modelFile.getParentFile(), ProgressObserver.NO_OBSERVER);
        modelManagement.updateModelInformation(modelFile, ProgressObserver.NO_OBSERVER);
        ModelInfo info = modelManagement.availableModels().getInfo(modelFile.toURI());
        return (M)modelManagement.load(info);
    }

    public static void refreshModels(PLPInfo plp) {
        try {
            VarModel.INSTANCE.updateModelInformation(plp.getConfigLocation(), ProgressObserver.NO_OBSERVER);
            BuildModel.INSTANCE.updateModelInformation(plp.getScriptLocation(), ProgressObserver.NO_OBSERVER);
            TemplateModel.INSTANCE.updateModelInformation(plp.getTemplateLocation(), ProgressObserver.NO_OBSERVER);
            if (plp.getProject() != null) {
                VarModel.INSTANCE.resolveImports((IModel)plp.getProject(), plp.getConfigLocation().toURI(), null);
            }
            if (plp.getBuildScript() != null) {
                BuildModel.INSTANCE.resolveImports((IModel)plp.getBuildScript(), plp.getScriptLocation().toURI(), null);
            }
        }
        catch (ModelManagementException e) {
            LOGGER.exception((Exception)((Object)e));
        }
        catch (NullPointerException e) {
            LOGGER.exception((Exception)e);
        }
    }

    public static void createInstantiatePredecessorScript(PLPInfo plp, PLPInfo ... parentPLPs) {
        Script mainScript = plp.getBuildScript();
        AbstractRule mainRule = mainScript.getMainRule(true);
        if (parentPLPs != null) {
            int j = 0;
            int n = parentPLPs.length;
            while (j < n) {
                ModelImport scriptImport;
                Script parentScript = parentPLPs[j].getBuildScript();
                Script resolved = null;
                int i = 0;
                while (i < mainScript.getImportsCount() && resolved == null) {
                    scriptImport = mainScript.getImport(i);
                    if (scriptImport.getName().equals(parentScript.getName())) {
                        resolved = (Script)scriptImport.getResolved();
                    }
                    ++i;
                }
                if (resolved == null) {
                    PersistenceUtils.addScriptImportToPLP(plp, parentPLPs[j]);
                    BuildModel.INSTANCE.resolveImports((IModel)mainScript, null, null);
                    i = 0;
                    while (i < mainScript.getImportsCount() && resolved == null) {
                        scriptImport = mainScript.getImport(i);
                        if (scriptImport.getName().equals(parentScript.getName())) {
                            resolved = (Script)scriptImport.getResolved();
                        }
                        ++i;
                    }
                }
                if (resolved != null && mainRule.getBodyElementCount() == 0) {
                    try {
                        VariableDeclaration p = new VariableDeclaration("predecessor", IvmlTypes.projectType());
                        VariableExpression sourceVar = new VariableExpression((net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)mainRule.getParameter(2));
                        CallExpression predecessorAccess = new CallExpression((Object)mainRule, "predecessors", new Expression[]{sourceVar});
                        predecessorAccess.inferType();
                        CallArgument sourceProject = new CallArgument((Expression)new VariableExpression((net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)p));
                        CallArgument config = new CallArgument((Expression)new VariableExpression((net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)mainRule.getParameter(1)));
                        CallArgument targetProject = new CallArgument((Expression)new VariableExpression((net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)mainRule.getParameter(2)));
                        InstantiateExpression forBody = new InstantiateExpression(p, null, null, new CallArgument[]{sourceProject, config, targetProject});
                        forBody.inferType();
                        ExpressionStatement bodyStatement = new ExpressionStatement((Expression)forBody);
                        VariableDeclaration[] mapVariables = new VariableDeclaration[]{p};
                        ForStatement forEachLoop = new ForStatement(mapVariables, (Expression)predecessorAccess, new IRuleElement[]{bodyStatement}, new TypeDescriptor[]{p.getType()}, true);
                        mainRule.setBody(new IRuleElement[]{forEachLoop});
                        plp.buildScriptWasEdited();
                    }
                    catch (VilException e) {
                        LOGGER.warn("Rule could not be modified. Reason: " + e.getMessage());
                    }
                }
                ++j;
            }
        }
    }

    public static final void addImport(PLPInfo plp, PLPInfo predecessor, boolean considerVIL) {
        String projectName = predecessor.getProject() != null ? predecessor.getProject().getName() : predecessor.getProjectName();
        boolean hasProjectVersion = predecessor.getProject() != null && predecessor.getProject().getVersion() != null;
        ProjectImport parentImport = new ProjectImport(projectName, null);
        if (hasProjectVersion) {
            Version clonedVersion = null;
            try {
                clonedVersion = new Version(predecessor.getProject().getVersion().getVersion());
            }
            catch (VersionFormatException e) {
                LOGGER.exception((Exception)((Object)e));
            }
            try {
                DecisionVariableDeclaration[] vars = ExpressionVersionRestriction.createRestrictionVars((String)projectName);
                ConstraintSyntaxTree expr = ExpressionVersionRestriction.createSingleRestriction((DecisionVariableDeclaration)vars[1], (String)"==", (Version)clonedVersion);
                parentImport.setRestrictions((IVersionRestriction)new ExpressionVersionRestriction(expr, vars[0], vars[1]));
            }
            catch (RestrictionEvaluationException e) {
                LOGGER.exception((Exception)((Object)e));
            }
            catch (CSTSemanticException e) {
                LOGGER.exception((Exception)((Object)e));
            }
            catch (ValueDoesNotMatchTypeException e) {
                LOGGER.exception((Exception)((Object)e));
            }
        }
        plp.getProject().addImport(parentImport);
        if (considerVIL) {
            PersistenceUtils.addScriptImportToPLP(plp, predecessor);
        }
    }

    private static void addScriptImportToPLP(PLPInfo plp, PLPInfo predecessor) {
        boolean hasScriptVersion;
        String scriptName = predecessor.getBuildScript() != null ? predecessor.getBuildScript().getName() : predecessor.getProjectName();
        ModelImport scriptImport = new ModelImport(scriptName);
        boolean bl = hasScriptVersion = predecessor.getBuildScript() != null && predecessor.getBuildScript().getVersion() != null;
        if (hasScriptVersion) {
            Version clonedVersion = null;
            try {
                clonedVersion = new Version(predecessor.getBuildScript().getVersion().getVersion());
            }
            catch (VersionFormatException e) {
                LOGGER.exception((Exception)((Object)e));
            }
            try {
                scriptImport.setRestrictions((IVersionRestriction)Utils.createSingleRestriction((Script)plp.getBuildScript(), (String)"==", (Version)clonedVersion));
            }
            catch (RestrictionEvaluationException e) {
                LOGGER.exception((Exception)((Object)e));
            }
        }
        plp.addScriptImport((ModelImport<Script>)scriptImport);
    }

    public static void loadDefaultModels(ProgressObserver observer) {
        PersistenceUtils.loadDefaultModels(PersistenceUtils.class.getClassLoader(), observer, null);
    }

    public static void loadDefaultModels(ProgressObserver observer, Map<Configuration.PathKind, File> alternativePaths) {
        PersistenceUtils.loadDefaultModels(PersistenceUtils.class.getClassLoader(), observer, alternativePaths);
    }

    public static void loadDefaultModels(ClassLoader loader, ProgressObserver observer, Map<Configuration.PathKind, File> alternativePaths) {
        if (!defaultModelsLoaded) {
            defaultModelsLoaded = true;
            ArrayList libs = new ArrayList();
            URL dfltUrl = null;
            try {
                dfltUrl = DefaultLib.findDefaultLibURL((ClassLoader)loader, (String[])new String[]{DefaultLib.composePluginPattern((String)"net.ssehub.easy.producer.core"), "de.uni_hildesheim.sse.EASy-Producer.persistence"});
            }
            catch (IOException e) {
                EASyLoggerFactory.INSTANCE.getLogger(PersistenceUtils.class, "net.ssehub.easy.producer.core").error("While retrieving fallback libary URL: " + e.getMessage());
            }
            DefaultLib.appendQuietly(libs, dfltUrl);
            DefaultLibUtils.loadDefaultModels((ClassLoader)loader, (ProgressObserver)observer, (f, o) -> {
                Configuration cfg = PersistenceUtils.getDefaultModelsConfiguration(f, alternativePaths);
                PersistenceUtils.processLocation(cfg, true, true, observer);
            }, libs, (String)"net.ssehub.easy.producer.core");
        }
    }

    private static Configuration getDefaultModelsConfiguration(File folder, Map<Configuration.PathKind, File> alternativePaths) {
        Configuration result = new Configuration(folder);
        if (alternativePaths != null) {
            for (Map.Entry<Configuration.PathKind, File> entry : alternativePaths.entrySet()) {
                try {
                    result.setPath(entry.getKey(), entry.getValue());
                }
                catch (IOException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(PersistenceUtils.class, "net.ssehub.easy.producer.core").error("While loading default library and using " + String.valueOf((Object)entry.getKey()) + "= " + String.valueOf(entry.getValue()) + ": " + e.getMessage() + " - using default");
                }
            }
        }
        return result;
    }
}

