/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence.datatypes;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.ssehub.easy.producer.core.persistence.internal.util.FileUtils;

public class PathEnvironment {
    public static final String NAME_SEPARATOR = ":";
    private File baseFolder;
    private List<Entry> mapping = new ArrayList<Entry>();

    public PathEnvironment(File baseFolder) {
        this.baseFolder = baseFolder;
    }

    public void addMapping(String name, String ... paths) {
        if (name != null && ((String)name).length() > 0 && paths != null) {
            if (!((String)name).endsWith(NAME_SEPARATOR)) {
                name = (String)name + NAME_SEPARATOR;
            }
            Entry entry = null;
            int m = 0;
            while (entry == null && m < this.mapping.size()) {
                Entry tmp = this.mapping.get(m);
                if (tmp.getName().equals(name)) {
                    entry = tmp;
                }
                ++m;
            }
            if (entry == null) {
                this.mapping.add(new Entry((String)name, paths));
            } else {
                entry.add(paths);
            }
        }
    }

    public void removeMapping(String name) {
        if (name != null) {
            int m = this.mapping.size() - 1;
            while (m >= 0) {
                if (this.mapping.get(m).getName().equals(name)) {
                    this.mapping.remove(m);
                }
                --m;
            }
        }
    }

    public void clear() {
        this.mapping.clear();
    }

    public File getBaseFolder() {
        return this.baseFolder;
    }

    public String makeRelative(File location) {
        String result = null;
        int size = this.mapping.size();
        if (size > 0) {
            int m = 0;
            while (result == null && m < size) {
                result = this.mapping.get(m).makeRelative(location);
                ++m;
            }
        }
        if (result == null) {
            result = FileUtils.makeRelative(this.baseFolder, location);
        }
        return result;
    }

    public File makeAbsolute(String location) {
        File result = null;
        int size = this.mapping.size();
        if (size > 0) {
            int m = 0;
            while (result == null && m < size) {
                result = this.mapping.get(m).makeAbsolute(location);
                ++m;
            }
        }
        if (result == null) {
            result = FileUtils.makeAbsoluteFile(this.baseFolder, location);
        }
        return result;
    }

    private class Entry {
        private String name;
        private String[] paths;

        Entry(String name, String[] paths) {
            this.name = name;
            this.paths = new String[paths.length];
            System.arraycopy(paths, 0, this.paths, 0, paths.length);
            this.convertPaths(this.paths);
        }

        private void convertPaths(String[] paths) {
            int p = 0;
            while (p < paths.length) {
                paths[p] = FileUtils.toIndependent(paths[p]);
                ++p;
            }
        }

        String makeRelative(File location) {
            String result = null;
            String tmp = FileUtils.toIndependent(location.getAbsolutePath());
            int p = 0;
            while (result == null && p < this.paths.length) {
                if (this.paths[p] != null && this.paths[p].equals(tmp)) {
                    result = this.name + location.getName();
                }
                ++p;
            }
            return result;
        }

        File makeAbsolute(String location) {
            File result = null;
            if (location.startsWith(this.name)) {
                location = location.substring(this.name.length());
                String searchString = "/" + location;
                int len = location.length();
                int p = 0;
                while (result == null && p < this.paths.length) {
                    if (this.paths[p].endsWith(searchString) && this.paths[p].length() > len) {
                        result = new File(this.paths[p].substring(0, this.paths[p].length() - len) + location);
                    }
                    ++p;
                }
            }
            return result;
        }

        String getName() {
            return this.name;
        }

        void add(String[] paths) {
            if (paths != null) {
                String[] tmp = new String[this.paths.length + paths.length];
                System.arraycopy(this.paths, 0, tmp, 0, this.paths.length);
                System.arraycopy(paths, 0, tmp, this.paths.length, paths.length);
                this.convertPaths(tmp);
                this.paths = tmp;
            }
        }

        public String toString() {
            return this.name + Arrays.toString(this.paths);
        }
    }
}

