/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence.internal.xml;

import java.io.File;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.producer.core.persistence.datatypes.ModelType;
import net.ssehub.easy.producer.core.persistence.datatypes.PathEnvironment;
import net.ssehub.easy.producer.core.persistence.datatypes.PersistentProject;
import net.ssehub.easy.producer.core.persistence.internal.util.FileUtils;

public class XMLConstants {
    static final String LINEFEED = "\r\n";
    static final String TABSTOP = "\t";
    static final String QUOTES = "&quot;";
    static final String LESSTHAN = "&lt;";
    static final String GREATERTHAN = "&gt;";
    static final String AMP = "&amp;";
    static final String PATH_4_ROOT_NODE = "/ProductLineProject";
    static final String PATH_4_TRANSFORMATORS = "/ProductLineProject/transformators";
    private static final String ROOT_NODE_NAME = "ProductLineProject";
    private static final String TRANSFORMATORS_NODE_NAME = "transformators";
    static final String CLOSING_ROOT = "</ProductLineProject>";
    static final String STARTING_TRANSFORMATORS = "<transformators>";

    static StringBuffer startTag(PersistentProject project, PathEnvironment pathEnv) {
        File location;
        StringBuffer tag = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        tag.append(LINEFEED);
        tag.append("<");
        tag.append(ROOT_NODE_NAME);
        tag.append(' ');
        tag.append("id");
        tag.append("=\"");
        tag.append(project.getID());
        tag.append("\" ");
        tag.append("name");
        tag.append("=\"");
        tag.append(project.getProject().getName());
        Version version = project.getVersion();
        if (version != null) {
            tag.append("\" ");
            tag.append("version");
            tag.append("=\"");
            tag.append(version.getVersion());
        }
        if ((location = project.getLocation()) != null) {
            tag.append("\" ");
            tag.append("location");
            tag.append("=\"");
            tag.append(FileUtils.toIndependent(pathEnv.makeRelative(location)));
        }
        tag.append("\">");
        tag.append(LINEFEED);
        return tag;
    }

    static StringBuffer startingTag(ModelType type) {
        StringBuffer tag = new StringBuffer();
        tag.append(TABSTOP);
        tag.append("<");
        tag.append(type.getDenotation());
        tag.append(">");
        tag.append(LINEFEED);
        return tag;
    }

    static StringBuffer closingTag(ModelType type) {
        StringBuffer tag = new StringBuffer();
        tag.append(TABSTOP);
        tag.append("</");
        tag.append(type.getDenotation());
        tag.append(">");
        tag.append(LINEFEED);
        return tag;
    }

    static StringBuffer path4Models(ModelType type) {
        StringBuffer path = new StringBuffer();
        path.append(PATH_4_ROOT_NODE);
        path.append("/");
        String node = type.getDenotation();
        path.append(node);
        return path;
    }
}

