/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence.internal.xml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.core.persistence.datatypes.Entity;
import net.ssehub.easy.producer.core.persistence.datatypes.Model;
import net.ssehub.easy.producer.core.persistence.datatypes.ModelType;
import net.ssehub.easy.producer.core.persistence.datatypes.PathEnvironment;
import net.ssehub.easy.producer.core.persistence.datatypes.PersistentProject;
import net.ssehub.easy.producer.core.persistence.internal.StorageConnector;
import net.ssehub.easy.producer.core.persistence.internal.xml.XMLConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XmlConnector
implements StorageConnector {
    private String xmlFilePath;
    private PathEnvironment pathEnv;

    public XmlConnector(String xmlFilePath, PathEnvironment pathEnv) {
        this.xmlFilePath = xmlFilePath;
        this.pathEnv = pathEnv;
    }

    @Override
    public void loadModels(PersistentProject project) throws PersistenceException {
        Model[] models = new Model[project.getModelCount()];
        int i = 0;
        while (i < models.length) {
            models[i] = project.getModel(i);
            ++i;
        }
        this.loadModels(models);
    }

    @Override
    public void loadModels(Model ... models) throws PersistenceException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        XPathExpression expr = null;
        Document doc = this.createXMLDocument();
        int i = 0;
        while (i < models.length) {
            Model model = models[i];
            String path = null;
            path = model.getModelType() == ModelType.ROOT ? "/ProductLineProject" : XMLConstants.path4Models(model.getModelType()).toString();
            Object result = null;
            try {
                expr = xPath.compile(path);
                result = expr.evaluate(doc, XPathConstants.NODE);
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
            Node nodes = (Node)result;
            if (ModelType.ROOT == model.getModelType()) {
                Entity entity = new Entity();
                Element element = (Element)nodes;
                int j = 0;
                while (j < element.getAttributes().getLength()) {
                    String attrName = element.getAttributes().item(j).getNodeName();
                    String attrValue = element.getAttributes().item(j).getNodeValue();
                    entity.createAttribute(attrName, attrValue);
                    ++j;
                }
                model.addEntity(entity);
            } else if (nodes != null) {
                this.createEntities(nodes, model);
            }
            ++i;
        }
    }

    private Document createXMLDocument() throws PersistenceException {
        Document doc;
        DocumentBuilder db;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new PersistenceException(e);
        }
        try {
            doc = db.parse(this.xmlFilePath);
        }
        catch (SAXException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        doc.normalize();
        return doc;
    }

    private void createEntities(Node node, Model model) {
        int i = 0;
        while (i < node.getChildNodes().getLength()) {
            Node entityNode = node.getChildNodes().item(i);
            if (entityNode.getNodeType() != 3) {
                Entity entity = new Entity();
                Element element = (Element)entityNode;
                int j = 0;
                while (j < element.getAttributes().getLength()) {
                    String attrName = element.getAttributes().item(j).getNodeName();
                    String attrValue = element.getAttributes().item(j).getNodeValue();
                    entity.createAttribute(attrName, attrValue);
                    ++j;
                }
                model.addEntity(entity);
            }
            ++i;
        }
    }

    @Override
    public void saveModels(PersistentProject project) throws PersistenceException {
        String indent = "\t\t";
        StringBuffer xml = new StringBuffer();
        xml.append(XMLConstants.startTag(project, this.pathEnv));
        int j = 0;
        while (j < project.getModelCount()) {
            Model model = project.getModel(j);
            if (model.getModelType() != ModelType.ROOT) {
                StringBuffer openingTag = XMLConstants.startingTag(model.getModelType());
                StringBuffer endingTag = XMLConstants.closingTag(model.getModelType());
                xml.append(openingTag);
                int i = 0;
                while (i < model.getEntityCount()) {
                    Entity entity = model.getEntity(i);
                    xml.append(this.getXmlFromEntity(entity, indent));
                    ++i;
                }
                xml.append(endingTag);
            }
            ++j;
        }
        xml.append("</ProductLineProject>");
        try {
            FileWriter writer = new FileWriter(this.xmlFilePath);
            writer.append(xml.toString());
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    private String getXmlFromEntity(Entity entity, String indent) {
        StringBuffer xml = new StringBuffer();
        xml.append(indent + "<entity ");
        for (Map.Entry<String, String> attr : entity.getAttributes().entrySet()) {
            this.appendAttribute(xml, attr);
        }
        xml.deleteCharAt(xml.length() - 1);
        xml.append(" />");
        xml.append("\r\n");
        return xml.toString();
    }

    private void appendAttribute(StringBuffer xml, Map.Entry<String, String> attr) {
        String attName = attr.getKey().replaceAll("&", "&amp;");
        String attValue = attr.getValue().replaceAll("&", "&amp;");
        attName = attName.replaceAll("\"", "&quot;");
        attValue = attr.getValue().replaceAll("\"", "&quot;");
        attName = attName.replaceAll(">", "&gt;");
        attValue = attValue.replaceAll(">", "&gt;");
        attName = attName.replaceAll("<", "&lt;");
        attValue = attValue.replaceAll("<", "&lt;");
        xml.append(attName);
        xml.append("=\"");
        xml.append(attValue);
        xml.append("\" ");
    }

    @Override
    public String getProjectID() {
        String id = null;
        File configFile = new File(this.xmlFilePath);
        if (configFile.exists()) {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            XPathExpression expr = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = null;
            try {
                db = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException e1) {
                e1.printStackTrace();
            }
            Document doc = null;
            try {
                doc = db.parse(configFile);
            }
            catch (SAXException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            doc.normalize();
            String path = "/ProductLineProject";
            Object result = null;
            try {
                expr = xPath.compile(path);
                result = expr.evaluate(doc, XPathConstants.NODE);
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
            Node nodes = (Node)result;
            Entity entity = new Entity();
            Element element = (Element)nodes;
            int j = 0;
            while (j < element.getAttributes().getLength()) {
                String attrName = element.getAttributes().item(j).getNodeName();
                String attrValue = element.getAttributes().item(j).getNodeValue();
                entity.createAttribute(attrName, attrValue);
                if ("id".equals(attrName)) {
                    id = attrValue;
                }
                ++j;
            }
        }
        return id;
    }

    @Override
    public PathEnvironment getPathEnvironment() {
        return this.pathEnv;
    }
}

