/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence.standard;

import java.io.File;
import java.io.FileFilter;
import net.ssehub.easy.producer.core.persistence.Configuration;

public class EASyConfigFileFilter
implements FileFilter {
    private boolean copyIVML = false;
    private boolean copyVIL = false;
    private boolean copyVTL = false;

    public EASyConfigFileFilter(Configuration.PathKind ... elementsToCopy) {
        if (elementsToCopy == null || elementsToCopy.length == 0) {
            this.copyIVML = true;
            this.copyVIL = true;
            this.copyVTL = true;
        } else {
            int i = 0;
            while (i < elementsToCopy.length) {
                switch (elementsToCopy[i]) {
                    case IVML: {
                        this.copyIVML = true;
                        break;
                    }
                    case VIL: {
                        this.copyVIL = true;
                        break;
                    }
                    case VTL: {
                        this.copyVTL = true;
                        break;
                    }
                }
                ++i;
            }
        }
    }

    private boolean considerIVMLFiles(String file) {
        return this.copyIVML && (file.endsWith(".ivml") || file.endsWith(".text"));
    }

    private boolean considerVILFiles(String file) {
        return this.copyVIL && file.endsWith(".vil");
    }

    private boolean considerVTLFiles(String file) {
        return this.copyVTL && file.endsWith(".vtl");
    }

    private boolean isEASyConfigFile(String filename) {
        String file = filename.toLowerCase();
        return this.considerIVMLFiles(file) || this.considerVILFiles(file) || this.considerVTLFiles(file);
    }

    @Override
    public boolean accept(File file) {
        return file.isDirectory() ^ this.isEASyConfigFile(file.getName());
    }
}

