/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence.standard;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.persistence.Configuration;
import net.ssehub.easy.producer.core.persistence.standard.EASyConfigFileFilter;
import net.ssehub.easy.varModel.management.VarModel;
import org.apache.commons.io.FileUtils;

public class EASyConfigFileImporter {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(EASyConfigFileImporter.class, "net.ssehub.easy.producer.core");
    private PLPInfo plpTarget;

    public EASyConfigFileImporter(PLPInfo plpTarget) {
        this.plpTarget = plpTarget;
        this.resetDestinationPath(plpTarget.getConfigLocation());
        this.resetDestinationPath(plpTarget.getScriptLocation());
        this.resetDestinationPath(plpTarget.getTemplateLocation());
    }

    private void resetDestinationPath(File destinationPath) {
        File[] children = destinationPath.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        int i = 0;
        while (i < children.length) {
            children[i].delete();
            ++i;
        }
    }

    public void copyConfigFiles(PLPInfo plpSource, String namespace) {
        File ivmlDestination = this.plpTarget.getConfigLocation();
        File vilDestination = this.plpTarget.getScriptLocation();
        File vtlDestination = this.plpTarget.getTemplateLocation();
        if (namespace != null) {
            ivmlDestination = new File(ivmlDestination, namespace);
            vilDestination = new File(vilDestination, namespace);
            vtlDestination = new File(vtlDestination, namespace);
        }
        this.copyConfigFiles(plpSource.getConfigLocation(), ivmlDestination, Configuration.PathKind.IVML);
        this.copyConfigFiles(plpSource.getScriptLocation(), vilDestination, Configuration.PathKind.VIL);
        this.copyConfigFiles(plpSource.getTemplateLocation(), vtlDestination, Configuration.PathKind.VTL);
    }

    private void copyConfigFiles(File source, File destination, Configuration.PathKind configElement) {
        try {
            FileUtils.copyDirectory((File)source, (File)destination, (FileFilter)new EASyConfigFileFilter(configElement));
        }
        catch (IOException e1) {
            LOGGER.exception((Exception)e1);
        }
        try {
            switch (configElement) {
                case IVML: {
                    VarModel.INSTANCE.updateModelInformation(destination, ProgressObserver.NO_OBSERVER);
                    break;
                }
                case VIL: {
                    BuildModel.INSTANCE.updateModelInformation(destination, ProgressObserver.NO_OBSERVER);
                    break;
                }
                case VTL: {
                    TemplateModel.INSTANCE.updateModelInformation(destination, ProgressObserver.NO_OBSERVER);
                    break;
                }
            }
        }
        catch (ModelManagementException e) {
            LOGGER.exception((Exception)((Object)e));
        }
    }
}

