/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence.standard;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.mgmt.SPLsManager;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.core.persistence.datatypes.Entity;
import net.ssehub.easy.producer.core.persistence.datatypes.IPersistencer;
import net.ssehub.easy.producer.core.persistence.datatypes.Model;
import net.ssehub.easy.producer.core.persistence.datatypes.ModelType;
import net.ssehub.easy.producer.core.persistence.datatypes.PersistentProject;
import net.ssehub.easy.producer.core.persistence.standard.PersistenceConstants;
import net.ssehub.easy.producer.core.varMod.container.ProjectContainer;
import net.ssehub.easy.reasoning.core.reasoner.AttributeException;
import net.ssehub.easy.reasoning.core.reasoner.AttributeValues;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;

public class PersistentProject2PLPConverter
implements PersistenceConstants {
    private IPersistencer persistencer;
    private PersistentProject project;

    public PersistentProject2PLPConverter(IPersistencer persistencer, PersistentProject project) {
        this.persistencer = persistencer;
        this.project = project;
    }

    public PLPInfo persistentProject2PLP() throws PersistenceException {
        PLPInfo plp = null;
        Model model = this.project.getModel(ModelType.ROOT);
        String projectID = model.getEntity(0).getAttributes().get("id");
        String projectname = this.project.getName();
        plp = SPLsManager.INSTANCE.getPLP(projectID);
        if (plp == null || plp.isPreliminary()) {
            File location = this.project.getLocation();
            ProjectContainer varModel = this.project.getProject();
            String version = varModel != null && varModel.getVersion() != null ? varModel.getVersion().getVersion() : null;
            plp = new PLPInfo(projectID, projectname, version, location);
        }
        int i = 0;
        while (i < this.project.getModelCount()) {
            model = this.project.getModel(i);
            switch (model.getModelType()) {
                case PREDECESSORS: {
                    plp.getMemberController().setPredecessors(this.model2Relatives(model));
                    break;
                }
                case SUCCESSORS: {
                    plp.getMemberController().setSuccessors(this.model2Relatives(model));
                    break;
                }
                case INSTANTIATORS: {
                    break;
                }
                case REASONERS: {
                    this.createReasonerConfiguration(plp, model);
                    break;
                }
                case SETTINGS: {
                    if (model.getEntityCount() <= 0) break;
                    String debug = model.getEntity(0).getAttributeValue("debug");
                    plp.setSaveDebugInformation(Boolean.valueOf(debug));
                    break;
                }
            }
            ++i;
        }
        if (plp.getProject() != null && plp.getReasonerConfig().getAttributeValues() != null) {
            try {
                plp.getReasonerConfig().getAttributeValues().resolveUsing(plp.getProject(), true);
            }
            catch (AttributeException attributeException) {
                // empty catch block
            }
        }
        return plp;
    }

    private void createReasonerConfiguration(PLPInfo plp, Model model) {
        ReasonerConfiguration reasonerConfig = new ReasonerConfiguration();
        int i = 0;
        while (i < model.getEntityCount()) {
            Entity entity = model.getEntity(i);
            if (entity.getAttributeValue("timeout") != null) {
                reasonerConfig.setTimeout(Integer.valueOf(entity.getAttributeValue("timeout")).intValue());
            }
            if (entity.getAttributeValue("attribute") != null) {
                String attribute = entity.getAttributeValue("attribute");
                String values = entity.getAttributeValue("values");
                if (values != null) {
                    ArrayList<String> attributeValues = new ArrayList<String>();
                    StringTokenizer tokens = new StringTokenizer(values, ";");
                    while (tokens.hasMoreTokens()) {
                        attributeValues.add(tokens.nextToken());
                    }
                    AttributeValues attributes = reasonerConfig.getAttributeValues();
                    if (attributes == null) {
                        attributes = new AttributeValues();
                        reasonerConfig.setAttributeValues(attributes);
                    }
                    attributes.addUnresolved(attribute, attributeValues);
                }
            }
            ++i;
        }
        plp.setReasonerConfig(reasonerConfig);
    }

    private List<PLPInfo> model2Relatives(Model model) {
        LinkedList<PLPInfo> relatives = new LinkedList<PLPInfo>();
        int j = 0;
        while (j < model.getEntityCount()) {
            Entity entity = model.getEntity(j);
            String id = entity.getAttributeValue("id");
            String memberName = entity.getAttributeValue("name");
            String version = entity.getAttributeValue("version");
            String tmp = entity.getAttributeFileString("location");
            File location = tmp != null ? this.persistencer.getPathEnvironment().makeAbsolute(tmp) : null;
            PLPInfo info = SPLsManager.INSTANCE.getPLP(id);
            if (info == null) {
                info = new PLPInfo(id, memberName, version, location);
                SPLsManager.INSTANCE.addPLP(info);
            }
            relatives.add(info);
            ++j;
        }
        return relatives;
    }
}

