/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.frontend;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.reasoning.core.frontend.IReasonerInstance;
import net.ssehub.easy.reasoning.core.frontend.ReasonerFrontend;
import net.ssehub.easy.reasoning.core.reasoner.EvaluationResult;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.reasoning.core.reasoner.ValueCreationResult;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;

public class ReasonerAdapter {
    private static Map<Thread, ReasonerAdapter> instances = new HashMap<Thread, ReasonerAdapter>();
    private Map<Configuration, IReasonerAdapter> cache = new HashMap<Configuration, IReasonerAdapter>();
    private IReasonerAdapter deflt;
    private boolean enableInstanceBasedReasoning;

    public ReasonerAdapter() {
        this(true);
    }

    public ReasonerAdapter(boolean enableInstanceBasedReasoning) {
        this.setEnableInstanceBasedReasoning(enableInstanceBasedReasoning);
    }

    private IReasonerAdapter getAdapter(Configuration cfg, ReasonerConfiguration reasonerConfiguration) {
        IReasonerAdapter adapter = this.cache.get(cfg);
        if (adapter == null) {
            IReasonerInstance instance;
            if (this.enableInstanceBasedReasoning && this.cache.containsKey(cfg) && (instance = ReasonerFrontend.getInstance().createInstance(cfg, reasonerConfiguration)) != null) {
                adapter = new InstanceReasonerAdapter(instance);
                this.cache.put(cfg, adapter);
            }
            if (adapter == null) {
                if (this.deflt == null) {
                    this.deflt = new FrontendReasonerAdapter();
                }
                adapter = this.deflt;
            }
        }
        return adapter;
    }

    public ReasoningResult isConsistent(Configuration cfg, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
        return this.getAdapter(cfg, reasonerConfiguration).isConsistent(cfg, reasonerConfiguration, observer);
    }

    public ReasoningResult check(Configuration cfg, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
        return this.getAdapter(cfg, reasonerConfiguration).check(cfg, reasonerConfiguration, observer);
    }

    public ReasoningResult propagate(Configuration cfg, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
        return this.getAdapter(cfg, reasonerConfiguration).propagate(cfg, reasonerConfiguration, observer);
    }

    public EvaluationResult evaluate(Configuration cfg, List<Constraint> constraints, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
        return this.getAdapter(cfg, reasonerConfiguration).evaluate(cfg, constraints, reasonerConfiguration, observer);
    }

    public ValueCreationResult createValue(Configuration cfg, AbstractVariable var, IDatatype type, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
        return this.getAdapter(cfg, reasonerConfiguration).createValue(cfg, var, type, reasonerConfiguration, observer);
    }

    public void setEnableInstanceBasedReasoning(boolean enableInstanceBasedReasoning) {
        this.enableInstanceBasedReasoning = enableInstanceBasedReasoning;
    }

    public void clear() {
        this.cache.clear();
    }

    public void clear(Configuration config) {
        if (config != null) {
            this.cache.remove(config);
        }
    }

    public void register(Configuration config) {
        if (config != null && !this.cache.containsKey(config)) {
            this.cache.put(config, null);
        }
    }

    public static void registerInstance(ReasonerAdapter adapter) {
        instances.put(Thread.currentThread(), adapter);
    }

    public static void unregisterInstance() {
        instances.remove(Thread.currentThread());
    }

    public static ReasonerAdapter getInstance() {
        return instances.get(Thread.currentThread());
    }

    public static ReasonerAdapter getInstanceSafe() {
        ReasonerAdapter result = instances.get(Thread.currentThread());
        if (result == null) {
            result = new ReasonerAdapter(false);
        }
        return result;
    }

    private class FrontendReasonerAdapter
    implements IReasonerAdapter {
        private FrontendReasonerAdapter() {
        }

        @Override
        public ReasoningResult propagate(Configuration cfg, ReasonerConfiguration rConfig, ProgressObserver observer) {
            return ReasonerFrontend.getInstance().propagate(cfg, rConfig, observer);
        }

        @Override
        public ReasoningResult isConsistent(Configuration cfg, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
            return ReasonerFrontend.getInstance().isConsistent(cfg.getProject(), reasonerConfiguration, observer);
        }

        @Override
        public ReasoningResult check(Configuration cfg, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
            return ReasonerFrontend.getInstance().check(cfg, reasonerConfiguration, observer);
        }

        @Override
        public EvaluationResult evaluate(Configuration cfg, List<Constraint> constraints, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
            return ReasonerFrontend.getInstance().evaluate(cfg, constraints, reasonerConfiguration, observer);
        }

        @Override
        public ValueCreationResult createValue(Configuration cfg, AbstractVariable var, IDatatype type, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
            return ReasonerFrontend.getInstance().createValue(cfg, var, type, reasonerConfiguration, observer);
        }
    }

    private static interface IReasonerAdapter {
        public ReasoningResult isConsistent(Configuration var1, ReasonerConfiguration var2, ProgressObserver var3);

        public ReasoningResult check(Configuration var1, ReasonerConfiguration var2, ProgressObserver var3);

        public ReasoningResult propagate(Configuration var1, ReasonerConfiguration var2, ProgressObserver var3);

        public EvaluationResult evaluate(Configuration var1, List<Constraint> var2, ReasonerConfiguration var3, ProgressObserver var4);

        public ValueCreationResult createValue(Configuration var1, AbstractVariable var2, IDatatype var3, ReasonerConfiguration var4, ProgressObserver var5);
    }

    private class InstanceReasonerAdapter
    implements IReasonerAdapter {
        private IReasonerInstance instance;

        private InstanceReasonerAdapter(IReasonerInstance instance) {
            this.instance = instance;
        }

        @Override
        public ReasoningResult propagate(Configuration config, ReasonerConfiguration rConfig, ProgressObserver observer) {
            return this.instance.propagate(observer);
        }

        @Override
        public ReasoningResult isConsistent(Configuration cfg, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
            return this.instance.isConsistent(observer);
        }

        @Override
        public ReasoningResult check(Configuration cfg, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
            return this.instance.check(observer);
        }

        @Override
        public EvaluationResult evaluate(Configuration cfg, List<Constraint> constraints, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
            return this.instance.evaluate(constraints, observer);
        }

        @Override
        public ValueCreationResult createValue(Configuration cfg, AbstractVariable var, IDatatype type, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
            return this.instance.createValue(var, type, observer);
        }
    }
}

