/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.frontend;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.messages.Message;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.reasoning.core.frontend.IMessageListener;
import net.ssehub.easy.reasoning.core.frontend.IReasonerInstance;
import net.ssehub.easy.reasoning.core.impl.ReasonerHelper;
import net.ssehub.easy.reasoning.core.impl.ReasonerRegistry;
import net.ssehub.easy.reasoning.core.reasoner.EvaluationResult;
import net.ssehub.easy.reasoning.core.reasoner.GeneralReasonerCapabilities;
import net.ssehub.easy.reasoning.core.reasoner.IChainingReasoner;
import net.ssehub.easy.reasoning.core.reasoner.IReasoner;
import net.ssehub.easy.reasoning.core.reasoner.IReasonerRegistry;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerDescriptor;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.reasoning.core.reasoner.ValueCreationResult;
import net.ssehub.easy.varModel.capabilities.DefaultReasonerAccess;
import net.ssehub.easy.varModel.capabilities.IReasonerCapability;
import net.ssehub.easy.varModel.confModel.AssignmentResolver;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.ConfigurationInitializerRegistry;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;

public class ReasonerFrontend {
    private static final String NO_REASONING_AVAILABE_MSG = "No reasoners are present.\nConsequently, desired reasoning operation could not performed.";
    private static final ReasonerFrontend INSTANCE = new ReasonerFrontend();
    private ReasonerRegistry registry = ReasonerRegistry.getInstance();
    private IReasoner reasonerHint;
    private int timeout = 0;

    private ReasonerFrontend() {
        DefaultReasonerAccess.setProvider((DefaultReasonerAccess.IDefaultReasonerProvider)new DefaultReasonerProvider());
        Boolean fallback = Boolean.valueOf(System.getProperty("easy.configuration.useAssignmentResolver", "false").toLowerCase());
        if (!fallback.booleanValue()) {
            this.installConfigurationInitializer();
        }
    }

    private void installConfigurationInitializer() {
        ConfigurationInitializerRegistry.setInitializer((ConfigurationInitializerRegistry.IConfigurationInitializer)new ConfigurationInitializerRegistry.IConfigurationInitializer(){
            private ConfigurationInitializerRegistry.IConfigurationInitializer fallback = ConfigurationInitializerRegistry.getInitializer();

            public List<Message> initializeConfiguration(Configuration config, ProgressObserver observer) {
                ArrayList<net.ssehub.easy.reasoning.core.reasoner.Message> result = null;
                IReasoner reasoner = ReasonerFrontend.canInitializeConfig(ReasonerFrontend.this.getActualReasoner(config, null, null));
                int r = 0;
                while (reasoner == null && r < ReasonerFrontend.this.registry.getReasonerCount()) {
                    IReasoner tmp = ReasonerFrontend.this.registry.getReasoner(r);
                    if (ReasonerFrontend.isReadyForUse(tmp)) {
                        reasoner = ReasonerFrontend.canInitializeConfig(tmp);
                    }
                    ++r;
                }
                boolean useFallback = false;
                if (reasoner != null) {
                    ReasonerConfiguration initCfg = new ReasonerConfiguration();
                    EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.reasoning.core").info("Initializing configuration with reasoner: " + reasoner.getDescriptor().getName());
                    ReasoningResult tmp = reasoner.initialize(config, initCfg, observer);
                    useFallback = tmp.reasoningUnsupported();
                    if (tmp.getMessageCount() > 0) {
                        result = new ArrayList<net.ssehub.easy.reasoning.core.reasoner.Message>();
                        int m = 0;
                        while (m < tmp.getMessageCount()) {
                            result.add(tmp.getMessage(m));
                            ++m;
                        }
                    }
                } else {
                    useFallback = true;
                }
                if (useFallback) {
                    EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.reasoning.core").info("Initializing configuration with fallback: " + this.fallback.getClass().getName());
                    result = this.fallback.initializeConfiguration(config, observer);
                }
                return result;
            }

            public boolean supportsElementCopy() {
                ReasonerDescriptor pref = ReasonerFrontend.this.getPreferredReasoner();
                return pref == null ? false : pref.hasCapability(GeneralReasonerCapabilities.CONFIGURATION_INITIALIZATION);
            }

            public boolean resolveDefaultValue(IDecisionVariable variable) {
                return AssignmentResolver.resolveDefaultValue((IDecisionVariable)variable);
            }
        });
    }

    private static IReasoner canInitializeConfig(IReasoner reasoner) {
        return ReasonerFrontend.checkForCapabilitiy(reasoner, GeneralReasonerCapabilities.CONFIGURATION_INITIALIZATION);
    }

    private static IReasoner checkForCapabilitiy(IReasoner reasoner, IReasonerCapability capability) {
        ReasonerDescriptor desc;
        IReasoner result = null;
        if (reasoner != null && (desc = reasoner.getDescriptor()) != null && desc.hasCapability(capability)) {
            result = reasoner;
        }
        return result;
    }

    public static final ReasonerFrontend getInstance() {
        return INSTANCE;
    }

    public IReasonerRegistry getRegistry() {
        return this.registry;
    }

    private IReasoner getActualReasoner(Configuration configuration, List<Constraint> constraints, ReasonerConfiguration reasonerConfiguration) {
        ReasonerDescriptor descriptor;
        IReasoner result = null;
        if (reasonerConfiguration != null && (descriptor = reasonerConfiguration.getDefaultResoner()) != null) {
            result = this.registry.findReasoner(descriptor);
        }
        if (this.reasonerHint != null && ReasonerFrontend.isReadyForUse(this.reasonerHint)) {
            result = this.reasonerHint;
        }
        int r = 0;
        while (result == null && r < this.registry.getReasonerCount()) {
            IReasoner reasoner = this.registry.getReasoner(r);
            if (ReasonerFrontend.isReadyForUse(reasoner)) {
                result = reasoner;
            }
            ++r;
        }
        return result;
    }

    private static boolean isReadyForUse(IReasoner reasoner) {
        ReasonerDescriptor desc;
        boolean result = false;
        if (reasoner != null && (desc = reasoner.getDescriptor()) != null) {
            result = desc.isReadyForUse();
        }
        return result;
    }

    public ReasoningResult isConsistent(Project project, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
        ReasoningResult result = null;
        IReasoner reasoner = this.getActualReasoner(null, null, reasonerConfiguration);
        if (reasoner != null) {
            result = reasoner.isConsistent(project, reasonerConfiguration, observer);
        } else {
            result = new ReasoningResult();
            net.ssehub.easy.reasoning.core.reasoner.Message warning = new net.ssehub.easy.reasoning.core.reasoner.Message(NO_REASONING_AVAILABE_MSG, null, Status.WARNING);
            result.addMessage(warning);
        }
        return result;
    }

    public ReasoningResult check(Configuration cfg, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
        ReasoningResult result = null;
        IReasoner reasoner = this.getActualReasoner(cfg, null, reasonerConfiguration);
        if (reasoner != null) {
            result = reasoner.check(cfg, reasonerConfiguration, observer);
        } else {
            result = new ReasoningResult();
            net.ssehub.easy.reasoning.core.reasoner.Message warning = new net.ssehub.easy.reasoning.core.reasoner.Message(NO_REASONING_AVAILABE_MSG, null, Status.WARNING);
            result.addMessage(warning);
        }
        return result;
    }

    public ReasoningResult propagate(Configuration cfg, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
        ReasoningResult result = null;
        IReasoner reasoner = this.getActualReasoner(cfg, null, reasonerConfiguration);
        if (reasoner != null) {
            result = reasoner.propagate(cfg, reasonerConfiguration, observer);
        } else {
            result = new ReasoningResult();
            net.ssehub.easy.reasoning.core.reasoner.Message warning = new net.ssehub.easy.reasoning.core.reasoner.Message(NO_REASONING_AVAILABE_MSG, null, Status.WARNING);
            result.addMessage(warning);
        }
        return result;
    }

    public EvaluationResult evaluate(Configuration cfg, List<Constraint> constraints, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
        EvaluationResult result = null;
        ArrayList<Constraint> erroneous = new ArrayList<Constraint>();
        ArrayList<Constraint> toEvaluate = new ArrayList<Constraint>();
        int i = 0;
        while (i < constraints.size()) {
            Constraint constraint = constraints.get(i);
            if (constraint != null) {
                if (constraint.isBooleanConstraint()) {
                    toEvaluate.add(constraint);
                } else {
                    erroneous.add(constraint);
                }
            }
            ++i;
        }
        IReasoner reasoner = this.getActualReasoner(cfg, toEvaluate, reasonerConfiguration);
        if (reasoner != null) {
            result = reasoner.evaluate(cfg, toEvaluate, reasonerConfiguration, observer);
        }
        if (result == null) {
            result = new EvaluationResult();
        }
        int i2 = 0;
        while (i2 < erroneous.size()) {
            result.addEvaluationPair(new EvaluationResult.EvaluationPair((Constraint)erroneous.get(i2), EvaluationResult.ConstraintEvaluationResult.UNKNOWN));
            ++i2;
        }
        return result;
    }

    public int getReadyForUseCount() {
        int count = 0;
        int r = 0;
        while (r < this.registry.getReasonerCount()) {
            ReasonerDescriptor desc = this.registry.getReasoner(r).getDescriptor();
            if (desc != null && desc.isReadyForUse()) {
                ++count;
            }
            ++r;
        }
        return count;
    }

    public int getReasonersCount() {
        return this.registry.getReasonerCount();
    }

    public ReasonerDescriptor getReasonerDescriptor(int index) {
        return this.registry.getReasoner(index).getDescriptor();
    }

    public ReasoningResult upgradeReasoner(ReasonerDescriptor descriptor, URI uri, ProgressObserver observer) {
        ReasoningResult result = null;
        if (uri != null) {
            IReasoner reasoner = this.registry.findReasoner(descriptor);
            if (reasoner != null) {
                result = reasoner.upgrade(uri, observer);
            }
            if (result == null) {
                result = new ReasoningResult();
                result.addMessage(new net.ssehub.easy.reasoning.core.reasoner.Message("upgrade is not supported", null, Status.ERROR));
            }
        } else {
            result = new ReasoningResult();
            result.addMessage(new net.ssehub.easy.reasoning.core.reasoner.Message("invalid URL", null, Status.ERROR));
        }
        return result;
    }

    public void setReasonerHint(ReasonerDescriptor descriptor) {
        this.reasonerHint = descriptor == null ? null : this.findReasoner(descriptor);
    }

    public boolean hasReasonerCapability(IReasonerCapability capability) {
        return this.hasReasonerCapability(capability, null);
    }

    public boolean hasReasonerCapability(IReasonerCapability capability, ReasonerConfiguration reasonerConfiguration) {
        boolean result = false;
        IReasoner reasoner = this.getActualReasoner(null, null, reasonerConfiguration);
        if (reasoner != null) {
            result = reasoner.getDescriptor().hasCapability(capability);
        }
        return result;
    }

    public ReasonerDescriptor getReasonerHint() {
        ReasonerDescriptor result = null;
        if (this.reasonerHint != null) {
            result = this.reasonerHint.getDescriptor();
        }
        return result;
    }

    IReasoner findReasoner(ReasonerDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor must not be null");
        }
        IReasoner reasoner = this.registry.findReasoner(descriptor);
        if (reasoner == null) {
            throw new IllegalArgumentException("descriptor does not fit to a registered reasoner");
        }
        return reasoner;
    }

    public IReasoner findReasoner(String name, String version) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        IReasoner reasoner = this.registry.findReasoner(name, version);
        if (reasoner == null) {
            throw new IllegalArgumentException("descriptor does not fit to a registered reasoner");
        }
        return reasoner;
    }

    public void register(IMessageListener listener) {
        this.registry.register(listener);
    }

    public void unregister(IMessageListener listener) {
        this.registry.unregister(listener);
    }

    public boolean reasoningSupported() {
        return this.getReadyForUseCount() > 0;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public ReasonerDescriptor getPreferredReasoner() {
        ReasonerDescriptor result = null;
        int maxCapCount = 0;
        int r = 0;
        while (r < this.getReasonersCount()) {
            ReasonerDescriptor desc = this.getReasonerDescriptor(r);
            int capCount = desc.getCapabilityCount();
            if (result == null || capCount > maxCapCount) {
                maxCapCount = capCount;
                result = desc;
            }
            ++r;
        }
        return result;
    }

    public ReasonerDescriptor setPreferredReasoner() {
        ReasonerDescriptor pref = this.getPreferredReasoner();
        if (pref != null) {
            this.setReasonerHint(pref);
        }
        return pref;
    }

    public boolean isChainingReasoner(ReasonerDescriptor descriptor) {
        return this.findReasoner(descriptor) instanceof IChainingReasoner;
    }

    public IReasonerInstance createInstance(Configuration cfg, ReasonerConfiguration reasonerConfiguration) {
        IReasoner reasoner = this.getActualReasoner(cfg, null, reasonerConfiguration);
        IReasonerInstance result = reasoner != null ? reasoner.createInstance(cfg, reasonerConfiguration) : null;
        return result;
    }

    public ValueCreationResult createValue(Configuration cfg, AbstractVariable var, IDatatype type, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
        IReasoner reasoner = this.getActualReasoner(cfg, null, reasonerConfiguration);
        ValueCreationResult result = reasoner == null ? ReasonerHelper.createValue(cfg, var, type, reasonerConfiguration, observer) : reasoner.createValue(cfg, var, type, reasonerConfiguration, observer);
        return result;
    }

    private class DefaultReasonerProvider
    implements DefaultReasonerAccess.IDefaultReasonerProvider {
        private DefaultReasonerProvider() {
        }

        public boolean hasCapability(IReasonerCapability capability) {
            return ReasonerFrontend.this.hasReasonerCapability(capability);
        }

        public void initialize(Configuration config, ProgressObserver observer) {
            ReasonerFrontend.this.propagate(config, null, observer);
        }
    }
}

