/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.frontend;

import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.reasoning.core.frontend.IReasonerListener;
import net.ssehub.easy.reasoning.core.frontend.ReasonerFrontend;
import net.ssehub.easy.reasoning.core.reasoner.Message;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningOperation;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.model.Project;

public class ReasoningProcess
implements Runnable {
    private static final boolean LOG_RESULT = false;
    private ReasoningOperation desiredOperation;
    private ReasoningResult result;
    private Project project;
    private Configuration config;
    private ReasonerConfiguration reasonerConfig;
    private IReasonerListener listener;
    private ProgressObserver observer;

    public ReasoningProcess(ReasoningOperation desiredOperation, Configuration config, ReasonerConfiguration reasonerConfig, IReasonerListener listener, ProgressObserver observer) {
        this.desiredOperation = desiredOperation;
        this.project = config.getProject();
        this.config = config;
        this.reasonerConfig = reasonerConfig;
        this.listener = listener;
        this.observer = observer;
    }

    public ReasoningProcess(Project project, ReasonerConfiguration reasonerConfig, IReasonerListener listener, ProgressObserver observer) {
        this.desiredOperation = ReasoningOperation.CONSITENCY_CHECK;
        this.project = project;
        this.config = null;
        this.reasonerConfig = reasonerConfig;
        this.listener = listener;
        this.observer = observer;
    }

    @Override
    public void run() {
        ReasonerFrontend reasoner = ReasonerFrontend.getInstance();
        if (reasoner == null) {
            this.setErrorResult("No reasoner found.");
        } else if (this.project == null) {
            this.setErrorResult("No project specified for reasoning");
        } else {
            try {
                switch (this.desiredOperation) {
                    case CONSITENCY_CHECK: {
                        this.result = reasoner.isConsistent(this.project, this.reasonerConfig, this.observer);
                        this.logResult();
                        break;
                    }
                    case VALIDATION: {
                        if (this.config == null) {
                            this.setErrorResult("No configuration specified for reasoning");
                        }
                        this.result = reasoner.check(this.config, this.reasonerConfig, this.observer);
                        this.logResult();
                        break;
                    }
                    case PROPAGATION: {
                        if (this.config == null) {
                            this.setErrorResult("No configuration specified for reasoning");
                        }
                        this.result = reasoner.propagate(this.config, this.reasonerConfig, this.observer);
                        this.logResult();
                        break;
                    }
                    default: {
                        this.result = new ReasoningResult();
                        Message msg = new Message("Nothing done.", null, Status.WARNING);
                        this.result.addMessage(msg);
                        break;
                    }
                }
            }
            catch (Exception e) {
                StringBuffer errorMsg = new StringBuffer("Not expected exception caught:\n");
                errorMsg.append(e.getMessage());
                this.setErrorResult(errorMsg.toString());
                e.printStackTrace();
            }
        }
        if (this.listener != null) {
            this.listener.reasoningFinished(this.result);
        }
    }

    private void logResult() {
    }

    public ReasoningResult getReasoningResult() {
        return this.result;
    }

    private void setErrorResult(String errorMsg) {
        this.result = new ReasoningResult();
        Message msg = new Message(errorMsg, null, Status.ERROR);
        this.result.addMessage(msg);
    }
}

