/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.reasoner;

import java.io.StringWriter;
import java.io.Writer;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.management.CommentResource;
import net.ssehub.easy.varModel.management.ModelCommentsPersistencer;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.datatypes.Operation;
import net.ssehub.easy.varModel.persistency.IVMLWriter;

public class CommentResourceVisitor
extends IVMLWriter {
    private CommentResource comments;

    private CommentResourceVisitor(Writer out, CommentResource comments) {
        super(out);
        this.setWriter(out);
        this.comments = comments;
    }

    public static String visit(IModelElement elt, CommentResource comments) {
        StringWriter out = new StringWriter();
        elt.accept((IModelVisitor)new CommentResourceVisitor(out, comments));
        return out.toString();
    }

    protected void appendOCLFeatureCall(OCLFeatureCall call, Operation.FormattingHint hint) {
        String closing;
        Object key = call.getOperation();
        if ("[]".equals(key)) {
            key = (String)key + "[";
            closing = "]";
        } else {
            key = (String)key + "(";
            closing = ")";
        }
        int i = 0;
        while (i <= call.getParameterCount()) {
            if (i > 0) {
                key = (String)key + ",";
            }
            key = (String)key + ".";
            ++i;
        }
        if (this.getComment((String)(key = (String)key + closing)) != null) {
            String[] args = new String[call.getParameterCount() + 1];
            int pos = 0;
            Writer old = this.getWriter();
            StringWriter tmp = new StringWriter();
            this.setWriter(tmp);
            call.getOperand().accept((IConstraintTreeVisitor)this);
            args[pos++] = tmp.toString();
            int i2 = 0;
            while (i2 < call.getParameterCount()) {
                tmp = new StringWriter();
                this.setWriter(tmp);
                call.getParameter(i2).accept((IConstraintTreeVisitor)this);
                args[pos++] = tmp.toString();
                ++i2;
            }
            this.setWriter(old);
            this.appendComment((String)key, args);
        } else {
            super.appendOCLFeatureCall(call, hint);
        }
    }

    public void visitConstraint(Constraint constraint) {
        if (!this.appendComment(ModelCommentsPersistencer.getKey((Constraint)constraint), null)) {
            Writer old = this.getWriter();
            StringWriter tmp = new StringWriter();
            this.setWriter(tmp);
            constraint.getConsSyntax().accept((IConstraintTreeVisitor)this);
            this.setWriter(old);
            String tmpStr = tmp.toString();
            if (tmpStr.length() == 0) {
                super.visitConstraint(constraint);
            } else {
                this.appendOutput(tmpStr);
            }
        }
    }

    public void visitVariable(Variable variable) {
        AbstractVariable var = variable.getVariable();
        if (!this.appendComment(var.getQualifiedName(), null)) {
            super.visitVariable(variable);
        }
    }

    private String getComment(String key) {
        String result = null;
        if (key != null && this.comments != null) {
            result = this.comments.get(key);
        }
        return result;
    }

    private boolean appendComment(String key, String[] args) {
        boolean done = false;
        String comment = this.getComment(key);
        if (comment != null) {
            if (args != null) {
                int i = 0;
                while (i < args.length) {
                    comment = comment.replace("{" + i + "}", args[i]);
                    ++i;
                }
            }
            this.appendOutput(comment);
            done = true;
        }
        return done;
    }

    public void visitCompoundAccess(CompoundAccess access) {
        IVMLWriter bypassWriter = IVMLWriter.getInstance((Writer)new StringWriter());
        access.accept((IConstraintTreeVisitor)bypassWriter);
        String key = bypassWriter.getWriter().toString();
        IVMLWriter.releaseInstance((IVMLWriter)bypassWriter);
        if (!this.appendComment(key, null)) {
            super.visitCompoundAccess(access);
        }
    }
}

