/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.loader;

import de.uni_hildesheim.sse.easy.loader.framework.BundleInfo;
import de.uni_hildesheim.sse.easy.loader.framework.BundleRegistry;
import de.uni_hildesheim.sse.easy.loader.framework.Log;
import de.uni_hildesheim.sse.easy.loader.framework.NegatingFilter;
import de.uni_hildesheim.sse.easy.loader.framework.Options;
import de.uni_hildesheim.sse.easy.loader.framework.SimpleManifestNameFilter;
import de.uni_hildesheim.sse.easy.loader.framework.Utils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class AbstractLoader {
    protected static final String TAG_EASY = "EASy-Producer";
    protected static final String EASY_EXCLUSION_PATTERN = ".*\\.uni[-_]hildesheim\\.sse.*";
    protected static final String EASY_INCLUSION_PATTERN = ".*\\.uni[-_]hildesheim\\.sse([^u][^i])*";
    private File base;

    protected AbstractLoader(File base) {
        this.base = base;
    }

    protected static void initializeRegistry() {
        BundleRegistry.addGlobalIgnore("org.eclipse.equinox.ds");
        BundleRegistry.addGlobalIgnore("org.eclipse.equinox.launcher");
        BundleRegistry.addGlobalIgnore("org.eclipse.emf.mwe2.launch");
        BundleRegistry.addGlobalIgnore("org.eclipse.emf.mwe2.lib");
        BundleRegistry.addGlobalIgnore("org.eclipse.emf.mwe.core");
        BundleRegistry.addGlobalIgnore("org.eclipse.emf.mwe.utils");
        BundleRegistry.addGlobalIgnore("org.eclipse.xtext.generator");
        BundleRegistry.addGlobalIgnore("org.eclipse.emf.codegen");
        BundleRegistry.addGlobalIgnore("org.eclipse.emf.codegen.ecore");
        BundleRegistry.addGlobalIgnore("net.ssehub.easy.loader");
    }

    protected void bootstrap(File baseDir, File easyPlugins, File eclipsePlugins) {
        this.simpleBootstrap(easyPlugins, eclipsePlugins);
    }

    protected void simpleBootstrap(File easyPlugins, File eclipsePlugins) {
        if (easyPlugins != null && easyPlugins.exists()) {
            Utils.loadBundles(Utils.findJars(easyPlugins), null, TAG_EASY);
        } else {
            Utils.loadBundles(Utils.findJars(new File(this.base, "plugins")), null, TAG_EASY);
        }
        if (eclipsePlugins != null && eclipsePlugins.exists()) {
            Utils.loadBundles(Utils.findJars(eclipsePlugins), null, null);
        } else {
            Utils.loadBundles(Utils.findJars(new File(this.base, "plugins/eclipse")), null, null);
        }
    }

    protected void genericBootstrap() {
        File eclipsePlugins = new File("W:\\eclipse37\\easy\\Eclipse\\plugins");
        List<File> recentEclipseBundles = Utils.findRecentBundles(eclipsePlugins);
        Utils.loadBundles(recentEclipseBundles, new NegatingFilter(new SimpleManifestNameFilter(EASY_EXCLUSION_PATTERN)), null);
        BundleRegistry.setInstance(new BundleRegistry(BundleRegistry.getInstance()));
        Utils.loadBundles(recentEclipseBundles, new SimpleManifestNameFilter(EASY_INCLUSION_PATTERN), null);
    }

    protected void printDependencies(BundleInfo info, String indent) {
        System.out.println(indent + String.valueOf(info));
        int r = 0;
        while (r < info.getRequiredBundlesCount()) {
            this.printDependencies(info.getRequiredBundle(r), indent + "  ");
            ++r;
        }
    }

    protected static List<BundleInfo> getUiBundles() {
        ArrayList<BundleInfo> ui = new ArrayList<BundleInfo>();
        for (BundleInfo info : BundleRegistry.getInstance().getAllBundles()) {
            String name = info.getName().toLowerCase();
            if (!name.endsWith(".ui") && !name.contains(".ui.")) continue;
            ui.add(info);
        }
        return ui;
    }

    protected void collectBootstrapData(BundleInfo info, List<URL> urls, List<BundleInfo> instantiate, Set<BundleInfo> done, Object tag) {
        if (!done.contains(info)) {
            int r = 0;
            while (r < info.getRequiredBundlesCount()) {
                this.collectBootstrapData(info.getRequiredBundle(r), urls, instantiate, done, tag);
                ++r;
            }
            if (!done.contains(info)) {
                done.add(info);
                this.collectBootstrapData(info, urls, instantiate, tag);
            }
        }
    }

    private void collectBootstrapData(BundleInfo info, List<URL> urls, List<BundleInfo> instantiate, Object tag) {
        File resolved = info.getResolvedJar();
        if (resolved != null) {
            try {
                if (AbstractLoader.alreadyKnownToClassLoader(info)) {
                    info.setClassloader(this.getClass().getClassLoader());
                } else {
                    URL url = resolved.toURI().toURL();
                    urls.add(url);
                    this.notifyMapping(url, info);
                    this.handleBundleClasspath(info, urls);
                    if (AbstractLoader.considerForBootstrap(info, tag)) {
                        instantiate.add(info);
                    }
                }
            }
            catch (MalformedURLException e) {
                Log.error("cannot determine URL: " + e.getMessage());
            }
        }
    }

    protected void notifyMapping(URL url, BundleInfo info) {
    }

    private static boolean alreadyKnownToClassLoader(BundleInfo info) {
        return AbstractLoader.alreadyKnownToClassLoader(info.getSampleClass());
    }

    private static boolean alreadyKnownToClassLoader(String sampleClass) {
        boolean result = false;
        if (Options.considerLoadedClasses() && sampleClass != null) {
            try {
                Class.forName(sampleClass);
                result = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return result;
    }

    private static boolean alreadyKnownToClassLoader(File file) {
        boolean result = false;
        if (Options.considerLoadedClasses()) {
            JarFile libJar = null;
            try {
                libJar = new JarFile(file);
                String sampleClass = BundleInfo.getSampleClass(libJar);
                libJar.close();
                result = AbstractLoader.alreadyKnownToClassLoader(sampleClass);
            }
            catch (IOException e) {
                Utils.closeQuietly(libJar);
            }
        }
        return result;
    }

    private void handleBundleClasspath(BundleInfo info, List<URL> urls) throws MalformedURLException {
        if (info.getClasspathEntryCount() > 0) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(info.getResolvedJar());
                int c = 0;
                while (c < info.getClasspathEntryCount()) {
                    String cp = info.getClasspathEntry(c);
                    JarEntry entry = jarFile.getJarEntry(cp);
                    if (entry != null && entry.getName().endsWith(".jar")) {
                        String libName = entry.getName();
                        File file = Utils.createTempFile(libName);
                        file.deleteOnExit();
                        Utils.jarEntryToFile(jarFile, entry, file);
                        if (!AbstractLoader.alreadyKnownToClassLoader(file)) {
                            urls.add(file.toURI().toURL());
                        }
                    } else {
                        Log.warn("cannot expand jar entry " + cp + " for class loading: ");
                    }
                    ++c;
                }
                jarFile.close();
            }
            catch (IOException e) {
                Utils.closeQuietly(jarFile);
                Log.warn("cannot expand jar file for class loading: ", e);
            }
        }
    }

    private static boolean considerForBootstrap(BundleInfo info, Object tag) {
        boolean result = false;
        if (!(info.getActivatorClassName() == null && info.getDsClassesCount() <= 0 || tag != null && !tag.equals(info.getTag()))) {
            result = true;
        }
        return result;
    }

    protected boolean irrelevantInJar(String name) {
        boolean irrelevant = name.startsWith("META-INF") || name.startsWith("OSGI-INF");
        irrelevant |= name.startsWith("about_file") || name.startsWith("about.");
        irrelevant |= name.startsWith(".api_description");
        irrelevant |= name.equals("plugin.properties") || name.equals(".options");
        irrelevant |= name.equals("javadoc.zip") || name.equals("src.zip");
        irrelevant |= name.endsWith(".html") || name.endsWith(".png");
        irrelevant |= name.endsWith("plugin.xml");
        return irrelevant |= name.endsWith("package-info.class");
    }

    protected File getBase() {
        return this.base;
    }
}

