/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.loader;

import de.uni_hildesheim.sse.easy.loader.AbstractLoader;
import de.uni_hildesheim.sse.easy.loader.framework.BundleInfo;
import de.uni_hildesheim.sse.easy.loader.framework.BundleRegistry;
import de.uni_hildesheim.sse.easy.loader.framework.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Analyzer
extends AbstractLoader {
    static {
        Analyzer.initializeRegistry();
    }

    public Analyzer() {
        this(new File("."));
    }

    public Analyzer(File base) {
        super(base);
    }

    public static void main(String[] args) {
        Analyzer analyzer = new Analyzer();
        analyzer.analyze();
    }

    public void analyze() {
        this.bootstrap(null, null, null);
        List<BundleInfo> allBundles = BundleRegistry.getInstance().getAllBundles();
        if (allBundles.isEmpty()) {
            System.out.println("No Bundles loaded. Cannot continue.");
        } else {
            String indent = "  ";
            String cannotContinue = "Cannot continue.";
            System.out.println("All dependencies:");
            List<BundleInfo> roots = BundleRegistry.getInstance().getRootBundles();
            for (BundleInfo info : roots) {
                this.printDependencies(info, "");
            }
            List<BundleInfo> uiBundles = Analyzer.getUiBundles();
            if (!uiBundles.isEmpty()) {
                System.out.println("\nWARNING: possible UI plugins detected");
                this.print(uiBundles, "  ");
            }
            boolean fail = this.printBundles(BundleRegistry.getInstance().getUnresolvedBundles(), "  ", "\nunresolved bundles", "Missing bundles.Cannot continue.", false);
            List<String> paths = Utils.analyzeForCyclicDependencies(allBundles);
            if (!paths.isEmpty()) {
                System.out.println("\ncyclic dependencies:");
                this.print(paths, "  ");
                fail = true;
            }
            if (!(fail |= this.printBundles(roots, "  ", "\nroot bundles:", "No root bundles. Cannot continue.", true))) {
                this.printDuplicateFiles(allBundles);
            }
        }
    }

    protected boolean printDuplicateFiles(List<BundleInfo> infos) {
        HashMap<String, BundleInfo> names = new HashMap<String, BundleInfo>();
        boolean found = false;
        for (BundleInfo info : infos) {
            File file = info.getResolvedJar();
            if (file == null) continue;
            found = this.analyzeJarForDuplicates(info, names);
        }
        return found;
    }

    private boolean analyzeJarForDuplicates(BundleInfo info, Map<String, BundleInfo> names) {
        boolean found = false;
        JarFile jar = null;
        try {
            jar = new JarFile(info.getResolvedJar());
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                String name;
                JarEntry entry = e.nextElement();
                if (entry.isDirectory() || this.irrelevantInJar(name = entry.getName())) continue;
                BundleInfo known = names.get(name);
                if (known != null) {
                    found = true;
                    System.out.println("duplicate entry: " + name + " in " + known.getName() + " and " + info.getName());
                    continue;
                }
                names.put(name, info);
            }
            jar.close();
        }
        catch (IOException e) {
            Utils.closeQuietly(jar);
        }
        return found;
    }

    private boolean printBundles(List<BundleInfo> infos, String indent, String headline, String stopMessage, boolean negate) {
        boolean fail;
        boolean bl = fail = !infos.isEmpty();
        if (negate) {
            boolean bl2 = fail = !fail;
        }
        if (fail) {
            System.out.println(headline);
            this.print(infos, indent);
            if (stopMessage != null) {
                System.out.println(stopMessage);
            }
        }
        return fail;
    }

    private void print(List<?> data, String indent) {
        for (Object d : data) {
            System.out.println(indent + String.valueOf(d));
        }
    }
}

