/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.loader;

import de.uni_hildesheim.sse.easy.loader.AbstractLoader;
import de.uni_hildesheim.sse.easy.loader.IExclusionSelector;
import de.uni_hildesheim.sse.easy.loader.ILoader;
import de.uni_hildesheim.sse.easy.loader.InitType;
import de.uni_hildesheim.sse.easy.loader.ListLoader;
import de.uni_hildesheim.sse.easy.loader.NullLoader;
import de.uni_hildesheim.sse.easy.loader.StartupInfo;
import de.uni_hildesheim.sse.easy.loader.framework.BundleException;
import de.uni_hildesheim.sse.easy.loader.framework.BundleInfo;
import de.uni_hildesheim.sse.easy.loader.framework.BundleRegistry;
import de.uni_hildesheim.sse.easy.loader.framework.EasyDependency;
import de.uni_hildesheim.sse.easy.loader.framework.FakeBundle;
import de.uni_hildesheim.sse.easy.loader.framework.FakeBundleContext;
import de.uni_hildesheim.sse.easy.loader.framework.FakeComponentContext;
import de.uni_hildesheim.sse.easy.loader.framework.Feature;
import de.uni_hildesheim.sse.easy.loader.framework.LoaderLog;
import de.uni_hildesheim.sse.easy.loader.framework.Log;
import de.uni_hildesheim.sse.easy.loader.framework.Options;
import de.uni_hildesheim.sse.easy.loader.framework.Utils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;

public class Generator
extends AbstractLoader {
    private static final Class<?>[] RUNTIME_CLASSES;
    private static IExclusionSelector exclusionSelector;
    private static boolean verbose;
    private List<BundleInfo> data;
    private List<URL> urls;
    private Map<URL, BundleInfo> urlBundleMapping = new HashMap<URL, BundleInfo>();
    private List<BundleInfo> checkedBundles;
    private List<String> checkedClasspaths = new ArrayList<String>();
    private String eclipseURIPath;
    private File binFolder;
    private File libsFolder;

    static {
        verbose = true;
        Options.setConsiderLoadedClasses(false);
        Generator.initializeRegistry();
        ArrayList rtCls = new ArrayList();
        Generator.addRuntimeClass(ILoader.class, rtCls);
        Generator.addRuntimeClass(NullLoader.class, rtCls);
        Generator.addRuntimeClass(ListLoader.class, rtCls);
        Generator.addRuntimeClass(InitType.class, rtCls);
        Generator.addRuntimeClass(StartupInfo.class, rtCls);
        Generator.addRuntimeClass(Log.class, rtCls);
        Generator.addRuntimeClass(Utils.class, rtCls);
        Generator.addRuntimeClass(BundleException.class, rtCls);
        Generator.addRuntimeClass(FakeBundle.class, rtCls);
        Generator.addRuntimeClass(FakeBundleContext.class, rtCls);
        Generator.addRuntimeClass(FakeComponentContext.class, rtCls);
        Class[] tmp = new Class[rtCls.size()];
        rtCls.toArray(tmp);
        RUNTIME_CLASSES = tmp;
    }

    protected Generator(File base, File pluginPath, File eclipsePath, File binFolder, File libsFolder) {
        super(base);
        LoaderLog.writeLn("Base dir is: " + base.getAbsolutePath());
        try {
            this.eclipseURIPath = eclipsePath.toURI().toURL().toURI().getPath();
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        this.binFolder = binFolder;
        this.libsFolder = libsFolder;
        System.out.println("EASy Plugins: " + pluginPath.getAbsolutePath());
        this.bootstrap(base, pluginPath, eclipsePath);
        List<BundleInfo> roots = BundleRegistry.getInstance().getRootBundles();
        this.urls = new ArrayList<URL>();
        this.data = new ArrayList<BundleInfo>();
        HashSet<BundleInfo> done = new HashSet<BundleInfo>();
        for (BundleInfo info : roots) {
            this.collectBootstrapData(info, this.urls, this.data, done, "EASy-Producer");
        }
        File libsDir = new File(base, "libs");
        File[] libs = libsDir.listFiles();
        if (libs != null) {
            File[] fileArray = libs;
            int n = libs.length;
            int n2 = 0;
            while (n2 < n) {
                File lib = fileArray[n2];
                try {
                    this.urls.add(lib.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    LoaderLog.warn("malformed URL", e);
                }
                ++n2;
            }
        }
    }

    private boolean isEclipseBundle(URL bundleURL) {
        boolean result = false;
        String path = bundleURL.getPath();
        result = path.startsWith(this.eclipseURIPath) || path.contains("/eclipse/") || path.contains("/libs/");
        return result;
    }

    public static void setExclusionSelector(IExclusionSelector selector) {
        exclusionSelector = selector;
    }

    public static List<File> getFeatureFilesFromDir(File file) {
        ArrayList<File> files = new ArrayList<File>();
        File[] sub = file.listFiles();
        if (sub != null) {
            File[] fileArray = sub;
            int n = sub.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                if (subFile.isDirectory()) {
                    files.addAll(Generator.getFeatureFilesFromDir(subFile));
                } else if (subFile.isFile() && subFile.getName().equalsIgnoreCase("feature.xml")) {
                    files.add(subFile);
                }
                ++n2;
            }
        }
        return files;
    }

    public static List<Feature> filesToFeature(List<File> files) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        int i = 0;
        while (i < files.size()) {
            Feature feat = new Feature(files.get(i));
            features.add(feat);
            ++i;
        }
        return features;
    }

    public static Feature getFeatureFromListByName(List<Feature> features, String name) {
        Feature found = null;
        int i = 0;
        while (i < features.size()) {
            if (features.get(i).getId().equals(name)) {
                found = features.get(i);
                i = features.size();
            }
            ++i;
        }
        return found;
    }

    public static List<BundleInfo> autoGenerate(List<File> mainFeature, List<File> allFeatures, boolean forceBuild, String pluginPath, String eclipsePath, String targetDir, String baseDir, String binFolder, String libsFolder) {
        ArrayList<BundleInfo> bundles = new ArrayList();
        ArrayList<File> mainFeatFiles = new ArrayList<File>();
        ArrayList<File> allFeatureFiles = new ArrayList<File>();
        for (File file : mainFeature) {
            mainFeatFiles.addAll(Generator.getFeatureFilesFromDir(file));
        }
        List<Feature> mainFeat = Generator.filesToFeature(mainFeatFiles);
        for (File file : allFeatures) {
            allFeatureFiles.addAll(Generator.getFeatureFilesFromDir(file));
        }
        List<Feature> allFeat = Generator.filesToFeature(allFeatureFiles);
        Generator.deleteFolder(new File(targetDir), false);
        Utils.setTempDir(new File(targetDir, "temp"));
        bundles = Generator.generate(mainFeat, allFeat, forceBuild, pluginPath, eclipsePath, targetDir, baseDir, binFolder, libsFolder);
        return bundles;
    }

    private static void deleteFolder(File folder, boolean deleteFolder) {
        File[] files = folder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    Generator.deleteFolder(f, true);
                } else {
                    f.delete();
                }
                ++n2;
            }
        }
        if (deleteFolder) {
            folder.delete();
        }
    }

    public static List<BundleInfo> generate(List<Feature> features, List<Feature> additionalFeatures, boolean forceBuild, String pluginPath, String eclipsePath, String target, String baseDir, String binFolder, String libsFolder) {
        LoaderLog.init(target + "/LoaderLog.txt");
        Generator gen = new Generator(new File(baseDir), new File(pluginPath), new File(eclipsePath), new File(binFolder), new File(libsFolder));
        LoaderLog.writeLn(gen.eclipseURIPath);
        File targetDir = target != null ? new File(target) : new File("newGenerator");
        boolean failed = false;
        gen.checkedClasspaths = new ArrayList<String>();
        LoaderLog.writeLn("Generating...");
        LoaderLog.writeLn("ForceBuild = " + forceBuild);
        LoaderLog.line();
        List<BundleInfo> bundles = Generator.unnamed(gen, features, additionalFeatures, forceBuild);
        if (!failed) {
            gen.generateJarFiles(new File(targetDir, "unbundled"), true);
            gen.generateJarFiles(new File(targetDir, "bundled"), false);
        } else {
            System.out.println("BUILD FAILED! Please consider a forced build.");
            LoaderLog.writeLn("BUILD FAILED!");
        }
        LoaderLog.close();
        return bundles;
    }

    private static List<BundleInfo> unnamed(Generator gen, List<Feature> features, List<Feature> additionalFeatures, boolean forceBuild) {
        ArrayList<BundleInfo> bundles = new ArrayList<BundleInfo>();
        Map<Object, Object> dependencies = new HashMap();
        dependencies = Generator.collectDependencies(features, additionalFeatures);
        Object[] keys = dependencies.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            Object bundle = BundleRegistry.getInstance().get(((EasyDependency)dependencies.get(keys[i])).getBundleSymbolicName(), (EasyDependency)dependencies.get(keys[i]));
            if (bundle != null) {
                LoaderLog.writeLn("Looking for Bundle: " + ((BundleInfo)bundle).getName());
            }
            if (bundle != null && !bundles.contains(bundle)) {
                bundles.add((BundleInfo)bundle);
                LoaderLog.writeLn("Adding Bundle: " + ((BundleInfo)bundle).getName(), 4);
            } else if (!bundles.contains(bundle)) {
                String error = "ERROR - missing BundleInfo for the following Plugin: " + ((EasyDependency)dependencies.get(keys[i])).getBundleSymbolicName() + " [" + String.valueOf(((EasyDependency)dependencies.get(keys[i])).getBundleVersionMin());
                if (((EasyDependency)dependencies.get(keys[i])).getBundleVersionMax() != null) {
                    error = error + ";" + String.valueOf(((EasyDependency)dependencies.get(keys[i])).getBundleVersionMax());
                }
                error = error + "]";
                LoaderLog.writeLn(error, 8);
                if (forceBuild) {
                    ((EasyDependency)dependencies.get(keys[i])).setBundleVersionMin(null);
                    ((EasyDependency)dependencies.get(keys[i])).setBundleVersionMax(null);
                    bundle = BundleRegistry.getInstance().get(((EasyDependency)dependencies.get(keys[i])).getBundleSymbolicName(), (EasyDependency)dependencies.get(keys[i]));
                    if (bundle != null) {
                        bundles.add((BundleInfo)bundle);
                        LoaderLog.writeLn("    Plugin compensated with: " + ((BundleInfo)bundle).getName() + " " + String.valueOf(((BundleInfo)bundle).getVersion()), 8);
                    }
                }
            }
            ++i;
        }
        LoaderLog.line();
        Generator.subGenerate(bundles);
        for (BundleInfo test : bundles) {
            LoaderLog.writeLn(test.getName() + " " + String.valueOf(test.getVersion()));
            int i2 = 0;
            while (i2 < test.getClasspathEntryCount()) {
                gen.checkedClasspaths.add(test.getClasspathEntry(i2));
                LoaderLog.writeLn("wants " + test.getClasspathEntry(i2), 4);
                ++i2;
            }
            LoaderLog.skipLine();
        }
        LoaderLog.line();
        ArrayList<String> solved = new ArrayList<String>();
        for (String path : gen.checkedClasspaths) {
            boolean doubled = false;
            for (BundleInfo test : bundles) {
                if (!path.contains(test.getName())) continue;
                doubled = true;
            }
            if (solved.contains(path) || doubled) continue;
            solved.add(path);
        }
        gen.checkedClasspaths = solved;
        gen.checkedBundles = new ArrayList<BundleInfo>();
        gen.checkedBundles = bundles;
        LoaderLog.skipLine();
        return bundles;
    }

    private static void subGenerate(List<BundleInfo> bundles) {
        boolean changed = false;
        int i = 0;
        while (i < bundles.size()) {
            LoaderLog.writeLn("Subgenerating for: " + bundles.get(i).getName() + " " + String.valueOf(bundles.get(i).getVersion()));
            int k = 0;
            while (k < bundles.get(i).getRequiredBundlesCount()) {
                boolean found = false;
                BundleInfo toAdd = null;
                LoaderLog.writeLn("Requires Bundle: " + bundles.get(i).getRequiredBundle(k).getName(), 4);
                for (BundleInfo check : bundles) {
                    BundleInfo nB;
                    if (!check.getName().equalsIgnoreCase(bundles.get(i).getRequiredBundle(k).getName())) continue;
                    found = true;
                    if (bundles.get(i).getRequiredBundle(k).getVersion() == null || check.getVersion() == null || check.getVersion().compareTo(bundles.get(i).getRequiredBundle(k).getVersion()) != -1) continue;
                    bundles.remove(check);
                    EasyDependency vs = new EasyDependency();
                    vs.setBundleVersionMin(bundles.get(i).getRequiredBundle(k).getVersion());
                    toAdd = nB = BundleRegistry.getInstance().get(bundles.get(i).getRequiredBundle(k).getName(), vs);
                }
                if (!found) {
                    BundleInfo nB;
                    toAdd = nB = BundleRegistry.getInstance().get(bundles.get(i).getRequiredBundle(k).getName(), new EasyDependency());
                    LoaderLog.writeLn("Not found. Trying to compensate...", 8);
                }
                if (toAdd != null) {
                    bundles.add(toAdd);
                    LoaderLog.writeLn("Added: " + toAdd.getName() + " " + String.valueOf(bundles.get(i).getVersion()), 8);
                    changed = true;
                } else if (!found) {
                    LoaderLog.writeLn("MISSING " + bundles.get(i).getRequiredBundle(k).getName(), 8);
                }
                ++k;
            }
            LoaderLog.skipLine();
            ++i;
        }
        if (changed) {
            Generator.subGenerate(bundles);
        }
        LoaderLog.line();
    }

    private static List<Feature> collectFeatures(List<Feature> features, List<Feature> additionalFeatures) {
        List<Feature> result = features;
        int i = 0;
        while (i < features.size()) {
            String featureName = features.get(i).getId();
            LoaderLog.writeLn("Collecting features for: " + featureName);
            int j = 0;
            while (j < features.get(i).getRequirements().size()) {
                String symbolicName = features.get(i).getRequirements().get(j).getBundleSymbolicName();
                Feature feat = Generator.getFeatureFromListByName(additionalFeatures, symbolicName);
                if (feat != null) {
                    if (!result.contains(feat)) {
                        result.add(feat);
                        LoaderLog.writeLn("Found Feature: " + feat.getId(), 4);
                    }
                    ArrayList<Feature> newFeat = new ArrayList<Feature>();
                    ArrayList<Feature> result2 = new ArrayList<Feature>();
                    newFeat.add(feat);
                    result2.addAll(Generator.collectFeatures(newFeat, additionalFeatures));
                    int k = 0;
                    while (k < result2.size()) {
                        if (!result.contains(result2.get(k))) {
                            result.add((Feature)result2.get(k));
                        }
                        ++k;
                    }
                } else {
                    LoaderLog.writeLn("Error: cannot find required feature with symbolic name '" + symbolicName + "'  for feature '" + featureName + "'");
                }
                ++j;
            }
            ++i;
        }
        LoaderLog.line();
        return result;
    }

    private static Map<String, EasyDependency> collectDependencies(List<Feature> features, List<Feature> additionalFeatures) {
        HashMap<String, EasyDependency> dependencies = new HashMap<String, EasyDependency>();
        List<Feature> allFeatures = Generator.collectFeatures(features, additionalFeatures);
        int i = 0;
        while (i < allFeatures.size()) {
            Map<String, EasyDependency> featureDependencies = allFeatures.get(i).getDependencies();
            Object[] keys = featureDependencies.keySet().toArray();
            LoaderLog.writeLn("Collecting dependencies for: " + allFeatures.get(i).getId());
            int j = 0;
            while (j < keys.length) {
                if (dependencies.containsKey(keys[j])) {
                    LoaderLog.writeLn("Already exists: " + ((EasyDependency)dependencies.get(keys[j])).getBundleSymbolicName(), 4);
                    ((EasyDependency)dependencies.get(keys[j])).mergeVersions(featureDependencies.get(keys[j]));
                    LoaderLog.writeLn("Merged into: " + ((EasyDependency)dependencies.get(keys[j])).getBundleSymbolicName(), 4);
                } else {
                    dependencies.put((String)keys[j], featureDependencies.get(keys[j]));
                    LoaderLog.writeLn("New dependency: " + featureDependencies.get(keys[j]).getBundleSymbolicName(), 4);
                }
                ++j;
            }
            ++i;
        }
        LoaderLog.line();
        return dependencies;
    }

    private static void addRuntimeClass(Class<?> cls, List<Class<?>> rtClasses) {
        rtClasses.add(cls);
        Class<?>[] inner = cls.getDeclaredClasses();
        if (inner != null) {
            Class<?>[] classArray = inner;
            int n = inner.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> innerCls = classArray[n2];
                rtClasses.add(innerCls);
                ++n2;
            }
        }
    }

    public static void main(String[] args) {
        File base = new File(".");
        Generator generator = new Generator(base, null, null, new File(base, "bin"), new File(base, "libs"));
        generator.generateJarFiles(new File(base, "dist"), true);
        generator.generateJarFiles(new File(base, "dist-unbundled"), false);
    }

    protected void generateJarFiles(File targetDir, boolean bundle) {
        ArrayList<BundleInfo> backup = new ArrayList<BundleInfo>();
        UnbundleInfo unbundle = bundle ? new UnbundleInfo() : new UnbundleInfo(targetDir);
        targetDir.mkdirs();
        LoaderLog.writeLn("generating Jar files into " + targetDir.getAbsolutePath());
        File easyJarFile = new File(targetDir, "easy-headless.jar");
        File eclipseJarFile = new File(targetDir, "eclipse-part.jar");
        ArrayList<URL> deferList = new ArrayList<URL>();
        JarOutputStream easyJar = null;
        JarOutputStream eclipseJar = null;
        try {
            easyJar = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(easyJarFile)));
            eclipseJar = unbundle.enabled() ? null : new JarOutputStream(new BufferedOutputStream(new FileOutputStream(eclipseJarFile)));
            URLProcessor processor = new URLProcessor(unbundle, easyJar, eclipseJar);
            for (URL url : this.urls) {
                boolean partOfBM;
                String sUrl;
                boolean classpath = false;
                for (String classP : this.checkedClasspaths) {
                    sUrl = url.toString();
                    String cP = classP;
                    if (cP == null || cP.isEmpty() || !sUrl.contains(cP)) continue;
                    classpath = true;
                }
                boolean fitsConditions = false;
                boolean bl = partOfBM = this.checkedBundles.contains(this.urlBundleMapping.get(url)) && this.urlBundleMapping.get(url) != null;
                if (this.checkedBundles == null || partOfBM || url.toString().contains("org.eclipse.osgi") || url.toString().contains("javax.inject")) {
                    fitsConditions = true;
                }
                if (!classpath && !fitsConditions) continue;
                backup.add(this.urlBundleMapping.get(url));
                sUrl = url.toString();
                LoaderLog.writeLn("Processing URL: " + sUrl);
                if (this.checkedBundles != null) {
                    this.checkedBundles.remove(this.urlBundleMapping.get(url));
                }
                if (!processor.processURL(url, true)) continue;
                deferList.add(url);
            }
            if (this.checkedBundles != null) {
                this.checkedBundles.addAll(backup);
            }
            for (URL url : deferList) {
                processor.processURL(url, false);
            }
            Utils.closeQuietly(eclipseJar);
            LoaderLog.writeLn("adding startup spec to " + easyJarFile.getAbsolutePath());
            LoaderLog.line();
            this.produceStartupList(easyJar);
            LoaderLog.writeLn("adding loader classes to " + easyJarFile.getAbsolutePath());
            this.addRuntimeLoaderClasses(easyJar);
            easyJar.close();
        }
        catch (IOException e) {
            LoaderLog.warn("I/O problem while generating Jars", e);
            Utils.closeQuietly(easyJar);
            Utils.closeQuietly(eclipseJar);
        }
        LoaderLog.line();
    }

    private void handleJar(InputStream is, JarOutputStream os, Set<String> done, Set<String> exclude, UnbundleInfo unbundle) throws IOException {
        boolean include = false;
        boolean copy = unbundle.enabled() ? unbundle.isEclipsePart() || !unbundle.isBundle() : false;
        if (include) {
            try {
                this.logEntryName(unbundle.getName());
                JarEntry osEntry = new JarEntry(unbundle.getName());
                os.putNextEntry(osEntry);
                Utils.copy(is, os);
                os.closeEntry();
            }
            catch (IOException e) {
                this.handleJarWritingException(unbundle.getName(), e, null);
            }
        } else if (copy) {
            FileOutputStream fos = new FileOutputStream(unbundle.getTarget());
            Utils.copy(is, fos);
            fos.close();
        } else {
            JarEntry isEntry = null;
            JarInputStream jis = new JarInputStream(is);
            do {
                String name;
                String key;
                if ((isEntry = jis.getNextJarEntry()) == null || done.contains(key = (name = isEntry.getName()).toLowerCase()) || this.irrelevantInJar(name) || exclude.contains(name) || unbundle.excludeFromJar(name)) continue;
                this.logEntryName(name);
                done.add(key);
                try {
                    JarEntry osEntry = new JarEntry(name);
                    os.putNextEntry(osEntry);
                    Utils.copy(jis, os);
                    os.closeEntry();
                }
                catch (IOException e) {
                    this.handleJarWritingException(name, e, null);
                }
            } while (isEntry != null);
        }
    }

    private void produceStartupList(JarOutputStream os) throws IOException {
        ArrayList<BundleInfo> processed = new ArrayList<BundleInfo>();
        ArrayList<String> processedDS = new ArrayList<String>();
        JarEntry listEntry = new JarEntry(".easyStartup");
        os.putNextEntry(listEntry);
        PrintWriter out = new PrintWriter(new OutputStreamWriter(os));
        LoaderLog.writeLn("Producing Startup List");
        LoaderLog.skipLine();
        for (BundleInfo info : Utils.sortByContainment(this.checkedBundles)) {
            int i;
            if (info != null && info.getActivatorClassName() != null) {
                if (this.checkedBundles != null) {
                    i = 0;
                    while (i < this.checkedBundles.size()) {
                        boolean inChecked = false;
                        if (this.checkedBundles.get(i) != null && info.getActivatorClassName() != null && this.checkedBundles.get(i).getActivatorClassName() != null) {
                            boolean bl = inChecked = this.checkedBundles.get(i).getActivatorClassName() != null && info.getActivatorClassName().contains(this.checkedBundles.get(i).getActivatorClassName());
                        }
                        if (this.checkedBundles.get(i) != null && !info.getActivatorClassName().contains("eclipse") && !processed.contains(this.checkedBundles.get(i)) && inChecked) {
                            out.print(InitType.ACTIVATOR.name());
                            out.print(":");
                            out.println(info.getActivatorClassName());
                            processed.add(this.checkedBundles.get(i));
                        }
                        ++i;
                    }
                } else {
                    out.print(InitType.ACTIVATOR.name());
                    out.print(":");
                    out.println(info.getActivatorClassName());
                }
            }
            i = 0;
            while (i < this.checkedBundles.size()) {
                if (info != null && this.checkedBundles.get(i) != null) {
                    int j = 0;
                    while (j < this.checkedBundles.get(i).getDsClassesCount()) {
                        int c = 0;
                        while (c < info.getDsClassesCount()) {
                            if (!processedDS.contains(info.getDsClass(c)) && info.getDsClass(c).equals(this.checkedBundles.get(i).getDsClass(c))) {
                                out.print(InitType.DS.name());
                                out.print(":");
                                out.println(info.getDsClass(c));
                                processedDS.add(info.getDsClass(c));
                            }
                            ++c;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        out.flush();
        os.closeEntry();
    }

    private void addRuntimeLoaderClasses(JarOutputStream os) throws IOException {
        Class<?>[] classArray = RUNTIME_CLASSES;
        int n = RUNTIME_CLASSES.length;
        int n2 = 0;
        while (n2 < n) {
            block14: {
                Class<?> rtClass = classArray[n2];
                String name = rtClass.getName().replace('.', '/') + ".class";
                this.logEntryName(name);
                if (this.binFolder.exists()) {
                    File file = new File(this.binFolder, name);
                    if (file.exists()) {
                        is = null;
                        try {
                            entry = new JarEntry(name);
                            os.putNextEntry(entry);
                            is = new FileInputStream(file);
                            Utils.copy(is, os);
                            os.closeEntry();
                            Utils.closeQuietly(is);
                        }
                        catch (IOException e) {
                            this.handleJarWritingException(name, e, is);
                        }
                    } else {
                        is = null;
                        try {
                            entry = new JarEntry(name);
                            os.putNextEntry(entry);
                            is = rtClass.getClassLoader().getResourceAsStream(name);
                            if (is != null) {
                                Utils.copy(is, os);
                                os.closeEntry();
                                Utils.closeQuietly(is);
                                break block14;
                            }
                            LoaderLog.error("Class file " + name + " does not exist. Generation incomplete.");
                        }
                        catch (IOException e) {
                            this.handleJarWritingException(name, e, is);
                        }
                    }
                } else {
                    InputStream is = null;
                    try {
                        JarEntry entry = new JarEntry(name);
                        os.putNextEntry(entry);
                        is = rtClass.getClassLoader().getResourceAsStream(name);
                        if (is != null) {
                            Utils.copy(is, os);
                            os.closeEntry();
                            Utils.closeQuietly(is);
                        } else {
                            LoaderLog.error("Class file " + name + " does not exist. Generation incomplete.");
                        }
                    }
                    catch (IOException e) {
                        this.handleJarWritingException(name, e, is);
                    }
                }
            }
            ++n2;
        }
    }

    private void handleJarWritingException(String name, IOException ex, InputStream is) throws IOException {
        Utils.closeQuietly(is);
        if (!ex.getMessage().startsWith("duplicate entry:")) {
            LoaderLog.error("Could not read " + name + " " + ex.getMessage(), ex);
            throw ex;
        }
        LoaderLog.warn("While packaging " + name + " " + ex.getMessage() + " Ignoring.", ex);
    }

    @Override
    protected void notifyMapping(URL url, BundleInfo info) {
        this.urlBundleMapping.put(url, info);
    }

    @Override
    protected boolean irrelevantInJar(String name) {
        boolean irrelevant = name.startsWith("META-INF") && !name.equals("META-INF/MANIFEST.MF") ? false : super.irrelevantInJar(name);
        if (!irrelevant && exclusionSelector != null) {
            irrelevant = exclusionSelector.isExcluded(name);
        }
        return irrelevant;
    }

    private void logEntryName(String name) {
        if (verbose) {
            LoaderLog.info("Handling " + name);
        }
    }

    public static void setVerbose(boolean verb) {
        verbose = verb;
        if (verb) {
            BundleRegistry.getInstance().setEmitIgoredWarnings(true);
        }
    }

    private class URLProcessor {
        private Set<String> classpathEntries = new HashSet<String>();
        private Set<String> done = new HashSet<String>();
        private UnbundleInfo unbundle;
        private JarOutputStream easyJar;
        private JarOutputStream eclipseJar;

        URLProcessor(UnbundleInfo unbundle, JarOutputStream easyJar, JarOutputStream eclipseJar) {
            this.unbundle = unbundle;
            this.easyJar = easyJar;
            this.eclipseJar = eclipseJar;
        }

        boolean processURL(URL url, boolean defer) throws IOException {
            boolean deferred = false;
            String path = url.getPath();
            BundleInfo info = Generator.this.urlBundleMapping.get(url);
            this.classpathEntries.clear();
            this.unbundle.setBundleInfo(info);
            this.unbundle.setEclipsePart(Generator.this.isEclipseBundle(url));
            this.unbundle.setName(url);
            if (defer && this.unbundle.getName().startsWith("ecj-")) {
                deferred = true;
            }
            File slf4jJar = new File(Generator.this.libsFolder, "/slf4j-simple-1.6.4.jar");
            String slf4jKey = slf4jJar.getPath().toLowerCase();
            if (!deferred && info != null) {
                int c = 0;
                while (c < info.getClasspathEntryCount()) {
                    String cpe = info.getClasspathEntry(c);
                    this.classpathEntries.add(cpe);
                    if (cpe.startsWith("lib/slf4j") && !this.done.contains(slf4jKey)) {
                        this.unbundle.setName(slf4jJar.getName());
                        this.unbundle.setBundleInfo(null);
                        FileInputStream is = null;
                        is = new FileInputStream(slf4jJar);
                        Generator.this.handleJar(is, this.easyJar, this.done, new HashSet<String>(), this.unbundle);
                        ((InputStream)is).close();
                    }
                    ++c;
                }
            }
            if (!deferred) {
                InputStream is = url.openStream();
                LoaderLog.writeLn(" - processing " + path);
                if (this.unbundle.isEclipsePart()) {
                    String nbn = this.unbundle.getName();
                    LoaderLog.writeLn(nbn + " is part of eclipse", 4);
                    Generator.this.handleJar(is, this.eclipseJar, this.done, this.classpathEntries, this.unbundle);
                } else {
                    Generator.this.handleJar(is, this.easyJar, this.done, this.classpathEntries, this.unbundle);
                }
                is.close();
            }
            return deferred;
        }
    }

    private class UnbundleInfo {
        private File target;
        private String name;
        private boolean eclipsePart;
        private BundleInfo bundle;
        private Set<String> excludeFromJar;

        UnbundleInfo() {
        }

        UnbundleInfo(File target) {
            this.target = target;
        }

        void setName(String name) {
            this.name = name;
        }

        void setName(URL url) {
            String tmp = url.toString();
            int pos = tmp.lastIndexOf(47);
            this.name = pos > 0 ? tmp.substring(pos + 1) : "tmp.tmp";
        }

        String getName() {
            return this.name;
        }

        void setBundleInfo(BundleInfo bundle) {
            this.bundle = bundle;
            this.excludeFromJar = bundle == null ? null : bundle.excludeFromJar();
        }

        void setEclipsePart(boolean eclipsePart) {
            this.eclipsePart = eclipsePart;
        }

        File getTarget() {
            return new File(this.target, this.name);
        }

        boolean isBundle() {
            return this.bundle != null;
        }

        boolean isEclipsePart() {
            return this.eclipsePart;
        }

        boolean enabled() {
            return this.target != null;
        }

        boolean excludeFromJar(String path) {
            return this.excludeFromJar != null && this.excludeFromJar.contains(path);
        }
    }
}

