/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.loader.framework;

import java.util.logging.Logger;

public class Log {
    private static LoaderLogger logger = new JavaLoaderLogger();

    public static LoaderLogger getLogger() {
        return logger;
    }

    public static void setLogger(LoaderLogger newLogger) {
        if (newLogger != null) {
            logger = newLogger;
        }
    }

    public static void error(String error) {
        logger.error(error);
    }

    public static void error(String error, Exception exception) {
        logger.error(error, exception);
    }

    public static void warn(String warning) {
        logger.warn(warning);
    }

    public static void warn(String warning, Exception exception) {
        logger.warn(warning, exception);
    }

    public static void info(String msg) {
        logger.info(msg);
    }

    private static class JavaLoaderLogger
    implements LoaderLogger {
        private Logger javaLogger = Logger.getLogger("EASyLoader");

        private JavaLoaderLogger() {
        }

        @Override
        public void error(String error) {
            this.javaLogger.severe(error);
        }

        @Override
        public void error(String error, Exception exception) {
            this.javaLogger.severe(error + ": " + exception.getMessage());
        }

        @Override
        public void warn(String warning) {
            this.javaLogger.warning(warning);
        }

        @Override
        public void warn(String warning, Exception exception) {
            this.javaLogger.warning(warning + ": " + exception.getMessage());
        }

        @Override
        public void info(String msg) {
            this.javaLogger.info(msg);
        }
    }

    public static interface LoaderLogger {
        public void error(String var1);

        public void error(String var1, Exception var2);

        public void warn(String var1);

        public void warn(String var1, Exception var2);

        public void info(String var1);
    }
}

