/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.loader.framework;

import de.uni_hildesheim.sse.easy.loader.framework.BundleException;
import de.uni_hildesheim.sse.easy.loader.framework.BundleInfo;
import de.uni_hildesheim.sse.easy.loader.framework.Log;
import de.uni_hildesheim.sse.easy.loader.framework.SimpleNameFilter;
import de.uni_hildesheim.sse.easy.loader.framework.Utils;
import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.PatternSyntaxException;

public class SimpleManifestNameFilter
extends SimpleNameFilter {
    public SimpleManifestNameFilter(String regEx) throws PatternSyntaxException {
        super(regEx);
    }

    @Override
    public boolean acceptJar(File jar) {
        boolean result = false;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jar);
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = BundleInfo.getAttributes(manifest);
            String name = BundleInfo.parseSymbolicName(attributes);
            result = this.acceptSymbolicName(name);
            jarFile.close();
        }
        catch (IOException e) {
            Utils.closeQuietly(jarFile);
            Log.warn("while scanning bundle in manifest filter: ", e);
        }
        catch (BundleException e) {
            Utils.closeQuietly(jarFile);
            Log.warn("while scanning bundle in manifest filter: ", e);
        }
        return result;
    }
}

