/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer;

import de.iip_ecosphere.platform.configuration.cfg.StatusCache;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.DecisionVariableProvider;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.GraphFactory;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.GraphFormat;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.IvmlGraphMapper;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.IvmlUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class DrawflowGraphFormat
implements GraphFormat {
    public static final String NAME = "drawflow";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getFormatKind() {
        return "JSON";
    }

    @Override
    public String toString(IvmlGraphMapper.IvmlGraph graph) throws ExecutionException {
        GraphWriter writer = new GraphWriter(graph);
        return writer.writeGraph();
    }

    @Override
    public IvmlGraphMapper.IvmlGraph fromString(String graph, GraphFactory factory, DecisionVariableProvider varProvider) throws ExecutionException {
        GraphReader reader = new GraphReader(factory, varProvider);
        return reader.read(graph);
    }

    private static <T> T getJson(JSONObject object, String field, Class<T> cls, Supplier<T> dflt, Function<Object, T> converter) {
        Object o = object.get((Object)field);
        T result = cls.isInstance(o) ? cls.cast(o) : (null != o && null != converter ? converter.apply(o) : dflt.get());
        return result;
    }

    private static JSONObject getJsonObject(JSONObject object, String field) {
        return DrawflowGraphFormat.getJson(object, field, JSONObject.class, () -> new JSONObject(), null);
    }

    private static JSONArray getJsonArray(JSONObject object, String field) {
        return DrawflowGraphFormat.getJson(object, field, JSONArray.class, () -> new JSONArray(), null);
    }

    private static String getString(JSONObject object, String field, String dflt) {
        return DrawflowGraphFormat.getJson(object, field, String.class, () -> dflt, null);
    }

    private static int getInteger(JSONObject object, String field, int dflt) {
        return DrawflowGraphFormat.getJson(object, field, Integer.class, () -> dflt, o -> Integer.parseInt(o.toString()));
    }

    private static class GraphWriter {
        private Map<IvmlGraphMapper.IvmlGraphNode, String> node2id = new HashMap<IvmlGraphMapper.IvmlGraphNode, String>();
        private IvmlGraphMapper.IvmlGraph graph;
        private Map<IvmlGraphMapper.IvmlGraphNode, Integer> inputCounts = new HashMap<IvmlGraphMapper.IvmlGraphNode, Integer>();
        private Map<IvmlGraphMapper.IvmlGraphNode, Integer> outputCounts = new HashMap<IvmlGraphMapper.IvmlGraphNode, Integer>();

        private GraphWriter(IvmlGraphMapper.IvmlGraph graph) {
            this.graph = graph;
            this.mapNodes();
        }

        private void mapNodes() {
            int id = 1;
            if (null != this.graph) {
                for (IvmlGraphMapper.IvmlGraphNode ivmlGraphNode : this.graph.nodes()) {
                    String tmp = String.valueOf(id);
                    this.node2id.put(ivmlGraphNode, tmp);
                    ++id;
                }
            }
        }

        private void serviceToData(IDecisionVariable service, JSONObject data) {
            if (null != service) {
                service = Configuration.dereference((IDecisionVariable)service);
                String type = IvmlDatatypeVisitor.getUnqualifiedType((IDatatype)service.getValue().getType());
                data.put((Object)"type", (Object)type);
                String kind = IvmlUtils.toName(IvmlUtils.getEnumValue(IvmlUtils.getNestedSafe(service, "kind")), "?");
                data.put((Object)"kind", (Object)kind);
                String sId = IvmlUtils.getStringValue(IvmlUtils.getNestedSafe(service, "id"), "");
                data.put((Object)"id", (Object)sId);
                this.processBackward(service.getNestedElement("input"), data, "bus-receive");
                this.processBackward(service.getNestedElement("output"), data, "bus-send");
                JSONObject serviceStates = new JSONObject();
                if (sId.length() > 0) {
                    StatusCache.getServiceStates((String)sId, state -> serviceStates.put((Object)state.getDeviceId(), (Object)state.getState()));
                }
                data.put((Object)"states", (Object)serviceStates);
            }
        }

        private void processBackward(IDecisionVariable set, JSONObject data, String name) {
            JSONArray array = new JSONArray();
            this.collectTypes(set, fwd -> fwd == false, type -> array.add(type));
            data.put((Object)name, (Object)array);
        }

        private JSONObject writeHomeData() {
            JSONObject homeData = new JSONObject();
            if (null != this.graph) {
                for (IvmlGraphMapper.IvmlGraphNode ivmlGraphNode : this.graph.nodes()) {
                    JSONObject jNode = new JSONObject();
                    String nodeId = this.node2id.get(ivmlGraphNode);
                    jNode.put((Object)"class", (Object)"node");
                    jNode.put((Object)"id", (Object)nodeId);
                    jNode.put((Object)"name", (Object)ivmlGraphNode.getName());
                    JSONObject data = new JSONObject();
                    data.put((Object)"ivmlVar", (Object)this.getId(ivmlGraphNode, nodeId));
                    this.serviceToData(IvmlUtils.getNestedSafe(ivmlGraphNode.getVariable(), "impl"), data);
                    jNode.put((Object)"data", (Object)data);
                    jNode.put((Object)"html", (Object)("<div>" + ivmlGraphNode.getName() + "</div>"));
                    jNode.put((Object)"typenode", (Object)false);
                    jNode.put((Object)"inputs", (Object)this.writeEdges(ivmlGraphNode, ivmlGraphNode.inEdges(), true));
                    jNode.put((Object)"outputs", (Object)this.writeEdges(ivmlGraphNode, ivmlGraphNode.outEdges(), false));
                    jNode.put((Object)"pos_x", (Object)ivmlGraphNode.getXPos());
                    jNode.put((Object)"pos_y", (Object)ivmlGraphNode.getYPos());
                    homeData.put((Object)nodeId, (Object)jNode);
                }
            }
            return homeData;
        }

        private String getId(IvmlGraphMapper.IvmlGraphNode node, String dflt) {
            String result = node.getVariable() != null ? node.getVariable().getDeclaration().getName() : dflt;
            return result;
        }

        private String writeGraph() {
            JSONObject otherData = new JSONObject();
            JSONObject other = new JSONObject();
            other.put((Object)"data", (Object)otherData);
            JSONObject home = new JSONObject();
            home.put((Object)"data", (Object)this.writeHomeData());
            JSONObject dataflow = new JSONObject();
            dataflow.put((Object)"Home", (Object)home);
            dataflow.put((Object)"Other", (Object)other);
            JSONObject outer = new JSONObject();
            outer.put((Object)DrawflowGraphFormat.NAME, (Object)dataflow);
            return outer.toJSONString();
        }

        private JSONObject writeEdges(IvmlGraphMapper.IvmlGraphNode node, Iterable<? extends IvmlGraphMapper.IvmlGraphEdge> edges, boolean inputEdges) {
            JSONObject result = new JSONObject();
            String prefix = inputEdges ? "input_" : "output_";
            int count = 1;
            for (IvmlGraphMapper.IvmlGraphEdge ivmlGraphEdge : edges) {
                IvmlGraphMapper.IvmlGraphNode other;
                JSONObject inOutput = new JSONObject();
                JSONObject jEdge = new JSONObject();
                JSONArray conns = new JSONArray();
                JSONObject data = new JSONObject();
                if (inputEdges) {
                    other = ivmlGraphEdge.getStart();
                    jEdge.put((Object)"input", (Object)("output_" + this.nextCount(other, this.outputCounts)));
                    this.collectForwardTypes(other, node, ivmlGraphEdge, data);
                } else {
                    other = ivmlGraphEdge.getEnd();
                    jEdge.put((Object)"output", (Object)("input_" + this.nextCount(other, this.inputCounts)));
                    this.collectForwardTypes(node, other, ivmlGraphEdge, data);
                }
                jEdge.put((Object)"node", (Object)this.node2id.get(other));
                conns.add((Object)jEdge);
                inOutput.put((Object)"connections", (Object)conns);
                inOutput.put((Object)"data", (Object)data);
                result.put((Object)(prefix + count), (Object)inOutput);
                ++count;
            }
            return result;
        }

        private void collectForwardTypes(IvmlGraphMapper.IvmlGraphNode start, IvmlGraphMapper.IvmlGraphNode end, IvmlGraphMapper.IvmlGraphEdge edge, JSONObject data) {
            if (start.getVariable() != null && end.getVariable() != null) {
                TreeSet types = new TreeSet();
                this.collectTypes(start.getVariable().getNestedElement("output"), fwd -> fwd, s -> types.add(s));
                TreeSet types2 = new TreeSet();
                this.collectTypes(end.getVariable().getNestedElement("input"), fwd -> fwd, s -> types2.add(s));
                types.retainAll(types2);
                JSONArray array = new JSONArray();
                for (String type : types) {
                    array.add((Object)type);
                }
                data.put((Object)"types", (Object)array);
            }
        }

        private void collectTypes(IDecisionVariable set, Predicate<Boolean> direction, Consumer<String> consumer) {
            for (int n = 0; n < set.getNestedElementsCount(); ++n) {
                String typeName;
                IDecisionVariable dataType;
                IDecisionVariable type = set.getNestedElement(n);
                if (!direction.test(IvmlUtils.getBooleanValue(type.getNestedElement("forward"), true)) || null == (dataType = Configuration.dereference((IDecisionVariable)type.getNestedElement("type"))) || (typeName = IvmlUtils.getStringValue(dataType.getNestedElement("name"), "")).length() <= 0) continue;
                consumer.accept(typeName);
            }
        }

        private int nextCount(IvmlGraphMapper.IvmlGraphNode node, Map<IvmlGraphMapper.IvmlGraphNode, Integer> counts) {
            Integer result = counts.get(node);
            if (null == result) {
                result = 1;
            } else {
                Integer n = result;
                result = result + 1;
            }
            counts.put(node, result);
            return result;
        }
    }

    private static class GraphReader {
        private GraphFactory factory;
        private DecisionVariableProvider varProvider;
        private Map<String, IvmlGraphMapper.IvmlGraphNode> id2Nodes = new HashMap<String, IvmlGraphMapper.IvmlGraphNode>();
        private Map<String, IvmlGraphMapper.IvmlGraphEdge> ids2Edges = new HashMap<String, IvmlGraphMapper.IvmlGraphEdge>();

        private GraphReader(GraphFactory factory, DecisionVariableProvider varProvider) {
            this.factory = factory;
            this.varProvider = varProvider;
        }

        private JSONObject optional(JSONObject base, JSONObject optional) {
            return !(null != optional && !optional.isEmpty() || base.size() == 1 && base.containsKey((Object)"data")) ? base : optional;
        }

        private IvmlGraphMapper.IvmlGraph read(String graph) throws ExecutionException {
            IvmlGraphMapper.IvmlGraph result = null;
            try {
                JSONObject node;
                JSONParser jsonParser = new JSONParser();
                JSONObject top = (JSONObject)jsonParser.parse(graph);
                JSONObject drawflow = this.optional(top, DrawflowGraphFormat.getJsonObject(top, DrawflowGraphFormat.NAME));
                JSONObject home = this.optional(drawflow, DrawflowGraphFormat.getJsonObject(drawflow, "Home"));
                JSONObject data = this.optional(home, DrawflowGraphFormat.getJsonObject(home, "data"));
                result = this.factory.createGraph(null);
                for (Object id : data.keySet()) {
                    node = DrawflowGraphFormat.getJsonObject(data, id.toString());
                    String varName = DrawflowGraphFormat.getString(node, "id", "");
                    String name = DrawflowGraphFormat.getString(node, "name", "");
                    IDecisionVariable var = this.varProvider.getVariable(varName);
                    if (null == var) {
                        var = null;
                    }
                    IvmlGraphMapper.IvmlGraphNode gNode = this.factory.createNode(var);
                    result.addNode(gNode);
                    gNode.setXPos(DrawflowGraphFormat.getInteger(node, "pos_x", -1));
                    gNode.setYPos(DrawflowGraphFormat.getInteger(node, "pos_y", -1));
                    gNode.setName(name);
                    this.id2Nodes.put(id.toString(), gNode);
                }
                for (Object id : data.keySet()) {
                    node = DrawflowGraphFormat.getJsonObject(data, id.toString());
                    this.readEdges(id, node, true);
                    this.readEdges(id, node, false);
                }
            }
            catch (ParseException e) {
                throw new ExecutionException("While parsing graph JSON: " + e.getMessage(), e);
            }
            return result;
        }

        private void readEdges(Object id, JSONObject node, boolean inputEdges) {
            IvmlGraphMapper.IvmlGraphNode gNode = this.id2Nodes.get(id.toString());
            JSONObject edges = DrawflowGraphFormat.getJsonObject(node, inputEdges ? "inputs" : "outputs");
            for (Object eId : edges.keySet()) {
                JSONObject edge = DrawflowGraphFormat.getJsonObject(edges, eId.toString());
                JSONArray connections = DrawflowGraphFormat.getJsonArray(edge, "connections");
                for (int c = 0; c < connections.size(); ++c) {
                    JSONObject connection = (JSONObject)connections.get(c);
                    String oId = DrawflowGraphFormat.getString(connection, "node", "");
                    IvmlGraphMapper.IvmlGraphNode oNode = this.id2Nodes.get(oId);
                    String edgeId = inputEdges ? oId + "|" + String.valueOf(id) : String.valueOf(id) + "|" + oId;
                    if (this.ids2Edges.containsKey(edgeId)) continue;
                    IvmlGraphMapper.IvmlGraphEdge gEdge = inputEdges ? this.factory.createEdge(null, oNode, gNode) : this.factory.createEdge(null, gNode, oNode);
                    gNode.addEdge(gEdge);
                    oNode.addEdge(gEdge);
                    this.ids2Edges.put(edgeId, gEdge);
                }
            }
        }
    }
}

