/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer;

import de.iip_ecosphere.platform.configuration.easyProducer.ModelInfo;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.ssehub.easy.varModel.confModel.AbstractConfigurationStatisticsVisitor;
import net.ssehub.easy.varModel.confModel.IConfigurationElement;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;

public class StatisticsVisitor
extends AbstractConfigurationStatisticsVisitor {
    private Function<AbstractVariable, Boolean> noComment = v -> true;
    private Set<Object> done = new HashSet<Object>();

    public StatisticsVisitor() {
        super((AbstractConfigurationStatisticsVisitor.ConfigStatistics)new Statistics());
    }

    public void setNoCommentConsumer(Function<AbstractVariable, Boolean> noComment) {
        if (null != noComment) {
            this.noComment = noComment;
        }
    }

    private static boolean isParentContainer(IDecisionVariable variable) {
        IConfigurationElement elt = variable.getParent();
        return null == elt.getDeclaration() ? false : TypeQueries.isContainer((IDatatype)elt.getDeclaration().getType());
    }

    protected void specialTreatment(IDecisionVariable variable) {
        AbstractVariable decl = variable.getDeclaration();
        Project prj = decl.getProject();
        if (ModelInfo.isMetaProject(prj)) {
            if (!StatisticsVisitor.isParentContainer(variable)) {
                this.specialTreatment(decl);
            }
            if (!this.done.contains(prj)) {
                this.done.add(prj);
                for (int e = 0; e < prj.getElementCount(); ++e) {
                    ContainableModelElement elt = prj.getElement(e);
                    if (!(elt instanceof Compound)) continue;
                    this.specialTreatment((Compound)elt);
                }
            }
        }
    }

    private void specialTreatment(AbstractVariable var) {
        if (!this.done.contains(var)) {
            Statistics stat = this.getStatistics();
            ++stat.metaVars;
            if (ModelInfo.hasComment((ModelElement)var)) {
                ++stat.metaVarsWithComment;
            } else if (!this.noComment.apply(var).booleanValue()) {
                ++stat.metaVarsWithComment;
            }
            this.done.add(var);
        }
    }

    private void specialTreatment(Compound cmp) {
        for (int e = 0; e < cmp.getDeclarationCount(); ++e) {
            this.specialTreatment((AbstractVariable)cmp.getDeclaration(e));
        }
        for (int a = 0; a < cmp.getAssignmentCount(); ++a) {
            this.specialTreatment(cmp.getAssignment(a));
        }
    }

    private void specialTreatment(AttributeAssignment assng) {
        for (int e = 0; e < assng.getDeclarationCount(); ++e) {
            this.specialTreatment((AbstractVariable)assng.getDeclaration(e));
        }
        for (int a = 0; a < assng.getAssignmentCount(); ++a) {
            this.specialTreatment(assng.getAssignment(a));
        }
    }

    protected void specialTreatment(Project mainProject) {
    }

    public Statistics getStatistics() {
        return (Statistics)super.getStatistics();
    }

    public static class Statistics
    extends AbstractConfigurationStatisticsVisitor.ConfigStatistics {
        private int metaVars = 0;
        private int metaVarsWithComment = 0;

        public int getMetaVars() {
            return this.metaVars;
        }

        public int getMetaVarsWithComment() {
            return this.metaVarsWithComment;
        }
    }
}

