/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer.opcua.data;

public abstract class BaseType {
    private String varName;
    private String nodeId;
    private String browseName;
    private String displayName;
    private String description;
    private boolean optional;

    public BaseType(String nodeId, String browseName, String displayname, String description, boolean optional) {
        this.nodeId = nodeId;
        this.browseName = browseName;
        this.displayName = displayname;
        this.description = description;
        this.optional = optional;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = BaseType.validateVarName(varName);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getBrowseName() {
        return this.browseName;
    }

    public String getDisplayname() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String toString() {
        return "BaseType [nodeId=" + this.nodeId + ", browseName=" + this.browseName + ", displayName=" + this.displayName + ", description=" + this.description + "]";
    }

    public static String formatNodeId(String nodeId) {
        if (((String)nodeId).contains("ns=")) {
            String nameSpaceIndex = ((String)nodeId).substring(3, ((String)nodeId).indexOf(59));
            String identifier = ((String)nodeId).substring(((String)nodeId).indexOf(59) + 3, ((String)nodeId).length());
            nodeId = "nodeId = {nameSpaceIndex = " + nameSpaceIndex + ", identifier = " + identifier + "},";
        } else {
            String identifier = ((String)nodeId).replace("i=", "");
            nodeId = "nodeId = {nameSpaceIndex = 0, identifier = " + identifier + "},";
        }
        return nodeId;
    }

    public static String validateVarName(String varName) {
        varName = ((String)varName).replaceAll("[^A-Za-z0-9]", "");
        if (Character.isDigit(((String)(varName = ((String)varName).replace("_", ""))).charAt(0))) {
            varName = "_" + (String)varName;
        }
        return varName;
    }
}

