/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.datatypes;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.datatypes.CustomDatatype;
import net.ssehub.easy.varModel.model.datatypes.DelegatingType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.IDerivedDatatypeListener;

public class DerivedDatatype
extends CustomDatatype {
    static final DelegatingType DTYPE = new DelegatingType();
    public static final IDatatype TYPE = DTYPE;
    private DecisionVariableDeclaration typeDeclaration;
    private Constraint[] constraints;
    private IDatatype basisType;
    private List<IDerivedDatatypeListener> listeners = new ArrayList<IDerivedDatatypeListener>();

    static {
        DTYPE.setDelegate(new DerivedDatatype());
    }

    private DerivedDatatype() {
        this("<DerivedDatatype>", (IDatatype)null, (ModelElement)null);
    }

    public DerivedDatatype(String name, IDatatype basisType, ModelElement parent) {
        this(name, basisType, parent, null);
    }

    public DerivedDatatype(String name, IDatatype basisType, ModelElement parent, Constraint ... constraints) {
        super(name, DTYPE, parent);
        this.constraints = constraints;
        this.basisType = basisType;
        this.typeDeclaration = new DecisionVariableDeclaration(name, this, this);
    }

    public void setConstraints(Constraint[] constraints) {
        this.constraints = constraints;
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).constraintsChanged();
            ++i;
        }
    }

    public void register(IDerivedDatatypeListener listener) {
        this.listeners.add(listener);
    }

    public boolean unregister(IDerivedDatatypeListener listener) {
        return this.listeners.remove(listener);
    }

    public int getConstraintCount() {
        return this.constraints == null ? 0 : this.constraints.length;
    }

    public DecisionVariableDeclaration getTypeDeclaration() {
        return this.typeDeclaration;
    }

    public Constraint getConstraint(int index) {
        return this.constraints[index];
    }

    public IDatatype getBasisType() {
        return this.basisType;
    }

    @Override
    public void accept(IModelVisitor visitor) {
        visitor.visitDerivedDatatype(this);
    }

    @Override
    public void accept(IDatatypeVisitor visitor) {
        visitor.visitDerivedType(this);
    }

    @Override
    public boolean isAssignableFrom(IDatatype type) {
        IDatatype baseType = DerivedDatatype.resolveToBasis(this.getBasisType());
        IDatatype otherType = DerivedDatatype.resolveToBasis(type);
        boolean result = baseType != null ? baseType.isAssignableFrom(otherType) : (DTYPE.getDelegate() == this || TYPE == this) && type instanceof DerivedDatatype;
        return result;
    }

    public static final IDatatype resolveToBasis(IDatatype type) {
        while (type instanceof DerivedDatatype) {
            type = ((DerivedDatatype)type).getBasisType();
        }
        return type;
    }
}

