/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;

public class FileUtils {
    public static boolean isFileURI(URI uri) {
        return uri != null && "file".equals(uri.getScheme());
    }

    public static boolean isFileURL(URL url) {
        return url != null && "file".equals(url.getProtocol());
    }

    public static void copyFile(File target, File source) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(source);
            FileUtils.copyToFile(target, in);
            in.close();
        }
        catch (IOException e) {
            if (in != null) {
                FileUtils.closeQuietly(in);
            }
            throw e;
        }
    }

    public static void copyToFile(File file, InputStream in) throws IOException {
        FileUtils.copyToFile(file, in, null);
    }

    public static void copyToFile(File file, InputStream in, byte[] buffer) throws IOException {
        if (buffer == null) {
            buffer = new byte[1024];
        }
        FileOutputStream fos = new FileOutputStream(file);
        try {
            int read;
            do {
                if ((read = in.read(buffer)) <= 0) continue;
                fos.write(buffer, 0, read);
            } while (read > 0);
        }
        catch (IOException e) {
            FileUtils.closeQuietly(fos);
            throw e;
        }
        fos.close();
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void createIfNotExists(File file) {
        if (file != null && !file.exists()) {
            file.mkdirs();
        }
    }

    public static File createTmpDir(String name) {
        return FileUtils.createTmpDir(name, true);
    }

    public static File createTmpDir(String name, boolean deleteIfExists) {
        File result;
        String tmp = System.getProperty("java.io.tempdir");
        if (tmp == null) {
            try {
                File f = File.createTempFile("easy", "tmp");
                result = f.getParentFile();
                f.delete();
            }
            catch (IOException e) {
                result = new File("tmp");
                result.mkdirs();
            }
        } else {
            result = new File(tmp);
        }
        if (name != null) {
            result = new File(result, name);
        }
        if (deleteIfExists && result.exists()) {
            result.delete();
        }
        FileUtils.createIfNotExists(result);
        result.deleteOnExit();
        return result;
    }

    public static void appendToLogFile(String text) {
        FileUtils.appendToFile(new File(System.getProperty("user.home"), "easy-debug.log"), text);
    }

    public static void appendToFile(File file, String text) {
        try {
            Files.write(file.toPath(), (text + "\n").getBytes(), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

