/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.io;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import net.ssehub.easy.basics.io.FileUtils;

public class JarUtils {
    public static boolean isJarURI(URI uri) {
        return uri != null && "jar".equals(uri.getScheme());
    }

    public static boolean isJarURL(URL url) {
        return url != null && "jar".equals(url.getProtocol());
    }

    public static void unpackJar(URL url, File target) throws MalformedURLException, IOException {
        if (JarUtils.isJarURL(url)) {
            String path = url.getPath();
            int pos = path.indexOf(33);
            if (pos > 0 && pos + 1 < path.length()) {
                URL fileUrl = new URL(path.substring(0, pos));
                Object resource = path.substring(pos + 1);
                while (((String)resource).startsWith("/")) {
                    resource = ((String)resource).substring(1);
                }
                if (((String)resource).isEmpty()) {
                    resource = null;
                } else if (!((String)resource).endsWith("/")) {
                    resource = (String)resource + "/";
                }
                JarUtils.unpackJar(fileUrl, (String)resource, target);
            } else {
                JarUtils.unpackJar(url, null, target);
            }
        } else {
            throw new MalformedURLException("Given URL is not a Jar URL: " + String.valueOf(url));
        }
    }

    public static void unpackJar(URL url, String resource, File target) throws IOException {
        byte[] buffer = new byte[1024];
        JarInputStream jis = new JarInputStream(url.openStream());
        try {
            JarEntry entry;
            do {
                if ((entry = jis.getNextJarEntry()) == null || resource != null && !entry.getName().startsWith(resource)) continue;
                File targetFile = new File(target, entry.getName());
                if (entry.isDirectory()) {
                    FileUtils.createIfNotExists(targetFile);
                    continue;
                }
                File parentFile = targetFile.getParentFile();
                FileUtils.createIfNotExists(parentFile);
                FileUtils.copyToFile(targetFile, jis, buffer);
            } while (entry != null);
        }
        catch (IOException e) {
            FileUtils.closeQuietly(jis);
            throw e;
        }
        jis.close();
    }
}

