/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.logger;

import java.util.logging.Handler;
import java.util.logging.Logger;
import net.ssehub.easy.basics.logger.AbstractJavaLogger;

public class AdvancedJavaLogger
extends AbstractJavaLogger {
    private Logger infoLoger;
    private Logger errorLoger;

    public AdvancedJavaLogger() {
        AbstractJavaLogger.ConsoleHandler infoHandler = new AbstractJavaLogger.ConsoleHandler(this);
        infoHandler.setConsole(System.out);
        this.infoLoger = AdvancedJavaLogger.createLogger("::info");
        this.infoLoger.addHandler(infoHandler);
        AbstractJavaLogger.ConsoleHandler errorHandler = new AbstractJavaLogger.ConsoleHandler(this);
        this.errorLoger = AdvancedJavaLogger.createLogger("::error");
        this.errorLoger.addHandler(errorHandler);
    }

    private static Logger createLogger(String appendix) {
        Logger logger = AdvancedJavaLogger.createLogger(AdvancedJavaLogger.class, appendix);
        Handler[] oldHandlers = logger.getHandlers();
        int i = 0;
        while (i < oldHandlers.length) {
            logger.removeHandler(oldHandlers[i]);
            ++i;
        }
        return logger;
    }

    @Override
    public void info(String msg, Class<?> clazz, String bundleName) {
        this.infoLoger.info("[" + clazz.getSimpleName() + "] " + msg);
    }

    @Override
    public void error(String msg, Class<?> clazz, String bundleName) {
        this.errorLoger.severe("[" + clazz.getSimpleName() + "] " + msg);
    }

    @Override
    public void warn(String msg, Class<?> clazz, String bundleName) {
        this.errorLoger.warning("[" + clazz.getSimpleName() + "] " + msg);
    }

    @Override
    public void debug(String msg, Class<?> clazz, String bundleName) {
        this.infoLoger.log(DEBUG_LEVEL, "[" + clazz.getSimpleName() + "] " + msg);
    }

    @Override
    public void exception(String msg, Class<?> clazz, String bundleName) {
        this.errorLoger.log(EXCEPTION_LEVEL, "[" + clazz.getSimpleName() + "] " + msg);
    }
}

