/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.logger;

import net.ssehub.easy.basics.logger.FileLogger;
import net.ssehub.easy.basics.logger.ILogger;
import net.ssehub.easy.basics.logger.JavaLogger;
import net.ssehub.easy.basics.logger.LoggingLevel;

public class EASyLoggerFactory {
    public static final EASyLoggerFactory INSTANCE = new EASyLoggerFactory();
    public static final boolean DEBUG = false;
    private static final String LOGGING_LEVEL_PROPERTY = "easy.logging.level";
    private static final String LOGGING_TRACE_PROPERTY = "easy.logging.trace";
    private static final boolean TRACE = Boolean.valueOf(System.getProperty("easy.logging.trace", "false"));
    private static final String LOG_FILE_PATH = "easy.logging.file";
    private ILogger logger;
    private LoggingLevel level = EASyLoggerFactory.determineLevel(LoggingLevel.WARN);

    private EASyLoggerFactory() {
        FileLogger fileLogger;
        this.setLogger(new JavaLogger());
        String logFile = System.getProperty(LOG_FILE_PATH);
        if (logFile != null && (fileLogger = FileLogger.getInstance(logFile, false)) != null) {
            this.setLogger(fileLogger);
        }
    }

    private static LoggingLevel determineLevel(LoggingLevel defaultLevel) {
        LoggingLevel level = defaultLevel;
        String property = System.getProperty(LOGGING_LEVEL_PROPERTY);
        if (property != null) {
            try {
                level = LoggingLevel.valueOf(property);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return level;
    }

    public EASyLogger getLogger(Class<?> clazz, String bundleName) {
        return new EASyLogger(clazz, bundleName);
    }

    public ILogger setLogger(ILogger logger) {
        ILogger old = this.logger;
        this.logger = logger;
        return old;
    }

    public LoggingLevel getLoggingLevel() {
        return this.level;
    }

    public void setLoggingLevel(LoggingLevel loggingLevel) {
        this.level = loggingLevel;
    }

    public class EASyLogger {
        private String bundleName;
        private Class<?> clazz;

        private EASyLogger(Class<?> clazz, String bundleName) {
            this.clazz = clazz;
            this.bundleName = bundleName;
        }

        public void debug(String msg) {
            if (EASyLoggerFactory.this.level == LoggingLevel.DEBUG) {
                EASyLoggerFactory.this.logger.debug(msg, this.clazz, this.bundleName);
                this.trace();
            }
        }

        public void debug(Object msg) {
            if (EASyLoggerFactory.this.level == LoggingLevel.DEBUG && msg != null) {
                EASyLoggerFactory.this.logger.debug(msg.toString(), this.clazz, this.bundleName);
                this.trace();
            }
        }

        public void debug(Object msg1, Object msg2) {
            if (EASyLoggerFactory.this.level == LoggingLevel.DEBUG && msg1 != null) {
                EASyLoggerFactory.this.logger.debug(msg1.toString() + String.valueOf(msg2), this.clazz, this.bundleName);
                this.trace();
            }
        }

        public void debug(Object msg1, Object msg2, Object msg3) {
            if (EASyLoggerFactory.this.level == LoggingLevel.DEBUG && msg1 != null) {
                EASyLoggerFactory.this.logger.debug(msg1.toString() + String.valueOf(msg2) + String.valueOf(msg3), this.clazz, this.bundleName);
                this.trace();
            }
        }

        public void debug(Object msg1, Object msg2, Object msg3, Object msg4) {
            if (EASyLoggerFactory.this.level == LoggingLevel.DEBUG && msg1 != null) {
                EASyLoggerFactory.this.logger.debug(msg1.toString() + String.valueOf(msg2) + String.valueOf(msg3) + String.valueOf(msg4), this.clazz, this.bundleName);
                this.trace();
            }
        }

        public void debug(Object msg1, Object msg2, Object msg3, Object msg4, Object ... msg5) {
            if (EASyLoggerFactory.this.level == LoggingLevel.DEBUG) {
                StringBuffer message = new StringBuffer();
                message.append(msg1.toString());
                message.append(msg2.toString());
                message.append(msg3.toString());
                message.append(msg4.toString());
                int i = 0;
                while (i < msg5.length) {
                    message.append(msg5[i].toString());
                    ++i;
                }
                EASyLoggerFactory.this.logger.debug(message.toString(), this.clazz, this.bundleName);
                this.trace();
            }
        }

        public void info(String msg) {
            if (EASyLoggerFactory.this.level.ordinal() <= LoggingLevel.INFO.ordinal()) {
                EASyLoggerFactory.this.logger.info(msg, this.clazz, this.bundleName);
                this.trace();
            }
        }

        public void warn(String msg) {
            if (EASyLoggerFactory.this.level.ordinal() <= LoggingLevel.WARN.ordinal()) {
                EASyLoggerFactory.this.logger.warn(msg, this.clazz, this.bundleName);
                this.trace();
            }
        }

        public void error(String msg) {
            if (EASyLoggerFactory.this.level.ordinal() <= LoggingLevel.ERROR.ordinal()) {
                EASyLoggerFactory.this.logger.error(msg, this.clazz, this.bundleName);
                this.trace();
            }
        }

        public void exception(Exception exception) {
            if (EASyLoggerFactory.this.level != LoggingLevel.OFF) {
                EASyLoggerFactory.this.logger.exception(exception.getMessage(), this.clazz, this.bundleName);
                if (EASyLoggerFactory.this.level == LoggingLevel.DEBUG) {
                    exception.printStackTrace();
                }
                this.trace();
            }
        }

        private void trace() {
            if (TRACE) {
                Throwable th = new Throwable();
                StackTraceElement[] trace = th.getStackTrace();
                int t = 2;
                while (t < trace.length) {
                    System.out.println(trace[t]);
                    ++t;
                }
            }
        }
    }
}

