/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelListener;
import net.ssehub.easy.basics.modelManagement.IModelProcessingListener;
import net.ssehub.easy.basics.modelManagement.IModelReloadListener;
import net.ssehub.easy.basics.modelManagement.ModelInfo;

public class ModelEvents<M extends IModel> {
    private Map<M, List<IModelListener<M>>> modelListeners = new HashMap<M, List<IModelListener<M>>>();
    private Map<M, List<IModelReloadListener<M>>> modelReloadListeners = new HashMap<M, List<IModelReloadListener<M>>>();
    private Map<ModelInfo<M>, List<IModelProcessingListener<M>>> modelProcessingListeners = new HashMap<ModelInfo<M>, List<IModelProcessingListener<M>>>();

    ModelEvents() {
    }

    synchronized void notifyModelReloadFailed(M model) {
        List<IModelReloadListener<M>> listeners;
        if (model != null && (listeners = this.modelReloadListeners.get(model)) != null) {
            int l = 0;
            while (l < listeners.size()) {
                listeners.get(l).notifyReloadFailed(model);
                ++l;
            }
        }
    }

    public synchronized void notifyModelProcessing(ModelInfo<M> info, boolean start, IModelProcessingListener.Type type) {
        List<IModelProcessingListener<M>> listeners;
        if (info != null && (listeners = this.modelProcessingListeners.get(info)) != null) {
            int l = 0;
            while (l < listeners.size()) {
                IModelProcessingListener<M> listener = listeners.get(l);
                if (start) {
                    listener.notifyProcessingStarted(info, type);
                } else {
                    listener.notifyProcessingEnded(info, type);
                }
                ++l;
            }
        }
    }

    synchronized void notifyModelReplacement(M oldModel, M newModel) {
        List<IModelListener<M>> oldListeners = this.modelListeners.get(oldModel);
        if (oldListeners != null) {
            int l = 0;
            while (l < oldListeners.size()) {
                oldListeners.get(l).notifyReplaced(oldModel, newModel);
                ++l;
            }
            if (oldModel != newModel) {
                this.updateListeners(this.modelListeners.get(oldModel), this.modelListeners, oldModel, newModel);
                this.updateListeners(this.modelReloadListeners.get(oldModel), this.modelReloadListeners, oldModel, newModel);
            }
        }
    }

    private <T> void updateListeners(List<T> oldListeners, Map<M, List<T>> listeners, M oldModel, M newModel) {
        if (oldListeners != null) {
            List<T> newListeners = listeners.get(newModel);
            if (newListeners == null) {
                listeners.put(newModel, oldListeners);
            } else {
                newListeners.addAll(oldListeners);
            }
            listeners.remove(oldModel);
        }
    }

    void removeAllListeners(M model) {
        this.modelListeners.remove(model);
        this.modelReloadListeners.remove(model);
    }

    public synchronized void addModelListener(M model, IModelListener<M> listener) {
        ModelEvents.add(model, this.modelListeners, listener);
    }

    public synchronized void addProcessingListener(ModelInfo<M> info, IModelProcessingListener<M> listener) {
        ModelEvents.add(info, this.modelProcessingListeners, listener);
    }

    public synchronized boolean removeModelListener(M model, IModelListener<M> listener) {
        return ModelEvents.remove(model, this.modelListeners, listener);
    }

    public synchronized void addReloadListener(M model, IModelReloadListener<M> listener) {
        ModelEvents.add(model, this.modelReloadListeners, listener);
    }

    public synchronized boolean removeModelReloadListener(M model, IModelReloadListener<M> listener) {
        return ModelEvents.remove(model, this.modelReloadListeners, listener);
    }

    public synchronized boolean removeProcessingListener(ModelInfo<M> info, IModelProcessingListener<M> listener) {
        return ModelEvents.remove(info, this.modelProcessingListeners, listener);
    }

    private static <T, I> void add(I identifier, Map<I, List<T>> listeners, T listener) {
        assert (identifier != null);
        assert (listener != null);
        List<T> tmp = listeners.get(identifier);
        if (tmp == null) {
            tmp = new ArrayList<T>();
            listeners.put(identifier, tmp);
        }
        tmp.add(listener);
    }

    private static <T, I> boolean remove(I identifier, Map<I, List<T>> listeners, T listener) {
        assert (identifier != null);
        assert (listener != null);
        boolean removed = false;
        List<T> tmp = listeners.get(identifier);
        if (tmp != null) {
            removed = tmp.remove(listener);
        }
        return removed;
    }
}

