/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.json;

import java.text.Collator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import net.ssehub.easy.basics.DefaultLocale;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Map;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.json.INodeParent;

public class JsonNode
implements IVilType,
IStringValueProvider,
INodeParent {
    private java.util.Map<String, Object> data;
    private List<String> sequence = new ArrayList<String>();
    private INodeParent parent;

    JsonNode(INodeParent parent) {
        this.data = new HashMap<String, Object>();
        this.parent = parent;
    }

    JsonNode(java.util.Map<String, Object> data, INodeParent parent) {
        this.data = data;
        this.parent = parent;
    }

    JsonNode(Object data, INodeParent parent) {
        this(parent);
        if (data instanceof java.util.Map) {
            java.util.Map value = (java.util.Map)data;
            for (Object key : value.keySet()) {
                Object val = value.get(key);
                this.set(key.toString(), val, false);
            }
        }
    }

    private void set(String key, Object val, boolean notify) {
        if (this.data.put(key, IVilType.convertVilValue((Object)val)) == null) {
            this.sequence.add(key);
        }
        if (notify) {
            this.notifyChanged();
        }
    }

    public boolean has(String name) {
        return this.data.containsKey(name);
    }

    public JsonNode addValue(String name, Object value) {
        this.set(name, value, true);
        this.notifyChanged();
        return this;
    }

    public JsonNode addValueNotEmpty(String name, Object value) {
        boolean add = true;
        if (value instanceof String) {
            boolean bl = add = !((String)value).isEmpty();
        }
        if (add) {
            this.addValue(name, value);
        }
        return this;
    }

    public JsonNode addObject(String name) {
        JsonNode node = new JsonNode(new HashMap<String, Object>(), (INodeParent)this);
        this.set(name, node, true);
        return node;
    }

    public JsonNode delete(String name) {
        this.data.remove(name);
        this.sequence.remove(name);
        this.notifyChanged();
        return this;
    }

    public Object getValue(String name) {
        return this.data.get(name);
    }

    public Sequence<Object> getListValue(String name) {
        ListSequence result = null;
        if (this.isList(name)) {
            List tmp = (List)this.data.get(name);
            result = new ListSequence(tmp, new TypeDescriptor[]{TypeRegistry.anyType()});
        }
        return result;
    }

    public boolean isList(String name) {
        return this.data.get(name) instanceof List;
    }

    public Map<String, Object> getMapValue(String name) {
        Map result = null;
        if (this.isList(name)) {
            java.util.Map tmp = (java.util.Map)this.data.get(name);
            TypeDescriptor[] types = TypeDescriptor.createArray((int)2);
            types[0] = TypeRegistry.stringType();
            types[1] = TypeRegistry.anyType();
            result = new Map(tmp, types);
        }
        return result;
    }

    public boolean isMap(String name) {
        return this.data.get(name) instanceof Map;
    }

    public JsonNode getObject(String name) {
        return this.isObject(name) ? new JsonNode((Map)this.data.get(name), (INodeParent)this) : null;
    }

    public boolean isObject(String name) {
        return this.data.get(name) instanceof Map;
    }

    public JsonNode addList(String name, Sequence<?> value) {
        ArrayList<Object> tmp = new ArrayList<Object>();
        for (Object o : value) {
            tmp.add(IVilType.convertVilValue(o));
        }
        this.set(name, tmp, true);
        return this;
    }

    public JsonNode addValues(Map<?, ?> value) {
        for (Object key : value.keys()) {
            Object val = value.get(key);
            this.set(key.toString(), val, false);
        }
        this.notifyChanged();
        return this;
    }

    public JsonNode addMap(String name, Map<?, ?> value) {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        for (Object key : value.keys()) {
            Object val = IVilType.convertVilValue((Object)value.get(key));
            tmp.put(key.toString(), val);
        }
        this.set(name, tmp, true);
        return this;
    }

    @Invisible
    java.util.Map<String, Object> getData(Sorting sorting) {
        AbstractMap result = switch (sorting) {
            case Sorting.INSERT -> {
                HashMap<String, Integer> seq = new HashMap<String, Integer>();
                int i = 0;
                while (i < this.sequence.size()) {
                    seq.put(this.sequence.get(i), i);
                    ++i;
                }
                yield new TreeMap((f1, f2) -> Integer.compare((Integer)seq.get(f1), (Integer)seq.get(f2)));
            }
            case Sorting.ALPHA -> new TreeMap((f1, f2) -> f1.compareTo((String)f2));
            case Sorting.COLLATOR -> new TreeMap(Collator.getInstance(DefaultLocale.getDefaultLocale()));
            default -> new HashMap();
        };
        for (String key : this.data.keySet()) {
            java.util.Map<String, Object> value = this.data.get(key);
            if (value instanceof JsonNode) {
                value = ((JsonNode)((Object)value)).getData(sorting);
            }
            result.put(key, value);
        }
        return result;
    }

    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return comparator != null ? "JsonNode" : this.data.toString();
    }

    @Override
    public void notifyChanged() {
        if (this.parent != null) {
            this.parent.notifyChanged();
        }
    }

    static enum Sorting {
        NONE,
        INSERT,
        ALPHA,
        COLLATOR;

    }
}

