/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.configuration.easyProducer;

import java.io.File;
import java.io.IOException;
import test.de.iip_ecosphere.platform.configuration.easyProducer.AbstractIvmlTests;

public abstract class AbstractIvmlSerializerConfigTests
extends AbstractIvmlTests {
    protected void assertApplication(File base, boolean withFamily) throws IOException {
        File srcMain = new File(base, "src/main");
        File srcMainJava = new File(srcMain, "java");
        File srcMainResources = new File(srcMain, "resources");
        File srcMainJavaIip = new File(srcMainJava, "iip");
        this.assertJavaNode(srcMainJavaIip, "MyAnonymizerExample", false);
        if (withFamily) {
            this.assertJavaNode(srcMainJavaIip, "KIFamilyExample", false);
            this.assertJavaNode(srcMainJavaIip, "KIFamilyExampleFamilyInterface", true);
            this.assertJavaNode(srcMainJavaIip, "AlternativeMyKiExampleFamilyKIFamilyExample", true);
            this.assertJavaNode(srcMainJavaIip, "MyKiExampleFamilyKIFamilyExample", true);
        } else {
            this.assertJavaNode(srcMainJavaIip, "MyKiExample", false);
        }
        this.assertJavaNode(srcMainJavaIip, "MyMqttConnExample", true);
        this.assertJavaNode(srcMainJavaIip, "MyOpcConnExample", true);
        this.assertJavaNode(srcMainJavaIip, "MySourceExample", false);
        AbstractIvmlSerializerConfigTests.assertFile(srcMainResources, "application.yml");
        this.assertDeploymentYaml(srcMainResources, "deployment.yml");
        AbstractIvmlSerializerConfigTests.assertFile(srcMainResources, "logback.xml");
        AbstractIvmlSerializerConfigTests.assertFileContains(base, "pom.xml", "transport.spring.amqp", "transport.amqp");
    }

    protected void assertAppInterfaces(File base, boolean old) throws IOException {
        File srcMain = new File(base, "src/main");
        File srcMainJava = new File(srcMain, "java");
        File srcMainJavaIip = new File(srcMainJava, "iip");
        this.assertJavaDatatype(srcMainJavaIip, "Rec1");
        this.assertJavaDatatype(srcMainJavaIip, "MyConnMachineIn");
        this.assertJavaDatatype(srcMainJavaIip, "MyConnMachineOut");
        this.assertJavaInterface(srcMainJavaIip, "MyAnonymizerExample", old, false);
        this.assertJavaInterface(srcMainJavaIip, "MyKiExample", old, false);
        this.assertJavaInterface(srcMainJavaIip, "MyMqttConnExample", old, true);
        this.assertJavaInterface(srcMainJavaIip, "MyOpcConnExample", old, true);
        this.assertJavaInterface(srcMainJavaIip, "MySourceExample", old, false);
    }
}

