/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.configuration.easyProducer;

import de.iip_ecosphere.platform.configuration.easyProducer.ConfigurationLifecycleDescriptor;
import de.iip_ecosphere.platform.configuration.easyProducer.ConfigurationSetup;
import de.iip_ecosphere.platform.configuration.easyProducer.EasyLogLevel;
import de.iip_ecosphere.platform.configuration.easyProducer.EasySetup;
import de.iip_ecosphere.platform.configuration.easyProducer.PlatformInstantiator;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.IvmlUtils;
import de.iip_ecosphere.platform.services.environment.YamlArtifact;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.LifecycleDescriptor;
import de.iip_ecosphere.platform.support.OsUtils;
import de.iip_ecosphere.platform.support.ZipUtils;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.varModel.confModel.Configuration;
import org.junit.Assert;
import test.de.iip_ecosphere.platform.configuration.easyProducer.PlatformInstantiatorTestMain;
import test.de.iip_ecosphere.platform.services.environment.PythonEnvironmentTest;

public abstract class AbstractIvmlTests {
    public static final File TEST_BASE_FOLDER = new File(EasySetup.getTestingEasyModelParent(), "target/gen/tests");
    public static final File MODEL_BASE_FOLDER = new File(EasySetup.getTestingEasyModelParent(), "src/test/easy");
    private static final Set<String> ASSERT_FILE_EXTENSIONS = new HashSet<String>();
    private static final Set<String> ASSERT_FILE_NAME_EXCLUSIONS = new HashSet<String>();
    private static Boolean isIipBuildInitial;
    private static File testModelBase;
    private static File testMetaModelFolder;

    protected static File relocateTestModel(File file) {
        return testModelBase == null ? file : new File(testModelBase, AbstractIvmlTests.stripTestingEasyModelParent(file));
    }

    public static String stripTestingEasyModelParent(File file) {
        String prefix;
        String f = file.getPath();
        if (f.startsWith(prefix = new File(EasySetup.getTestingEasyModelParent()).toString())) {
            f = f.substring(prefix.length());
        }
        return f;
    }

    public static void setTestModelBase(File base) {
        testModelBase = base;
    }

    public static void setTestMetaModelFolder(File folder) {
        testMetaModelFolder = folder;
    }

    protected static boolean isIipBuildInitial() {
        if (null == isIipBuildInitial) {
            boolean result;
            String tmp = OsUtils.getEnv((String)"iipbuildinitial");
            if (null == tmp) {
                tmp = "false";
            }
            if (result = Boolean.valueOf(System.getProperty("iip.build.initial", tmp)).booleanValue()) {
                System.out.println("Running in iip.build.initial mode, limiting to generateInterfaces");
            }
            isIipBuildInitial = result;
        }
        return isIipBuildInitial;
    }

    protected static ConfigurationLifecycleDescriptor assertLifecycleDescriptor() {
        ServiceLoader loader = ServiceLoaderUtils.load(LifecycleDescriptor.class);
        Optional<LifecycleDescriptor> first = ServiceLoaderUtils.stream((ServiceLoader)loader).filter(s -> s instanceof ConfigurationLifecycleDescriptor).findFirst();
        Assert.assertTrue((boolean)first.isPresent());
        ConfigurationLifecycleDescriptor lcd = (ConfigurationLifecycleDescriptor)first.get();
        Assert.assertNotNull((Object)lcd);
        return lcd;
    }

    protected void extractPythonServiceEnv(File srcMainPython) throws IOException {
        FileInputStream zip = new FileInputStream(new File(EasySetup.getTestingEasyModelParent(), "target/python/services.environment-python.zip"));
        ZipUtils.extractZip((InputStream)zip, (Path)srcMainPython.toPath());
        zip.close();
    }

    protected void pythonSourceCodeCheck(File srcMainPython, String pyFile) throws IOException {
        try {
            int res = PythonEnvironmentTest.createPythonProcess((File)srcMainPython, (String[])new String[]{"-m", "py_compile", pyFile}).waitFor();
            Assert.assertEquals((String)("Source code checking " + pyFile), (long)0L, (long)res);
        }
        catch (InterruptedException e) {
            Assert.fail((String)("Python code check shall not be interrupted: " + e.getMessage()));
        }
    }

    protected void assertDeploymentYaml(File base, String name) {
        if (!AbstractIvmlTests.isIipBuildInitial()) {
            AbstractIvmlTests.assertFile(base, name);
            File f = new File(base, name);
            try (FileInputStream in = new FileInputStream(f);){
                YamlArtifact.readFromYaml((InputStream)in);
                in.close();
            }
            catch (IOException e) {
                Assert.fail((String)(f.getAbsolutePath() + ":" + e.getMessage()));
            }
        }
    }

    protected void assertJavaInterface(File folder, String name, boolean old, boolean connector) {
        if (!connector) {
            String add = old ? "Service" : "Interface";
            AbstractIvmlTests.assertFile(new File(folder, "interfaces"), name + add + ".java");
        }
    }

    protected void assertJavaNode(File folder, String name, boolean connector) {
        AbstractIvmlTests.assertFile(new File(folder, "nodes"), name + ".java");
    }

    protected void assertJavaDatatype(File folder, String name) {
        this.assertDatatype(new File(folder, "datatypes"), new File(folder, "serializers"), name, "java");
    }

    protected void assertPythonDatatypeImpl(File folder, String name) {
        this.assertDatatype(new File(folder, "datatypes"), null, name, "py");
    }

    protected void assertPythonDatatype(File folder, String name) {
        this.assertDatatype(new File(folder, "datatypes"), new File(folder, "serializers"), name, "py");
    }

    private void assertDatatype(File typeFolder, File serFolder, String name, String extension) {
        AbstractIvmlTests.assertFile(typeFolder, name + "." + extension);
        if (null != serFolder) {
            AbstractIvmlTests.assertFile(serFolder, name + "Serializer." + extension);
        }
    }

    protected void assertEcsRuntime(File gen) throws IOException {
        File base = new File(gen, "ecsRuntime");
        File srcMain = new File(base, "src/main");
        File srcMainResources = new File(srcMain, "resources");
        AbstractIvmlTests.assertFile(srcMainResources, "iipecosphere.yml");
        AbstractIvmlTests.assertFile(srcMainResources, "logback.xml");
        AbstractIvmlTests.assertFileContains(base, "pom.xml", "ecsRuntime.docker", "transport.amqp", "support.aas.basyx");
        AbstractIvmlTests.assertFile(base, "src/main/resources/iipecosphere.yml");
    }

    protected void assertServiceManager(File gen) throws IOException {
        File base = new File(gen, "serviceMgr");
        File srcMain = new File(base, "src/main");
        File srcMainResources = new File(srcMain, "resources");
        AbstractIvmlTests.assertFile(srcMainResources, "iipecosphere.yml");
        AbstractIvmlTests.assertFile(srcMainResources, "logback.xml");
        AbstractIvmlTests.assertFileContains(base, "pom.xml", "services.spring", "transport.amqp", "support.aas.basyx");
        AbstractIvmlTests.assertFile(base, "src/main/resources/iipecosphere.yml");
    }

    protected void assertPlatform(File gen) throws IOException {
        File base = new File(gen, "platform");
        File srcMain = new File(base, "src/main");
        File srcMainResources = new File(srcMain, "resources");
        AbstractIvmlTests.assertFile(srcMainResources, "iipecosphere.yml");
        AbstractIvmlTests.assertFile(srcMainResources, "logback.xml");
        AbstractIvmlTests.assertFileContains(base, "pom.xml", "support.aas.basyx.server", "support.aas.basyx", "configuration.configuration", "transport.amqp");
        AbstractIvmlTests.assertFile(base, "src/main/resources/iipecosphere.yml");
    }

    protected static File assertFile(File base, String name) {
        return AbstractIvmlTests.assertFile(new File(base, name));
    }

    protected static File assertTemplateZip(File gen, String name) {
        File f = new File(gen, "templates/eclipse/" + name + ".zip");
        return AbstractIvmlTests.assertFile(f);
    }

    private static File assertFile(File file) {
        if (!AbstractIvmlTests.isIipBuildInitial()) {
            Assert.assertTrue((String)("File " + String.valueOf(file) + " does not exist"), (boolean)file.exists());
            Assert.assertTrue((String)("File " + String.valueOf(file) + " is empty"), (file.length() > 0L ? 1 : 0) != 0);
        }
        return file;
    }

    protected static final void assertAllFiles(File folder) {
        File[] files = folder.listFiles();
        if (null != files) {
            for (File f : files) {
                if (f.isDirectory()) {
                    AbstractIvmlTests.assertAllFiles(f);
                    continue;
                }
                String name = f.getName();
                int pos = name.lastIndexOf(46);
                String extension = "";
                if (pos > 0) {
                    extension = name.substring(pos);
                }
                if (!ASSERT_FILE_EXTENSIONS.contains(extension) || ASSERT_FILE_NAME_EXCLUSIONS.contains(name)) continue;
                try {
                    Assert.assertTrue((String)("File " + String.valueOf(f) + " is empty"), (FileUtils.readFileToString((File)f, (Charset)Charset.defaultCharset()).trim().length() > 0 ? 1 : 0) != 0);
                }
                catch (IOException e) {
                    Assert.fail((String)("Cannot read " + String.valueOf(f) + ": " + e.getMessage()));
                }
            }
        }
    }

    protected static void assertFileContains(File base, String name, String ... search) throws IOException {
        if (!AbstractIvmlTests.isIipBuildInitial()) {
            File f = AbstractIvmlTests.assertFile(base, name);
            String contents = FileUtils.readFileToString((File)f, (Charset)Charset.defaultCharset());
            for (String s : search) {
                Assert.assertTrue((String)("File " + String.valueOf(f) + " must contain '" + s + "'"), (boolean)contents.contains(s));
            }
        }
    }

    public static PlatformInstantiator.InstantiationConfigurer genApi(PlatformInstantiator.InstantiationConfigurer cfg) {
        return cfg.setStartRuleName("generateApi");
    }

    public static PlatformInstantiator.InstantiationConfigurer genApps(PlatformInstantiator.InstantiationConfigurer cfg) {
        return cfg.setStartRuleName("generateApps");
    }

    public static PlatformInstantiator.InstantiationConfigurer genAppsNoDeps(PlatformInstantiator.InstantiationConfigurer cfg) {
        return cfg.setStartRuleName("generateAppsNoDeps");
    }

    public static PlatformInstantiator.InstantiationConfigurer setTracing(PlatformInstantiator.InstantiationConfigurer cfg, String level) {
        return cfg.setProperty("iip.easy.tracing", level);
    }

    static {
        testModelBase = null;
        ASSERT_FILE_EXTENSIONS.add(".java");
        ASSERT_FILE_EXTENSIONS.add(".py");
        ASSERT_FILE_EXTENSIONS.add(".yml");
        ASSERT_FILE_EXTENSIONS.add(".xml");
        ASSERT_FILE_NAME_EXCLUSIONS.add("__init__.py");
        File f = new File("resources.ipr");
        if (!f.exists()) {
            f = new File("resources");
        }
        System.setProperty("iip.resources", f.getAbsolutePath());
        PlatformInstantiator.setTraceFilter();
    }

    public static class TestConfigurer
    extends PlatformInstantiator.InstantiationConfigurer {
        private File ivmlMetaModelFolder = null;
        private List<File> additionalIvmlFolders = null;
        private boolean exit = false;

        public TestConfigurer(String ivmlModelName, File modelFolder, File outputFolder) {
            super(ivmlModelName, AbstractIvmlTests.relocateTestModel(modelFolder), outputFolder);
            if (AbstractIvmlTests.isIipBuildInitial()) {
                super.setStartRuleName("generateInterfaces");
            }
            Object srcName = null == testMetaModelFolder ? EasySetup.getTestingEasyModelParent() + "/src/main/easy" : testMetaModelFolder.getPath();
            String srcCfgName = ((String)srcName + "/cfg/").replace('/', File.separatorChar);
            File src = new File((String)srcName);
            File tgt = new File(EasySetup.getTestingEasyModelParent(), "target/ivml");
            try {
                FileUtils.deleteDirectory((File)tgt);
                tgt.mkdirs();
                FileUtils.copyDirectory((File)src, (File)tgt, f -> !f.toString().startsWith(srcCfgName), (boolean)true);
                this.ivmlMetaModelFolder = tgt;
            }
            catch (IOException e) {
                Assert.fail((String)("Cannot copy IVML meta model from " + String.valueOf(src) + " to " + String.valueOf(tgt) + ": " + e.getClass().getSimpleName() + " " + e.getMessage()));
            }
            File commonIvml = AbstractIvmlTests.relocateTestModel(new File(modelFolder.getParentFile(), "common"));
            if (commonIvml.exists()) {
                this.additionalIvmlFolders = new ArrayList<File>();
                this.additionalIvmlFolders.add(commonIvml);
            }
        }

        public TestConfigurer(String[] args) {
            super(args);
            this.exit = true;
            int last = super.getLastArgsIndex(args);
            if (args.length > last) {
                this.ivmlMetaModelFolder = this.fromArg(args[last + 1]);
                if (args.length > last + 1) {
                    this.additionalIvmlFolders = new ArrayList<File>();
                    for (int i = last + 2; i < args.length; ++i) {
                        this.additionalIvmlFolders.add(this.fromArg(args[i]));
                    }
                }
            }
        }

        public String getMainClass() {
            return this.exit ? super.getMainClass() : PlatformInstantiatorTestMain.class.getName();
        }

        public boolean inTesting() {
            return true;
        }

        public String[] toArgs(boolean all) {
            String[] tmp = super.toArgs(all);
            String[] result = new String[tmp.length + 1 + (this.additionalIvmlFolders == null ? 0 : this.additionalIvmlFolders.size())];
            System.arraycopy(tmp, 0, result, 0, tmp.length);
            result[tmp.length] = this.toArg(this.ivmlMetaModelFolder);
            if (null != this.additionalIvmlFolders) {
                for (int i = 0; i < this.additionalIvmlFolders.size(); ++i) {
                    result[tmp.length + 1 + i] = this.toArg(this.additionalIvmlFolders.get(i));
                }
            }
            return result;
        }

        public PlatformInstantiator.InstantiationConfigurer setStartRuleName(String startRuleName) {
            if (!AbstractIvmlTests.isIipBuildInitial()) {
                super.setStartRuleName(startRuleName);
            }
            return this;
        }

        public ConfigurationLifecycleDescriptor obtainLifecycleDescriptor() {
            return AbstractIvmlTests.assertLifecycleDescriptor();
        }

        protected void validateConfiguration(Configuration conf) throws ExecutionException {
            if (this.exit) {
                if (null == conf) {
                    System.exit(-1);
                }
            } else {
                Assert.assertNotNull((Object)conf);
            }
        }

        protected void validateReasoningResult(ReasoningResult res) throws ExecutionException {
            boolean hasConflict = IvmlUtils.analyzeReasoningResult((ReasoningResult)res, (boolean)this.isEmitReasonerWarnings(), (boolean)true);
            if (this.exit) {
                if (hasConflict) {
                    System.exit(-2);
                }
            } else {
                Assert.assertFalse((boolean)hasConflict);
            }
        }

        protected void handleExecutionException(ExecutionException ex) throws ExecutionException {
            throw ex;
        }

        public void configure(ConfigurationSetup setup) {
            EasySetup easySetup = setup.getEasyProducer();
            if (null != this.ivmlMetaModelFolder) {
                easySetup.setIvmlMetaModelFolder(this.ivmlMetaModelFolder);
            }
            if (null != this.additionalIvmlFolders) {
                easySetup.setAdditionalIvmlFolders(this.additionalIvmlFolders);
            }
            super.configure(setup);
            easySetup.setLogLevel(EasyLogLevel.VERBOSE);
        }

        public TestConfigurer setProperty(String key, String value) {
            super.setProperty(key, value);
            return this;
        }

        public File getIvmlMetaModelFolder() {
            return this.ivmlMetaModelFolder;
        }

        public List<File> getAdditionalIvmlFolders() {
            return null != this.additionalIvmlFolders ? new ArrayList<File>(this.additionalIvmlFolders) : null;
        }
    }
}

