/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.cfg;

import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.status.ActionTypes;
import de.iip_ecosphere.platform.transport.status.ComponentTypes;
import de.iip_ecosphere.platform.transport.status.StatusMessage;
import java.io.IOException;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class StatusCache {
    private static Map<String, Map<String, String>> serviceStates = Collections.synchronizedMap(new HashMap());
    private static ReceptionCallback<StatusMessage> statusCallback = new ReceptionCallback<StatusMessage>(){

        public void received(StatusMessage data) {
            if (ComponentTypes.SERVICE == data.getComponentType()) {
                StatusCache.handleServiceStateChange(data);
            }
        }

        public Class<StatusMessage> getType() {
            return StatusMessage.class;
        }
    };

    private static Map<String, String> ensureServicePerDevice(StatusMessage message) {
        Map<String, String> servicePerDevice = serviceStates.get(message.getId());
        if (null == servicePerDevice) {
            servicePerDevice = new HashMap<String, String>();
            serviceStates.put(message.getId(), servicePerDevice);
        }
        return servicePerDevice;
    }

    private static void handleServiceStateChange(StatusMessage message) {
        Map<String, String> servicePerDevice;
        if (ActionTypes.ADDED == message.getAction()) {
            StatusCache.ensureServicePerDevice(message).put(message.getDeviceId(), message.getDescription());
        } else if (ActionTypes.CHANGED == message.getAction()) {
            StatusCache.ensureServicePerDevice(message).put(message.getDeviceId(), message.getDescription());
        } else if (ActionTypes.REMOVED == message.getAction() && null != (servicePerDevice = serviceStates.get(message.getId()))) {
            servicePerDevice.remove(message.getDeviceId());
            if (servicePerDevice.isEmpty()) {
                serviceStates.remove(message.getId());
            }
        }
    }

    public static void getServiceStates(String sId, Consumer<ServiceDeviceState> consumer) {
        Map<String, String> servicePerDevice = serviceStates.get(sId);
        if (null != servicePerDevice) {
            try {
                for (Map.Entry<String, String> e : servicePerDevice.entrySet()) {
                    consumer.accept(new ServiceDeviceState(e.getKey(), e.getValue()));
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
    }

    public static void start() {
        TransportConnector conn = Transport.getConnector();
        if (null != conn) {
            try {
                conn.setReceptionCallback("ComponentStatus", statusCallback);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(StatusCache.class).warn("While attaching StatusCache: {}", (Object)e.getMessage());
            }
        } else {
            LoggerFactory.getLogger(StatusCache.class).warn("No transport connector. Cannot attach StatusCache. No status updates for UI");
        }
    }

    public static void stop() {
        TransportConnector conn = Transport.getConnector();
        if (null != conn) {
            try {
                conn.detachReceptionCallback("ComponentStatus", statusCallback);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(StatusCache.class).warn("While detaching StatusCache: {}", (Object)e.getMessage());
            }
        }
    }

    public static class ServiceDeviceState {
        private String deviceId;
        private String state;

        private ServiceDeviceState(String deviceId, String state) {
            this.deviceId = deviceId;
            this.state = state;
        }

        public String getDeviceId() {
            return this.deviceId;
        }

        public String getState() {
            return this.state;
        }
    }
}

