/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors.modbustcpipv1;

import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorDescriptor;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.modbustcpipv1.ModbusItem;
import de.iip_ecosphere.platform.connectors.modbustcpipv1.ModbusTcpIpConnector;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.IOException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import test.de.iip_ecosphere.platform.connectors.modbustcpipv1.AbstractModbusTcpIpConnectorTest;
import test.de.iip_ecosphere.platform.connectors.modbustcpipv1.ModbusCommandC;
import test.de.iip_ecosphere.platform.connectors.modbustcpipv1.ModbusDataC;
import test.de.iip_ecosphere.platform.connectors.modbustcpipv1.TestServer;

public class ModbusTcpIpConnectorTest
extends AbstractModbusTcpIpConnectorTest {
    private static TestServer testServer;
    private static final Logger LOGGER;

    @BeforeClass
    public static void init() {
        testServer = new TestServer(false);
        testServer.start();
        LOGGER.info("MODBUS TCP/IP server started at " + testServer.getHost() + ":" + testServer.getPort());
    }

    @AfterClass
    public static void shutdown() {
        testServer.stop();
        LOGGER.info("MODBUS TCP/IP server stopped");
    }

    @Test
    public void testWithPolling() throws IOException {
        this.testConnector(false);
    }

    @Override
    protected Class<? extends ConnectorDescriptor> getConnectorDescriptor() {
        return ModbusTcpIpConnector.Descriptor.class;
    }

    @Override
    protected ConnectorParameter getConnectorParameter() {
        Endpoint registryEndpoint = new Endpoint(Schema.TCP, testServer.getHost(), testServer.getPort(), "");
        ConnectorParameter.ConnectorParameterBuilder testParameter = ConnectorParameter.ConnectorParameterBuilder.newBuilder((ServerAddress)registryEndpoint);
        testParameter.setApplicationInformation("App_Id", "App_Description");
        testParameter.setEndpointPath(String.valueOf(registryEndpoint.getSchema()) + ":" + registryEndpoint.getEndpoint());
        String serverStructure = testServer.getServerStructure();
        testParameter.setSpecificSetting("SERVER_STRUCTURE", (Object)serverStructure);
        return testParameter.build();
    }

    @Override
    protected Connector<ModbusItem, Object, ModbusDataC, ModbusCommandC> createConnector(ProtocolAdapter<ModbusItem, Object, ModbusDataC, ModbusCommandC> adapter) {
        return new ModbusTcpIpConnector(new ProtocolAdapter[]{adapter});
    }

    public static TestServer getTestServer() {
        return testServer;
    }

    static {
        LOGGER = LoggerFactory.getLogger(ModbusTcpIpConnectorTest.class);
    }
}

