/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.modbustcpipv1;

import com.ghgande.j2mod.modbus.ModbusException;
import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.ModbusSlaveException;
import com.ghgande.j2mod.modbus.io.ModbusTCPTransaction;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ReadMultipleRegistersRequest;
import com.ghgande.j2mod.modbus.msg.ReadMultipleRegistersResponse;
import com.ghgande.j2mod.modbus.msg.WriteMultipleRegistersRequest;
import com.ghgande.j2mod.modbus.net.TCPMasterConnection;
import com.ghgande.j2mod.modbus.procimg.Register;
import com.ghgande.j2mod.modbus.procimg.SimpleRegister;
import de.iip_ecosphere.platform.connectors.AbstractConnector;
import de.iip_ecosphere.platform.connectors.AbstractPluginConnectorDescriptor;
import de.iip_ecosphere.platform.connectors.AdapterSelector;
import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.MachineConnector;
import de.iip_ecosphere.platform.connectors.events.ConnectorTriggerQuery;
import de.iip_ecosphere.platform.connectors.modbustcpipv1.ModbusItem;
import de.iip_ecosphere.platform.connectors.modbustcpipv1.ModbusMap;
import de.iip_ecosphere.platform.connectors.modbustcpipv1.ModbusTcpIpInputConverter;
import de.iip_ecosphere.platform.connectors.modbustcpipv1.ModbusTcpIpOutputConverter;
import de.iip_ecosphere.platform.connectors.modbustcpipv1.ModbusVarItem;
import de.iip_ecosphere.platform.connectors.model.AbstractModelAccess;
import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.model.ModelInputConverter;
import de.iip_ecosphere.platform.connectors.model.ModelOutputConverter;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

@MachineConnector(hasModel=true, supportsModelStructs=false, supportsEvents=false, specificSettings={"SERVER_STRUCTURE", "UNITID", "TIMEOUT", "BIGBYTE"})
public class ModbusTcpIpConnector<CO, CI>
extends AbstractConnector<ModbusItem, Object, CO, CI> {
    public static final String NAME = "MODBUS TCP/IP";
    private static final Logger LOGGER = LoggerFactory.getLogger(ModbusTcpIpConnector.class);
    private ModbusMap map = null;
    private ModbusItem item;
    private TCPMasterConnection connection;
    private ConnectorParameter params;
    private AtomicBoolean inPolling = new AtomicBoolean(false);
    private int timeout = 1000;
    private boolean bigByte = true;
    private int unitId = 1;

    @SafeVarargs
    public ModbusTcpIpConnector(ProtocolAdapter<ModbusItem, Object, CO, CI> ... adapter) {
        this((AdapterSelector<ModbusItem, Object, CO, CI>)null, adapter);
    }

    @SafeVarargs
    public ModbusTcpIpConnector(AdapterSelector<ModbusItem, Object, CO, CI> selector, ProtocolAdapter<ModbusItem, Object, CO, CI> ... adapter) {
        super(selector, adapter);
        this.configureModelAccess((ModelAccess)new ModbusTcpIpModelAccess());
    }

    public String getName() {
        return NAME;
    }

    private String getEndpointUrl(ConnectorParameter params) {
        String result = params.getHost() + ":" + params.getPort();
        return result;
    }

    protected void connectImpl(ConnectorParameter params) throws IOException {
        if (this.connection == null) {
            this.params = params;
            this.setModbusMap();
            this.item = new ModbusItem(this.map);
            System.out.println("Map:" + String.valueOf(this.map));
            System.out.println("Item:" + String.valueOf(this.item));
            String endpointURL = this.getEndpointUrl(params);
            this.connection = new TCPMasterConnection(InetAddress.getByName(params.getHost()));
            this.connection.setPort(params.getPort());
            this.connection.setTimeout(this.timeout);
            try {
                this.connection.connect();
                LOGGER.info("MODBUS TCP/IP connecting to " + endpointURL);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.info("MODBUS TCP/IP connection failed: {}");
            }
        }
    }

    private void setModbusMap() {
        Set keys = this.params.getSpecificSettingKeys();
        for (String key : keys) {
            Object serverSettings = this.params.getSpecificSetting(key);
            if (key.equals("SERVER_STRUCTURE")) {
                this.map = (ModbusMap)JsonUtils.fromJson((Object)serverSettings, ModbusMap.class);
                continue;
            }
            if (key.equals("BIGBYTE")) {
                this.bigByte = (Boolean)serverSettings;
                continue;
            }
            if (key.equals("UNITID")) {
                this.unitId = (Integer)serverSettings;
                continue;
            }
            if (!key.equals("TIMEOUT")) continue;
            this.timeout = (Integer)serverSettings;
        }
        if (this.map == null) {
            System.out.println("ModbusTcpIpConnector -> No SERVER_STRUCTURE found");
        }
    }

    public ModbusMap getMap() {
        return this.map;
    }

    protected void doPolling() {
        if (!this.inPolling.getAndSet(true)) {
            try {
                ModbusItem data = this.read();
                this.received("", data);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.inPolling.set(false);
        }
    }

    protected void disconnectImpl() throws IOException {
        this.connection = null;
    }

    protected void error(String arg0, Throwable arg1) {
        LOGGER.error(arg0, arg1);
    }

    protected ModbusItem read() throws IOException {
        for (Map.Entry entry : this.map.entrySet()) {
            ModbusVarItem varItem = (ModbusVarItem)entry.getValue();
            try {
                ReadMultipleRegistersRequest request = new ReadMultipleRegistersRequest(varItem.getOffset(), varItem.getTypeRegisterSize());
                request.setUnitID(this.unitId);
                ModbusTCPTransaction lTransaction = new ModbusTCPTransaction(this.connection);
                lTransaction.setRequest((ModbusRequest)request);
                lTransaction.execute();
                ReadMultipleRegistersResponse lResponse = (ReadMultipleRegistersResponse)lTransaction.getResponse();
                if (varItem.getType().equals("short")) {
                    this.item.setRegister(varItem.getOffset(), lResponse.getRegisters()[0].toShort());
                    continue;
                }
                if (varItem.getType().equals("ushort")) {
                    this.item.setRegister(varItem.getOffset(), lResponse.getRegisters()[0].toUnsignedShort());
                    continue;
                }
                if (varItem.getType().equals("integer")) {
                    this.item.setRegister(varItem.getOffset(), this.getIntegerFromRegisters(lResponse.getRegisters()));
                    continue;
                }
                if (varItem.getType().equals("uinteger")) {
                    this.item.setRegister(varItem.getOffset(), this.getUnsignedIntegerFromRegisters(lResponse.getRegisters()));
                    continue;
                }
                if (varItem.getType().equals("long")) {
                    this.item.setRegister(varItem.getOffset(), this.getLongFromRegisters(lResponse.getRegisters()));
                    continue;
                }
                if (varItem.getType().equals("ulong")) {
                    this.item.setRegister(varItem.getOffset(), this.getUnsignedLongFromRegisters(lResponse.getRegisters()));
                    continue;
                }
                if (varItem.getType().equals("float")) {
                    this.item.setRegister(varItem.getOffset(), Float.valueOf(this.getFloatFromRegisters(lResponse.getRegisters())));
                    continue;
                }
                if (varItem.getType().equals("double")) {
                    this.item.setRegister(varItem.getOffset(), this.getDoubleFromRegisters(lResponse.getRegisters()));
                    continue;
                }
                if (varItem.getType().equals("ascii")) {
                    this.item.setRegister(varItem.getOffset(), this.getStringFromRegisters(lResponse.getRegisters()));
                    continue;
                }
                if (!varItem.getType().equals("datetime")) continue;
                this.item.setRegister(varItem.getOffset(), this.getDatetimeFromRegisters(lResponse.getRegisters()));
            }
            catch (ModbusIOException e) {
                e.printStackTrace();
            }
            catch (ModbusSlaveException e) {
                e.printStackTrace();
            }
            catch (ModbusException e) {
                e.printStackTrace();
            }
        }
        return this.item;
    }

    private int getIntegerFromRegisters(Register[] registers) {
        short highShort;
        short lowShort;
        if (this.bigByte) {
            lowShort = registers[0].toShort();
            highShort = registers[1].toShort();
        } else {
            highShort = registers[0].toShort();
            lowShort = registers[1].toShort();
        }
        int result = (highShort & 0xFFFF) << 16 | lowShort & 0xFFFF;
        return result;
    }

    private long getUnsignedIntegerFromRegisters(Register[] registers) {
        short highShort;
        short lowShort;
        if (this.bigByte) {
            lowShort = registers[0].toShort();
            highShort = registers[1].toShort();
        } else {
            highShort = registers[0].toShort();
            lowShort = registers[1].toShort();
        }
        int lowInt = lowShort & 0xFFFF;
        int highInt = highShort & 0xFFFF;
        long result = (long)highInt << 16 | (long)lowInt;
        return result;
    }

    private float getFloatFromRegisters(Register[] registers) {
        short highShort;
        short lowShort;
        if (this.bigByte) {
            lowShort = registers[0].toShort();
            highShort = registers[1].toShort();
        } else {
            highShort = registers[0].toShort();
            lowShort = registers[1].toShort();
        }
        int intRes = (lowShort & 0xFFFF) << 16 | highShort & 0xFFFF;
        Float result = Float.valueOf(Float.intBitsToFloat(intRes));
        return result.floatValue();
    }

    private long getLongFromRegisters(Register[] registers) {
        short highestShort;
        short highShort;
        short lowShort;
        short lowestShort;
        if (this.bigByte) {
            lowestShort = registers[0].toShort();
            lowShort = registers[1].toShort();
            highShort = registers[2].toShort();
            highestShort = registers[3].toShort();
        } else {
            highestShort = registers[0].toShort();
            highShort = registers[1].toShort();
            lowShort = registers[2].toShort();
            lowestShort = registers[3].toShort();
        }
        Long result = (long)highestShort << 48 | (long)highShort << 32 | (long)lowShort << 16 | (long)lowestShort;
        return result;
    }

    private BigInteger getUnsignedLongFromRegisters(Register[] registers) {
        short highestShort;
        short highShort;
        short lowShort;
        short lowestShort;
        if (this.bigByte) {
            lowestShort = registers[0].toShort();
            lowShort = registers[1].toShort();
            highShort = registers[2].toShort();
            highestShort = registers[3].toShort();
        } else {
            highestShort = registers[0].toShort();
            highShort = registers[1].toShort();
            lowShort = registers[2].toShort();
            lowestShort = registers[3].toShort();
        }
        long lowestLong = (long)lowestShort & 0xFFFFL;
        long lowLong = (long)lowShort & 0xFFFFL;
        long highLong = (long)highShort & 0xFFFFL;
        long highestLong = (long)highestShort & 0xFFFFL;
        BigInteger result = BigInteger.valueOf(highestLong).shiftLeft(48).or(BigInteger.valueOf(highLong).shiftLeft(32)).or(BigInteger.valueOf(lowLong).shiftLeft(16)).or(BigInteger.valueOf(lowestLong));
        return result;
    }

    private double getDoubleFromRegisters(Register[] registers) {
        short highestShort;
        short highShort;
        short lowShort;
        short lowestShort;
        if (this.bigByte) {
            lowestShort = registers[0].toShort();
            lowShort = registers[1].toShort();
            highShort = registers[2].toShort();
            highestShort = registers[3].toShort();
        } else {
            highestShort = registers[0].toShort();
            highShort = registers[1].toShort();
            lowShort = registers[2].toShort();
            lowestShort = registers[3].toShort();
        }
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putShort(0, lowestShort);
        buffer.putShort(2, lowShort);
        buffer.putShort(4, highShort);
        buffer.putShort(6, highestShort);
        buffer.rewind();
        Double result = buffer.getDouble();
        return result;
    }

    private String getStringFromRegisters(Register[] registers) {
        ByteBuffer buffer = ByteBuffer.allocate(registers.length * 2);
        for (Register reg : registers) {
            buffer.put((byte)(reg.toShort() >> 8));
            buffer.put((byte)(reg.toShort() & 0xFF));
        }
        return new String(buffer.array(), StandardCharsets.US_ASCII).trim();
    }

    private LocalDateTime getDatetimeFromRegisters(Register[] registers) {
        long timePart1 = (long)registers[0].toShort() << 48 | (long)registers[1].toShort() << 32;
        long timePart2 = (long)registers[2].toShort() << 16 | (long)(registers[3].toShort() & 0xFFFF);
        long timestamp = timePart1 | timePart2;
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneOffset.UTC);
    }

    public void trigger(ConnectorTriggerQuery query) {
    }

    protected void writeImpl(Object data) throws IOException {
        if (data != null) {
            ModbusVarItem varItem = (ModbusVarItem)data;
            Object varItemValue = this.item.getRegister(varItem.getOffset());
            Register[] lHoldingRegisters = this.registers(varItem, varItemValue);
            try {
                WriteMultipleRegistersRequest request = new WriteMultipleRegistersRequest(varItem.getOffset(), lHoldingRegisters);
                ModbusTCPTransaction lTransaction = new ModbusTCPTransaction(this.connection);
                lTransaction.setRequest((ModbusRequest)request);
                lTransaction.execute();
            }
            catch (ModbusIOException e) {
                e.printStackTrace();
            }
            catch (ModbusSlaveException e) {
                e.printStackTrace();
            }
            catch (ModbusException e) {
                e.printStackTrace();
            }
        }
    }

    private Register[] registers(ModbusVarItem varItem, Object varItemValue) {
        Register[] holdingRegisters = new Register[varItem.getTypeRegisterSize()];
        if (varItem.getType().equals("short")) {
            holdingRegisters[0] = new SimpleRegister((int)((Short)varItemValue).shortValue());
        } else if (varItem.getType().equals("ushort")) {
            holdingRegisters[0] = new SimpleRegister((Integer)varItemValue & 0xFFFF);
        } else if (varItem.getType().equals("integer")) {
            holdingRegisters = this.getIntegerAsRegisters(varItem);
        } else if (varItem.getType().equals("uinteger")) {
            holdingRegisters = this.getUnsignedIntegerAsRegisters(varItem);
        } else if (varItem.getType().equals("float")) {
            holdingRegisters = this.getFloatAsRegisters(varItem);
        } else if (varItem.getType().equals("long")) {
            holdingRegisters = this.getLongAsRegisters(varItem);
        } else if (varItem.getType().equals("ulong")) {
            holdingRegisters = this.getUnsignedLongAsRegisters(varItem);
        } else if (varItem.getType().equals("double")) {
            holdingRegisters = this.getDoubleAsRegisters(varItem);
        } else if (varItem.getType().equals("ascii")) {
            holdingRegisters = this.getStringAsRegisters(varItem);
        } else if (varItem.getType().equals("datetime")) {
            holdingRegisters = this.getDatetimeAsRegisters(varItem);
        }
        return holdingRegisters;
    }

    private Register[] getIntegerAsRegisters(ModbusVarItem varItem) {
        short highShort;
        short lowShort;
        Register[] reg = new Register[varItem.getTypeRegisterSize()];
        int value = (Integer)this.item.getRegister(varItem.getOffset());
        if (this.bigByte) {
            lowShort = (short)(value & 0xFFFF);
            highShort = (short)(value >> 16);
        } else {
            highShort = (short)(value & 0xFFFF);
            lowShort = (short)(value >> 16);
        }
        reg[0] = new SimpleRegister((int)lowShort);
        reg[1] = new SimpleRegister((int)highShort);
        return reg;
    }

    private Register[] getUnsignedIntegerAsRegisters(ModbusVarItem varItem) {
        short highShort;
        short lowShort;
        Register[] reg = new Register[varItem.getTypeRegisterSize()];
        long value = (Long)this.item.getRegister(varItem.getOffset());
        if (this.bigByte) {
            lowShort = (short)(value & 0xFFFFL);
            highShort = (short)(value >> 16);
        } else {
            highShort = (short)(value & 0xFFFFL);
            lowShort = (short)(value >> 16);
        }
        reg[0] = new SimpleRegister((int)lowShort);
        reg[1] = new SimpleRegister((int)highShort);
        return reg;
    }

    private Register[] getFloatAsRegisters(ModbusVarItem varItem) {
        short highShort;
        short lowShort;
        Register[] reg = new Register[varItem.getTypeRegisterSize()];
        float value = ((Float)this.item.getRegister(varItem.getOffset())).floatValue();
        int floatAsInt = Float.floatToIntBits(value);
        if (this.bigByte) {
            lowShort = (short)(floatAsInt >> 16 & 0xFFFF);
            highShort = (short)(floatAsInt & 0xFFFF);
        } else {
            highShort = (short)(floatAsInt >> 16 & 0xFFFF);
            lowShort = (short)(floatAsInt & 0xFFFF);
        }
        reg[0] = new SimpleRegister((int)lowShort);
        reg[1] = new SimpleRegister((int)highShort);
        return reg;
    }

    private Register[] getLongAsRegisters(ModbusVarItem varItem) {
        short highestShort;
        short highShort;
        short lowShort;
        short lowestShort;
        Register[] reg = new Register[varItem.getTypeRegisterSize()];
        long value = (Long)this.item.getRegister(varItem.getOffset());
        if (this.bigByte) {
            lowestShort = (short)(value & 0xFFFFL);
            lowShort = (short)(value >> 16 & 0xFFFFL);
            highShort = (short)(value >> 32 & 0xFFFFL);
            highestShort = (short)(value >> 48 & 0xFFFFL);
        } else {
            highestShort = (short)(value & 0xFFFFL);
            highShort = (short)(value >> 16 & 0xFFFFL);
            lowShort = (short)(value >> 32 & 0xFFFFL);
            lowestShort = (short)(value >> 48 & 0xFFFFL);
        }
        reg[0] = new SimpleRegister((int)lowestShort);
        reg[1] = new SimpleRegister((int)lowShort);
        reg[2] = new SimpleRegister((int)highShort);
        reg[3] = new SimpleRegister((int)highestShort);
        return reg;
    }

    private Register[] getUnsignedLongAsRegisters(ModbusVarItem varItem) {
        Register[] reg = new Register[varItem.getTypeRegisterSize()];
        BigInteger value = (BigInteger)this.item.getRegister(varItem.getOffset());
        byte[] bytes = value.toByteArray();
        byte[] fullBytes = new byte[8];
        int start = Math.max(0, bytes.length - 8);
        int length = Math.min(8, bytes.length);
        System.arraycopy(bytes, start, fullBytes, 8 - length, length);
        if (this.bigByte) {
            reg[3] = new SimpleRegister((int)((short)((fullBytes[0] & 0xFF) << 8 | fullBytes[1] & 0xFF)));
            reg[2] = new SimpleRegister((int)((short)((fullBytes[2] & 0xFF) << 8 | fullBytes[3] & 0xFF)));
            reg[1] = new SimpleRegister((int)((short)((fullBytes[4] & 0xFF) << 8 | fullBytes[5] & 0xFF)));
            reg[0] = new SimpleRegister((int)((short)((fullBytes[6] & 0xFF) << 8 | fullBytes[7] & 0xFF)));
        } else {
            reg[0] = new SimpleRegister((int)((short)((fullBytes[0] & 0xFF) << 8 | fullBytes[1] & 0xFF)));
            reg[1] = new SimpleRegister((int)((short)((fullBytes[2] & 0xFF) << 8 | fullBytes[3] & 0xFF)));
            reg[2] = new SimpleRegister((int)((short)((fullBytes[4] & 0xFF) << 8 | fullBytes[5] & 0xFF)));
            reg[3] = new SimpleRegister((int)((short)((fullBytes[6] & 0xFF) << 8 | fullBytes[7] & 0xFF)));
        }
        return reg;
    }

    private Register[] getDoubleAsRegisters(ModbusVarItem varItem) {
        short highestShort;
        short highShort;
        short lowShort;
        short lowestShort;
        Register[] reg = new Register[varItem.getTypeRegisterSize()];
        double value = (Double)this.item.getRegister(varItem.getOffset());
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putDouble(value);
        if (this.bigByte) {
            lowestShort = buffer.getShort(0);
            lowShort = buffer.getShort(2);
            highShort = buffer.getShort(4);
            highestShort = buffer.getShort(6);
        } else {
            lowestShort = buffer.getShort(6);
            lowShort = buffer.getShort(4);
            highShort = buffer.getShort(2);
            highestShort = buffer.getShort(0);
        }
        reg[0] = new SimpleRegister((int)lowestShort);
        reg[1] = new SimpleRegister((int)lowShort);
        reg[2] = new SimpleRegister((int)highShort);
        reg[3] = new SimpleRegister((int)highestShort);
        return reg;
    }

    private Register[] getStringAsRegisters(ModbusVarItem varItem) {
        Register[] reg = new Register[varItem.getTypeRegisterSize()];
        String value = (String)this.item.getRegister(varItem.getOffset());
        byte[] bytes = value.getBytes();
        for (int i = 0; i < bytes.length; i += 2) {
            int lowByte = i + 1 < bytes.length ? bytes[i + 1] & 0xFF : 0;
            int highByte = bytes[i] & 0xFF;
            reg[i / 2] = new SimpleRegister((int)((short)(highByte << 8 | lowByte)));
        }
        return reg;
    }

    private Register[] getDatetimeAsRegisters(ModbusVarItem varItem) {
        Register[] reg = new Register[varItem.getTypeRegisterSize()];
        LocalDateTime datetime = (LocalDateTime)this.item.getRegister(varItem.getOffset());
        long timestamp = datetime.toInstant(ZoneOffset.UTC).toEpochMilli();
        reg[0] = new SimpleRegister((int)((short)(timestamp >> 48)));
        reg[1] = new SimpleRegister((int)((short)(timestamp >> 32)));
        reg[2] = new SimpleRegister((int)((short)(timestamp >> 16)));
        reg[3] = new SimpleRegister((int)((short)(timestamp & 0xFFFFL)));
        return reg;
    }

    public String supportedEncryption() {
        return null;
    }

    public String enabledEncryption() {
        return null;
    }

    protected class ModbusTcpIpModelAccess
    extends AbstractModelAccess {
        private ModbusTcpIpInputConverter inputConverter;
        private ModbusTcpIpOutputConverter outputConverter;

        protected ModbusTcpIpModelAccess() {
            super((AbstractModelAccess.NotificationChangedListener)ModbusTcpIpConnector.this);
            this.inputConverter = new ModbusTcpIpInputConverter();
            this.outputConverter = new ModbusTcpIpOutputConverter();
        }

        public ModelInputConverter getInputConverter() {
            return this.inputConverter;
        }

        public ModelOutputConverter getOutputConverter() {
            return this.outputConverter;
        }

        public void set(String qName, Object arg1) throws IOException {
            ModbusVarItem varItem = (ModbusVarItem)ModbusTcpIpConnector.this.map.get(qName);
            ModbusTcpIpConnector.this.item.setRegister(varItem.getOffset(), arg1);
            ModbusTcpIpConnector.this.writeImpl(varItem);
            ModbusTcpIpConnector.this.doPolling();
        }

        public Object get(String qName) throws IOException {
            Object result = new Object();
            ModbusVarItem varItem = (ModbusVarItem)ModbusTcpIpConnector.this.map.get(qName);
            result = ModbusTcpIpConnector.this.item.getRegister(varItem.getOffset());
            return result;
        }

        public Object call(String qName, Object ... arg1) throws IOException {
            return null;
        }

        public String getQSeparator() {
            return null;
        }

        public <T> T getStruct(String arg0, Class<T> arg1) throws IOException {
            return null;
        }

        public void monitor(String ... qName) throws IOException {
        }

        public void registerCustomType(Class<?> cls) throws IOException {
        }

        public void setStruct(String arg0, Object arg1) throws IOException {
        }

        public String topInstancesQName() {
            return null;
        }

        public void monitor(int notificationInterval, String ... qNames) throws IOException {
        }

        public void monitorModelChanges(int notificationInterval) throws IOException {
        }

        public ModelAccess stepInto(String name) throws IOException {
            return null;
        }

        public ModelAccess stepOut() {
            return null;
        }

        public ConnectorParameter getConnectorParameter() {
            return ModbusTcpIpConnector.this.params;
        }
    }

    public static class Descriptor
    extends AbstractPluginConnectorDescriptor<ModbusItem, Object> {
        public String getName() {
            return ModbusTcpIpConnector.NAME;
        }

        public Class<?> getConnectorType() {
            return ModbusTcpIpConnector.class;
        }

        protected String initId(String id) {
            return "connector-modbusTcp";
        }

        protected <O, I, CO, CI, S extends AdapterSelector<ModbusItem, Object, CO, CI>, A extends ProtocolAdapter<ModbusItem, Object, CO, CI>> Connector<ModbusItem, Object, CO, CI> createConnectorImpl(S selector, Supplier<ConnectorParameter> params, A ... adapter) {
            return new ModbusTcpIpConnector(selector, (ProtocolAdapter<ModbusItem, Object, CO, CI>[])adapter);
        }
    }
}

