/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors.modbustcpipv1;

import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorDescriptor;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.modbustcpipv1.ModbusItem;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import de.iip_ecosphere.platform.connectors.types.TranslatingProtocolAdapter;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import test.de.iip_ecosphere.platform.connectors.ConnectorTest;
import test.de.iip_ecosphere.platform.connectors.MachineCommandInputTranslator;
import test.de.iip_ecosphere.platform.connectors.MachineDataOutputTranslator;
import test.de.iip_ecosphere.platform.connectors.modbustcpipv1.ModbusCommandC;
import test.de.iip_ecosphere.platform.connectors.modbustcpipv1.ModbusCommandCInputTranslator;
import test.de.iip_ecosphere.platform.connectors.modbustcpipv1.ModbusDataC;
import test.de.iip_ecosphere.platform.connectors.modbustcpipv1.ModbusDataCOutputTranslator;

public abstract class AbstractModbusInformationModelConnectorTest<D>
implements MachineCommandInputTranslator.InputCustomizer,
MachineDataOutputTranslator.OutputCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractModbusInformationModelConnectorTest.class);

    protected AbstractModbusInformationModelConnectorTest() {
    }

    public void testConnector(boolean withNotifications) throws IOException {
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.NONE);
        ConnectorTest.assertDescriptorRegistration(this.getConnectorDescriptor());
        final AtomicReference<ModbusDataC> md = new AtomicReference<ModbusDataC>();
        final AtomicInteger count = new AtomicInteger(0);
        Connector<ModbusItem, Object, ModbusDataC, ModbusCommandC> connector = this.createConnector((ProtocolAdapter<ModbusItem, Object, ModbusDataC, ModbusCommandC>)new TranslatingProtocolAdapter(new ModbusDataCOutputTranslator<ModbusItem>(false, ModbusItem.class), new ModbusCommandCInputTranslator<Object>(Object.class)));
        ConnectorTest.assertInstance(connector, (boolean)false);
        ConnectorTest.assertConnectorProperties(connector);
        connector.setReceptionCallback((ReceptionCallback)new ReceptionCallback<ModbusDataC>(){

            public void received(ModbusDataC data) {
                md.set(data);
                count.incrementAndGet();
            }

            public Class<ModbusDataC> getType() {
                return ModbusDataC.class;
            }
        });
        connector.connect(this.getConnectorParameter());
        ConnectorTest.assertInstance(connector, (boolean)true);
        LOGGER.info("Connector '" + connector.getName() + "' started");
        this.block(count, 2);
        ModbusDataC tmp = (ModbusDataC)md.get();
        Assert.assertNotNull((String)"We shall have received some data although the machine is not running", (Object)tmp);
        Assert.assertEquals((long)0L, (long)tmp.getShort());
        Assert.assertEquals((long)0L, (long)tmp.getInteger());
        Assert.assertTrue((tmp.getFloat() < 1.0f ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)tmp.getLong());
        Assert.assertTrue((tmp.getDouble() < 1.0 ? 1 : 0) != 0);
        this.testShort(connector, count, md);
        this.testInt(connector, count, md);
        this.testFloat(connector, count, md);
        this.testLong(connector, count, md);
        this.testDouble(connector, count, md);
        this.testAllToZero(connector, count, md);
        ConnectorTest.assertInstance(connector, (boolean)true);
        connector.disconnect();
        ConnectorTest.assertInstance(connector, (boolean)false);
        LOGGER.info("Connector '" + connector.getName() + "' disconnected");
    }

    private void testShort(Connector<ModbusItem, Object, ModbusDataC, ModbusCommandC> connector, AtomicInteger count, AtomicReference<ModbusDataC> md) throws IOException {
        Short value = 1;
        ModbusCommandC cmd = new ModbusCommandC();
        cmd.setShort((short)value);
        connector.write((Object)cmd);
        this.block(count, 3);
        ModbusDataC tmp = md.get();
        Assert.assertEquals((long)value.shortValue(), (long)tmp.getShort());
        Assert.assertEquals((long)0L, (long)tmp.getInteger());
        Assert.assertTrue((tmp.getFloat() < 1.0f ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)tmp.getLong());
        Assert.assertTrue((tmp.getDouble() < 1.0 ? 1 : 0) != 0);
    }

    private void testInt(Connector<ModbusItem, Object, ModbusDataC, ModbusCommandC> connector, AtomicInteger count, AtomicReference<ModbusDataC> md) throws IOException {
        Integer value = 5;
        ModbusCommandC cmd = new ModbusCommandC();
        cmd.setInteger((int)value);
        connector.write((Object)cmd);
        this.block(count, 4);
        ModbusDataC tmp = md.get();
        Assert.assertEquals((long)1L, (long)tmp.getShort());
        Assert.assertEquals((long)value.intValue(), (long)tmp.getInteger());
        Assert.assertTrue((tmp.getFloat() < 1.0f ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)tmp.getLong());
        Assert.assertTrue((tmp.getDouble() < 1.0 ? 1 : 0) != 0);
    }

    private void testFloat(Connector<ModbusItem, Object, ModbusDataC, ModbusCommandC> connector, AtomicInteger count, AtomicReference<ModbusDataC> md) throws IOException {
        Float value = Float.valueOf(17.23f);
        ModbusCommandC cmd = new ModbusCommandC();
        cmd.setFloat(Float.valueOf(value.floatValue()));
        connector.write((Object)cmd);
        this.block(count, 5);
        ModbusDataC tmp = md.get();
        Assert.assertEquals((long)1L, (long)tmp.getShort());
        Assert.assertEquals((long)5L, (long)tmp.getInteger());
        Assert.assertTrue((tmp.getFloat() > 17.0f ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)tmp.getLong());
        Assert.assertTrue((tmp.getDouble() < 1.0 ? 1 : 0) != 0);
    }

    private void testLong(Connector<ModbusItem, Object, ModbusDataC, ModbusCommandC> connector, AtomicInteger count, AtomicReference<ModbusDataC> md) throws IOException {
        Long value = 21L;
        ModbusCommandC cmd = new ModbusCommandC();
        cmd.setLong((long)value);
        connector.write((Object)cmd);
        this.block(count, 6);
        ModbusDataC tmp = md.get();
        Assert.assertEquals((long)1L, (long)tmp.getShort());
        Assert.assertEquals((long)5L, (long)tmp.getInteger());
        Assert.assertTrue((tmp.getFloat() > 17.0f ? 1 : 0) != 0);
        Assert.assertEquals((long)value, (long)tmp.getLong());
        Assert.assertTrue((tmp.getDouble() < 1.0 ? 1 : 0) != 0);
    }

    private void testDouble(Connector<ModbusItem, Object, ModbusDataC, ModbusCommandC> connector, AtomicInteger count, AtomicReference<ModbusDataC> md) throws IOException {
        Double value = 12345.6789;
        ModbusCommandC cmd = new ModbusCommandC();
        cmd.setDouble((double)value);
        connector.write((Object)cmd);
        this.block(count, 7);
        ModbusDataC tmp = md.get();
        Assert.assertEquals((long)1L, (long)tmp.getShort());
        Assert.assertEquals((long)5L, (long)tmp.getInteger());
        Assert.assertTrue((tmp.getFloat() > 17.0f ? 1 : 0) != 0);
        Assert.assertEquals((long)21L, (long)tmp.getLong());
        Assert.assertTrue((tmp.getDouble() > 12345.0 ? 1 : 0) != 0);
    }

    private void testAllToZero(Connector<ModbusItem, Object, ModbusDataC, ModbusCommandC> connector, AtomicInteger count, AtomicReference<ModbusDataC> md) throws IOException {
        ModbusCommandC cmd = new ModbusCommandC();
        cmd.setShort((short)0);
        cmd.setInteger(0);
        cmd.setFloat(Float.valueOf(0.0f));
        cmd.setLong(0L);
        cmd.setDouble(0.0);
        connector.write((Object)cmd);
        this.block(count, 7);
        ModbusDataC tmp = md.get();
        Assert.assertEquals((long)0L, (long)tmp.getShort());
        Assert.assertEquals((long)0L, (long)tmp.getInteger());
        Assert.assertTrue((tmp.getFloat() < 1.0f ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)tmp.getLong());
        Assert.assertTrue((tmp.getDouble() < 1.0 ? 1 : 0) != 0);
    }

    protected void block(AtomicInteger count, int receptions) {
        int max;
        for (max = 500; count.get() < receptions && max > 0; --max) {
            TimeUtils.sleep((int)200);
        }
        Assert.assertTrue((String)"Operation took too long", (max > 0 ? 1 : 0) != 0);
    }

    protected abstract Class<? extends ConnectorDescriptor> getConnectorDescriptor();

    protected abstract Connector<ModbusItem, Object, ModbusDataC, ModbusCommandC> createConnector(ProtocolAdapter<ModbusItem, Object, ModbusDataC, ModbusCommandC> var1);

    protected abstract ConnectorParameter getConnectorParameter();
}

